/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.validator.DefaultValidationContext;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.ValidationErrorLog;
import oracle.bali.xml.validator.ValidationException;
import oracle.bali.xml.validator.Validator;
import oracle.javatools.util.AccessibleUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;

public final class XmlModelUtils {
    private static final ThreadLocal<LinkedList<DomPosition>> _sCreatorPositions = new ThreadLocal();
    private static volatile boolean _creatorRunning;

    public static String getDisplayName(AbstractModel model, Node node) {
        if (node == null) {
            return null;
        }
        if (!model.isInModelDocumentHierarchy(node)) {
            String notInDocumentFormat = model.getTranslatedString("NODE_NOT_IN_DOCUMENT_FORMAT");
            return FastMessageFormat.formatMessage(notInDocumentFormat, node.getNodeName());
        }
        return model.getXmlMetadataResolver().getMediumDisplayName(node);
    }

    public static Node findFirstNodeByKey(AbstractModel model, XmlKey key) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        Document doc = model.getDocument();
        TreeTraversal traversal = model.getTreeTraversal();
        Node walk = doc;
        while (walk != null) {
            XmlKey walkKey = model.getNodeXmlKey(walk);
            if (key.equals((Object)walkKey)) {
                return walk;
            }
            walk = traversal.getNextNode(walk);
        }
        return null;
    }

    public static void deleteNodesOrRange(AbstractModel model, String txnName, Collection nodes, DomRange range, boolean updateSelection) throws XmlCommitException {
        if (range != null) {
            model.deleteNodes(txnName, range, updateSelection);
        } else if (nodes != null) {
            model.deleteNodes(txnName, nodes, updateSelection);
        }
    }

    public static Collection deleteSelection(AbstractModel model, final String txnName, final boolean updateSelection) throws XmlCommitException {
        final Collection[] ret = new Collection[1];
        new NoNameTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                Selection sel = model.getSelection();
                ret[0] = sel.hasRangeSelection() ? model.deleteNodes(txnName, sel.getRangeSelection(), updateSelection) : model.deleteNodes(txnName, sel.getSelectedNodesList(), updateSelection);
            }
        }.runThrowingXCE(model);
        return ret[0];
    }

    public static Node createNodeFromKey(AbstractModel model, XmlKey xmlKey, DomPosition position) {
        Node node = DomUtils.createNodeFromKey((Document)model.getDocument(), (XmlKey)xmlKey);
        return XmlModelUtils.initializeAndInvokeCreatorIfNeededOrSpecified(model, xmlKey, position, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node initializeAndInvokeCreatorIfNeededOrSpecified(AbstractModel model, XmlKey xmlKey, DomPosition position, Node node) {
        XmlModelUtils.setModalDialogRunning(true);
        try {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            XmlContext context = model.getContext();
            boolean forceCreator = DomUtils.isElement((Node)node) ? !model.getBaseModel().initializeNewNode(node, xmlKey) : true;
            NodeCreator creator = resolver.getCreationWizard(xmlKey);
            if (creator == null && forceCreator) {
                creator = model.getContext().getDefaultNodeCreator(xmlKey);
            }
            if (creator != null) {
                node = XmlModelUtils.invokeCreator(creator, context, xmlKey, position, node);
            }
        }
        finally {
            XmlModelUtils.setModalDialogRunning(false);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getCloneOfSelection(AbstractModel model) {
        model.acquireReadLock();
        try {
            Selection sel = model.getSelection();
            if (sel.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            if (sel.hasRangeSelection()) {
                List list = DomUtils.cloneRangeToList((TreeTraversal)model.getTreeTraversal(), (DomRange)sel.getRangeSelection());
                return list;
            }
            Collection rationalized = DomUtils.rationalizeCollectionOfNodes((TreeTraversal)model.getTreeTraversal(), sel.getSelectedNodesList());
            Collection collection = XmlModelUtils._cloneNodes(rationalized);
            return collection;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public static NodeCustomizer getCustomizerOrDefault(AbstractModel model, XmlKey key, Node node) {
        NodeCustomizer ret = XmlModelUtils.getCustomizer(model, key, node);
        if (ret == null) {
            ret = model.getContext().getDefaultNodeCustomizer(key);
        }
        return ret;
    }

    public static NodeCustomizer getCustomizer(AbstractModel model, XmlKey key, Node node) {
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        if (node != null) {
            return resolver.getCustomizer(node);
        }
        return resolver.getCustomizer(key);
    }

    public static Node convert(XmlModel model, Node nodeToConvert, XmlKey convertTo, Set invalidNodes) {
        short sourceType = nodeToConvert.getNodeType();
        short targetType = convertTo.getNodeType();
        if (sourceType == 3 && targetType == 4) {
            CDATASection ret = model.getDocument().createCDATASection(nodeToConvert.getNodeValue());
            nodeToConvert.getParentNode().replaceChild(ret, nodeToConvert);
            return ret;
        }
        if (sourceType == 4 && targetType == 3) {
            Text ret = model.getDocument().createTextNode(nodeToConvert.getNodeValue());
            nodeToConvert.getParentNode().replaceChild(ret, nodeToConvert);
            return ret;
        }
        if (1 == sourceType && 1 == targetType) {
            return XmlModelUtils._convertElement(model, nodeToConvert, convertTo, invalidNodes);
        }
        return null;
    }

    public static Node surroundSelection(XmlModel model, XmlKey surroundingKey) throws XmlCommitException {
        Collection insertedChildren;
        List nodesToDelete;
        DomRange rangeToDelete;
        Collection clonedNodes;
        if (model == null || surroundingKey == null || surroundingKey.getNodeType() != 1) {
            throw new IllegalArgumentException("Invalid arguments passed to surround");
        }
        Selection selection = model.getSelection();
        if (selection.hasRangeSelection()) {
            clonedNodes = DomUtils.cloneRangeToList((TreeTraversal)model.getTreeTraversal(), (DomRange)selection.getRangeSelection());
            DomPosition origStart = selection.getRangeSelection().getStart();
            selection.setCursorLocation(origStart);
            model.splitAtPositionIfNeeded(origStart, true);
            rangeToDelete = selection.getRangeSelection();
            nodesToDelete = null;
        } else {
            List nodes = XmlModelUtils._getSelectedNodesInOrderUnderOneParent(selection);
            if (nodes.isEmpty()) {
                return null;
            }
            nodesToDelete = nodes;
            selection.setCursorLocation(DomPositionFactory.before((Node)((Node)nodes.get(0))));
            clonedNodes = XmlModelUtils._cloneNodes(nodesToDelete);
            rangeToDelete = null;
        }
        Node createdNode = XmlModelUtils.createNodeFromKey(model, surroundingKey, selection.getCursorLocation());
        XmlModelUtils.deleteNodesOrRange(model, "delete old nodes in surround", nodesToDelete, rangeToDelete, false);
        Node surroundingNode = model.insertXmlKey(surroundingKey, selection.getCursorLocation(), createdNode);
        if (surroundingNode != null && (insertedChildren = model.insertNodes(DomPositionFactory.inside((Node)surroundingNode), "inserting old nodes' clones in surround", clonedNodes, false)) != null) {
            return surroundingNode;
        }
        return null;
    }

    public static boolean fixedAttributeMightHaveChanged(XmlModelEvent event) {
        if (event.matchesFlags(8)) {
            NodeChangeDetails changeDetails = event.getNodeChangeDetails();
            if (changeDetails != null && changeDetails != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                Set changedNodes = changeDetails.getChangedNodes();
                if (!changedNodes.isEmpty()) {
                    for (Node changedNode : changedNodes) {
                        QualifiedName fixedAttrQName;
                        Map changedAttrs;
                        XmlKey changedNodeKey;
                        QualifiedName changedNodeQName;
                        String fixedAttrName;
                        if (!DomUtils.isElement((Node)changedNode) || (fixedAttrName = (changedNodeQName = (changedNodeKey = event.getModel().getNodeXmlKey(changedNode)).getElementQName()).getAttributeName()) == null || !(changedAttrs = changeDetails.getPriorAttributeValues(changedNode)).containsKey(fixedAttrQName = QualifiedName.getQualifiedName((String)changedNodeQName.getAttributeNamespace(), (String)fixedAttrName))) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node invokeCreator(NodeCreator creator, XmlContext context, XmlKey key, DomPosition position, Node prototypeNode) {
        try {
            XmlModelUtils._pushCreatorPosition(position);
            Node node = creator.createNode(context, key, position, prototypeNode);
            return node;
        }
        finally {
            XmlModelUtils._popCreatorPosition(position);
        }
    }

    public static TreeTraversal getPropertyEditorOwnerTraversal(Node propertyEditorOwnerNode) {
        DomPosition pos;
        if (propertyEditorOwnerNode != null && !DomUtils.isInDocumentHierarchy((Node)propertyEditorOwnerNode) && (pos = XmlModelUtils._peekCreatorPosition()) != null) {
            return new SimulateInsertingFragmentTreeTraversal(pos, Collections.singletonList(propertyEditorOwnerNode));
        }
        return DocumentTreeTraversal.INSTANCE;
    }

    public static String getUniqueValue(XmlModel model, XmlKey key, String prefix) {
        Integer i = XmlModelUtils.getUniqueInteger(model, key);
        return prefix.concat(i.toString());
    }

    public static Integer getUniqueInteger(XmlModel model, XmlKey key) {
        Integer lastValue = XmlModelUtils._getHighestIntegerInUse(model, key);
        if (lastValue == null) {
            lastValue = 1;
        } else if (lastValue != Integer.MAX_VALUE) {
            Integer n = lastValue;
            Integer n2 = lastValue = Integer.valueOf(lastValue + 1);
        }
        return lastValue;
    }

    public static XmlKey getOwnerTraversalDerivedXmlKey(TreeTraversal ownerTraversal, Node n, XmlView xmlView) {
        ArrayList<QualifiedName> qualifiedNamePath = new ArrayList<QualifiedName>();
        qualifiedNamePath.add(0, DomUtils.getQualifiedName((Node)n));
        Node parentNode = ownerTraversal.getParentNode(n);
        while (parentNode != null && !DomUtils.isInDocumentHierarchy((Node)parentNode)) {
            qualifiedNamePath.add(0, DomUtils.getQualifiedName((Node)parentNode));
            parentNode = ownerTraversal.getParentNode(parentNode);
        }
        if (parentNode == null) {
            return null;
        }
        XmlKey parentKey = xmlView.getNodeXmlKey(parentNode);
        XmlKey xmlKey = DerivedXmlKey.createElementKey((GrammarResolver)xmlView.getContext().getGrammarResolver(), (XmlKey)parentKey, qualifiedNamePath);
        return xmlKey;
    }

    public static void setModalDialogRunning(boolean b) {
        _creatorRunning = b;
    }

    public static void throwIfAccessibilityThreadAccessDisallowed() {
        if (AccessibleUtils.isAssistiveTechnologySet() && !SwingUtilities.isEventDispatchThread() && _creatorRunning) {
            throw new RuntimeException("Accessbility thread access to the model on non-event thread while XMLEF modal dialogs are running, is disallowed.");
        }
    }

    private static Integer _getHighestIntegerInUse(XmlModel model, XmlKey key) {
        int highest = 0;
        for (Node node : DocumentTreeTraversal.INSTANCE.allNodes((Node)model.getDocument())) {
            if (!DomUtils.isElement((Node)node)) continue;
            XmlKey tmpKey = null;
            tmpKey = model.getNodeXmlKey(node);
            if (tmpKey.equals((Object)key)) {
                highest = XmlModelUtils._getHigerIntForNode(node, highest);
                continue;
            }
            NamedNodeMap nnm = node.getAttributes();
            if (nnm == null) continue;
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node tmpNode = nnm.item(i);
                tmpKey = model.getNodeXmlKey(tmpNode);
                if (!tmpKey.equals((Object)key)) continue;
                highest = XmlModelUtils._getHigerIntForNode(tmpNode, highest);
            }
        }
        if (highest == 0) {
            return null;
        }
        return highest;
    }

    private static int _getHigerIntForNode(Node n, int h) {
        String s = XmlModelUtils._getIntFromString(n.getNodeValue());
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                if (i > h) {
                    h = i;
                }
            }
            catch (NumberFormatException ex) {
                return h;
            }
        }
        return h;
    }

    private static String _getIntFromString(String value) {
        if (value == null) {
            return null;
        }
        char[] a = new char[value.length()];
        value.getChars(0, value.length(), a, 0);
        int beginIndex = 0;
        int numLength = 0;
        boolean inside = false;
        for (int currIndex = 0; currIndex < value.length(); ++currIndex) {
            if (Character.isDigit(a[currIndex])) {
                if (numLength == 0) {
                    inside = true;
                    beginIndex = currIndex;
                }
                ++numLength;
                continue;
            }
            if (inside) break;
        }
        if (numLength == 0) {
            return null;
        }
        return value.substring(beginIndex, beginIndex + numLength);
    }

    private static List _getSelectedNodesInOrderUnderOneParent(Selection selection) {
        int count = selection.getSelectedNodesCount();
        if (count == 1) {
            return selection.getSelectedNodesList();
        }
        if (count > 1) {
            Node parent = selection.getFirstSelectedNode().getParentNode();
            ArrayList<Node> out = new ArrayList<Node>(selection.getSelectedNodesCount());
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!selection.contains(child)) continue;
                out.add(child);
            }
            if (out.size() == count) {
                return out;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Node _convertElement(XmlModel model, Node nodeToConvert, XmlKey convertTo, Set invalidNodes) {
        boolean ok;
        if (XmlModelUtils._wouldViolateMaxoccurs(nodeToConvert, convertTo)) {
            return null;
        }
        Element created = (Element)DomUtils.createNodeFromKey((Document)model.getDocument(), (XmlKey)convertTo);
        XmlModelUtils._copyAttributes(convertTo, (Element)nodeToConvert, created);
        XmlModelUtils._copyChildren(nodeToConvert, created);
        Node parent = nodeToConvert.getParentNode();
        model.fixPrefixes(parent, created);
        parent.replaceChild(created, nodeToConvert);
        boolean customizerRequired = !model.initializeNewNode(created, convertTo);
        NodeCustomizer customizer = null;
        customizer = customizerRequired ? XmlModelUtils.getCustomizerOrDefault(model, convertTo, created) : model.getXmlMetadataResolver().getCustomizer(created);
        if (customizer != null && !(ok = customizer.customizeNode(model.getContext(), created, convertTo))) {
            return null;
        }
        if (created == null) {
            return null;
        }
        XmlModelUtils._handleInvalidNodes(model, created, invalidNodes);
        invalidNodes.remove(created);
        return created;
    }

    private static boolean _wouldViolateMaxoccurs(Node nodeToConvert, XmlKey convertTo) {
        Node parentNode = nodeToConvert.getParentNode();
        QualifiedName elementQName = convertTo.getElementQName();
        if ("http://xmlns.oracle.com/uix/ui".equals(elementQName.getNamespace()) && "contents".equals(elementQName.getName())) {
            Node existing = DomUtils.getNamedChild((Node)parentNode, (String)elementQName.getNamespace(), (String)elementQName.getName());
            return existing != null;
        }
        return false;
    }

    private static void _copyAttributes(XmlKey targetKey, Element nodeToConvert, Element n) {
        QualifiedName qname = targetKey.getElementQName();
        String fixedAttrName = qname.getAttributeName();
        String fixedAttrNS = qname.getAttributeNamespace();
        NamedNodeMap attributes = nodeToConvert.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (XmlModelUtils._hasName(attr, fixedAttrNS, fixedAttrName)) continue;
            Attr attrCopy = (Attr)attr.cloneNode(true);
            n.setAttributeNodeNS(attrCopy);
        }
    }

    private static boolean _hasName(Node node, String ns, String name) {
        String nodeName = DomUtils.getLocalName((Node)node);
        if (nodeName.equals(name)) {
            String nodeNS = node.getNamespaceURI();
            if (ns == null) {
                return nodeNS == null;
            }
            return ns.equals(nodeNS);
        }
        return false;
    }

    private static void _copyChildren(Node nodeToConvert, Node n) {
        NodeList children = nodeToConvert.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            n.appendChild(child.cloneNode(true));
        }
    }

    private static void _handleInvalidNodes(XmlModel model, Node n, Set invalidNodes) {
        ValidationErrorLog errorLog = new ValidationErrorLog();
        DefaultValidationContext valContext = new DefaultValidationContext(model.getContext().getGrammarResolver(), (ErrorHandler)errorLog, null);
        boolean isValid = Validator.validateSubtree((ValidationContext)valContext, (Node)n);
        if (!isValid) {
            for (Object error : errorLog.getErrors()) {
                if (!(error instanceof ValidationException)) continue;
                ValidationException ve = (ValidationException)((Object)error);
                invalidNodes.add(ve.getInvalidNode());
            }
        }
    }

    private static Collection _cloneNodes(Collection in) {
        ArrayList<Node> out = new ArrayList<Node>(in.size());
        Iterator itor = in.iterator();
        while (itor.hasNext()) {
            out.add(((Node)itor.next()).cloneNode(true));
        }
        return out;
    }

    private static void _pushCreatorPosition(DomPosition position) {
        assert (position != null);
        LinkedList<Object> stack = _sCreatorPositions.get();
        if (stack == null) {
            stack = new LinkedList();
            _sCreatorPositions.set(stack);
        }
        stack.addLast(position);
    }

    private static void _popCreatorPosition(DomPosition position) {
        assert (position != null);
        LinkedList<DomPosition> stack = _sCreatorPositions.get();
        assert (stack != null);
        assert (!stack.isEmpty());
        stack.removeLast();
    }

    private static DomPosition _peekCreatorPosition() {
        LinkedList<DomPosition> stack = _sCreatorPositions.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.getLast();
    }

    private XmlModelUtils() {
    }
}

