/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.translation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.translation.TranslationSource;

public class PropertyResourceBundleSource
implements TranslationSource {
    private boolean _isLoaded = false;
    private final String _qualifiedName;
    private Properties _properties;
    private static final Logger _LOG = Logger.getLogger("oracle.bali.xml.translation.PropertyResourceBundleSource");

    public PropertyResourceBundleSource(String qualifiedName) {
        this._qualifiedName = qualifiedName;
    }

    @Override
    public String getString(String key) {
        if (this._properties == null) {
            if (this._isLoaded) {
                return null;
            }
            this._buildProperties();
        }
        if (this._properties == null) {
            return null;
        }
        return this._properties.getProperty(key);
    }

    @Override
    public void setString(String key, String value) {
        if (this._properties == null) {
            if (this._isLoaded) {
                return;
            }
            this._buildProperties();
        }
        if (this._properties == null) {
            return;
        }
        this._properties.setProperty(key, value);
        this._saveProperties();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private void _buildProperties() {
        this._isLoaded = true;
        InputStream propFile = this._getSourceInputStream();
        if (propFile != null) {
            this._properties = new Properties();
            try {
                this._properties.load(propFile);
            }
            catch (IOException ioe) {
                this._logException(ioe);
            }
        }
    }

    private void _saveProperties() {
        if (!this._isLoaded || this._properties == null) {
            return;
        }
        OutputStream toSave = this._getSourceOutputStream();
        if (toSave == null) {
            return;
        }
        try {
            this._properties.store(toSave, null);
        }
        catch (IOException ioe) {
            this._logException(ioe);
        }
    }

    private InputStream _getSourceInputStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this._qualifiedName);
    }

    private OutputStream _getSourceOutputStream() {
        URL file = this.getClass().getClassLoader().getResource(this._qualifiedName);
        try {
            File f = new File(file.toExternalForm());
            return new FileOutputStream(f);
        }
        catch (IOException ioe) {
            this._logException(ioe);
            return null;
        }
    }

    private void _logException(Throwable t) {
        _LOG.log(Level.WARNING, t.getMessage(), t);
    }
}

