/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.tools.StandaloneXmlUpdater;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

public class StandaloneXmlContext
extends XmlContext {
    private final TextBuffer _buffer;
    private URL _url;

    public StandaloneXmlContext(URL url) throws IOException {
        this(url, null);
    }

    public StandaloneXmlContext(InputStream stream) throws IOException {
        this(null, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandaloneXmlContext(URL url, InputStream stream) throws IOException {
        if (stream == null && url == null) {
            throw new IllegalArgumentException("need either url or stream");
        }
        boolean openedStream = false;
        if (stream == null) {
            stream = url.openStream();
            openedStream = true;
        } else if (url == null) {
            url = this.getClass().getResource(System.identityHashCode(this) + ".xml");
        }
        this._url = url;
        try {
            String encoding = "UTF-8";
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            this._buffer = TextBufferFactory.createTextBuffer();
            this._buffer.read((Reader)reader);
            this.finishInitialization();
            this.setModel(this.createXmlModel());
        }
        finally {
            if (openedStream) {
                stream.close();
            }
        }
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    public static void updateFile(String file, StandaloneXmlUpdater updater) {
        try {
            URL url = new File(file).toURL();
            StandaloneXmlContext context = new StandaloneXmlContext(url);
            context.getLogger().addHandler(new StreamHandler(System.out, new SimpleFormatter()));
            updater.updateModel(context.getModel());
            context.save(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public URL getURLForRelativePath(String relativePath) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getRelativePathForURL(URL absoluteURL) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void save(OutputStream stream) throws IOException {
        String encoding = "UTF-8";
        OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
        this._buffer.write((Writer)writer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(URL url) throws IOException {
        OutputStream stream = url.openConnection().getOutputStream();
        try {
            this.save(stream);
        }
        finally {
            stream.close();
        }
    }

    protected XmlModel createXmlModel() {
        return new XmlModel();
    }

    @Override
    protected DomModel createSourceDomModel(XmlModel xmlModel) {
        BufferDomModelPluginFactory pluginFactory = new BufferDomModelPluginFactory(this._buffer, (DOMImplementation)new XMLDOMImplementation(), (ParserConfiguration)new DefaultParserConfiguration(), (DocumentScannerFactory)new DefaultDocumentScannerFactory());
        DomModel dom = DomModelFactory.createDomModel(this, pluginFactory, xmlModel.getWhitespaceHandler());
        return dom;
    }
}

