/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.tools.StandaloneXmlContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandaloneMetadataCleanupTool {
    public static final void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage:  StandaloneMetadataCleanupTool metadataInput");
            System.exit(1);
        }
        String metadataFile = args[0];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(metadataFile);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("file not found " + metadataFile);
            System.exit(1);
        }
        try {
            StandaloneXmlContext context = new StandaloneXmlContext(fis);
            boolean didTxn = new FixedNameTransactionTask("Cleanup metadata file"){

                @Override
                protected void performTask(AbstractModel model) throws XmlCommitException {
                    try {
                        StandaloneMetadataCleanupTool._checkElement(model.getDocument().getDocumentElement());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.run(context.getModel());
            fis.close();
            FileOutputStream fos = new FileOutputStream(metadataFile);
            context.save(fos);
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean _checkElement(Element e) {
        if (e == null || !"grammarMetadata".equals(e.getLocalName()) && !"elementMetadata".equals(e.getLocalName()) && !"attributeMetadata".equals(e.getLocalName())) {
            return false;
        }
        NodeList children = e.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                if (!StandaloneMetadataCleanupTool._checkElement((Element)n)) continue;
                e.removeChild(n);
                continue;
            }
            if (n.getNodeType() != 3 || !StandaloneMetadataCleanupTool._isEmpty(n.getNodeValue())) continue;
            e.removeChild(n);
        }
        return e.getChildNodes().getLength() <= 0;
    }

    private static boolean _isEmpty(String s) {
        return "".equals(s.trim());
    }
}

