/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.string;

import oracle.bali.xml.share.string.StringChange;

public final class StringChangeUtils {
    public static StringChange computeStringChange(String oldValue, String newValue) {
        int[] tmp = StringChangeUtils.getSameChars(oldValue, newValue);
        int startSameChars = tmp[0];
        int endSameChars = tmp[1];
        int oldLen = oldValue.length();
        int newLen = newValue.length();
        int endOldIdx = Math.max(oldLen - endSameChars, startSameChars);
        int endNewIdx = Math.max(newLen - endSameChars, startSameChars);
        int deletedCharCount = endOldIdx - startSameChars;
        int insertedCharCount = endNewIdx - startSameChars;
        String insertedChars = newValue.substring(startSameChars, startSameChars + insertedCharCount);
        return new StringChange(startSameChars, insertedChars, deletedCharCount);
    }

    public static int[] getSameChars(String one, String two) {
        char t;
        char o;
        int endChars;
        char t2;
        char o2;
        int startChars;
        int oneLen = one.length();
        int twoLen = two.length();
        for (startChars = 0; startChars < oneLen && startChars < twoLen && (o2 = one.charAt(startChars)) == (t2 = two.charAt(startChars)); ++startChars) {
        }
        for (endChars = 0; endChars < oneLen && endChars < twoLen && oneLen - endChars > startChars && twoLen - endChars > startChars && (o = one.charAt(oneLen - endChars - 1)) == (t = two.charAt(twoLen - endChars - 1)); ++endChars) {
        }
        return new int[]{startChars, endChars};
    }

    private StringChangeUtils() {
    }
}

