/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.javatools.datatransfer.ExtendedTransferable;

class PollingClipboardManager
extends AWTClipboardManager {
    private int _state = 0;
    private boolean _ownsClipboard = false;
    private Reference _cachedContentsRef = null;
    private final Clipboard _clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final ClipboardOwner _owner = new Owner();
    private static final int _INITIAL_STATE = 0;
    private static final int _POLLING_STATE = 1;
    private static final int _DISABLED_STATE = 2;
    private static final long _MIN_MS_BETWEEN_CLIPBOARD_POLLS = 1000L;
    private static final long _FAST_POLL_THRESHOLD = 100L;

    @Override
    public synchronized Transferable getContents() {
        Transferable contents = this._cached();
        if (contents == null) {
            long before = System.currentTimeMillis();
            contents = this._getContentsDirectly();
            long after = System.currentTimeMillis();
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Foreground clipboard poll in {0} ms", new Long(after - before));
            }
            this._updateCachedContents(contents);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(Transferable newContents) throws IllegalStateException {
        this._clipboard.setContents(newContents, this._owner);
        this.getLogger().log(Level.FINER, "Set clipboard contents to {0}", newContents);
        PollingClipboardManager pollingClipboardManager = this;
        synchronized (pollingClipboardManager) {
            this._setClipboardOwnership(true);
            this._updateCachedContents(newContents);
        }
    }

    @Override
    protected synchronized void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        this._potentiallySwitchState();
    }

    @Override
    protected synchronized void applicationActiveChanged() {
        super.applicationActiveChanged();
        this._potentiallySwitchState();
    }

    PollingClipboardManager() {
    }

    private synchronized boolean _shouldBePolling() {
        return !this._ownsClipboard && this.isApplicationActive() && this.areFlavorListenersAttached();
    }

    private synchronized void _potentiallySwitchState() {
        boolean shouldPoll = this._shouldBePolling();
        if (shouldPoll) {
            if (this._state == 0) {
                this._transitionInitialToPolling();
            } else if (this._state == 2) {
                this._transitionDisabledToPolling();
            }
        } else if (this._state == 1) {
            this._transitionPollingToDisabled();
        }
    }

    private synchronized void _setClipboardOwnership(boolean newVal) {
        if (newVal != this._ownsClipboard) {
            this._ownsClipboard = newVal;
            this._potentiallySwitchState();
        }
    }

    private synchronized void _transitionInitialToPolling() {
        assert (this._state == 0);
        this._state = 1;
        this.getLogger().finer("Transitioning from initial to polling");
        Thread pollThread = new Thread(new Poller());
        pollThread.setName(this.getClass().getName());
        pollThread.setDaemon(true);
        pollThread.setPriority(1);
        pollThread.start();
        this.getLogger().finer("Polling thread started");
    }

    private synchronized void _transitionPollingToDisabled() {
        assert (this._state == 1);
        this._state = 2;
        this.getLogger().finer("Transitioning from polling to disabled");
    }

    private synchronized void _transitionDisabledToPolling() {
        assert (this._state == 2);
        this._state = 1;
        this.getLogger().finer("Transitioning from disabled to polling");
    }

    private Transferable _getContentsDirectly() {
        try {
            Transferable contents = this._clipboard.getContents(this);
            if (contents == null) {
                contents = EMPTY_CONTENTS;
            }
            this.getLogger().log(Level.FINER, "Fetched clipboard contents: {0}", contents);
            ExtendedTransferable extended = ExtendedTransferable.getExtendedTransferable((Transferable)contents);
            if (extended != null) {
                contents = extended;
            }
            return contents;
        }
        catch (IllegalStateException e) {
            this.getLogger().log(Level.FINER, "Got IllegalStateException fetching clipboard contents!", e);
            return UNKNOWN_CONTENTS;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getLogger().log(Level.FINER, "Got unexpected exception fetching clipboard contents!", t);
            return UNKNOWN_CONTENTS;
        }
    }

    private synchronized void _updateCachedContents(Transferable newContents) {
        Transferable cached;
        if (newContents == null) {
            newContents = EMPTY_CONTENTS;
        }
        if (newContents != (cached = this._cached())) {
            Transferable oldContents = cached;
            this._cachedContentsRef = new SoftReference<Transferable>(newContents);
            if (oldContents == null || PollingClipboardManager.areDifferent(oldContents.getTransferDataFlavors(), newContents.getTransferDataFlavors())) {
                this.notifyFlavorListeners();
            }
        }
    }

    private synchronized boolean _isInPollingState() {
        return this._state == 1;
    }

    private synchronized Transferable _cached() {
        return this._cachedContentsRef == null ? null : (Transferable)this._cachedContentsRef.get();
    }

    private class Poller
    implements Runnable {
        private long _msUntilNextPoll = 1000L;

        private Poller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PollingClipboardManager pollingClipboardManager = PollingClipboardManager.this;
            synchronized (pollingClipboardManager) {
                assert (PollingClipboardManager.this._state != 0);
            }
            while (true) {
                if (PollingClipboardManager.this._isInPollingState()) {
                    long before = System.currentTimeMillis();
                    Transferable contents = PollingClipboardManager.this._getContentsDirectly();
                    long after = System.currentTimeMillis();
                    long delta = after - before;
                    if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                        PollingClipboardManager.this.getLogger().log(Level.FINER, "Background clipboard poll in {0} ms", new Long(delta));
                    }
                    PollingClipboardManager.this._updateCachedContents(contents);
                    if (delta < 100L) {
                        if (this._msUntilNextPoll != 1000L) {
                            PollingClipboardManager.this.getLogger().finer("Clipboard poll time reset to minimum");
                            this._msUntilNextPoll = 1000L;
                        }
                    } else {
                        this._msUntilNextPoll = 1000L + 5L * delta;
                        if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                            PollingClipboardManager.this.getLogger().log(Level.FINER, "Clipboard poll time set to {0} ms", new Long(this._msUntilNextPoll));
                        }
                    }
                }
                try {
                    Thread.sleep(this._msUntilNextPoll);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class Owner
    implements ClipboardOwner {
        private Owner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            PollingClipboardManager.this._setClipboardOwnership(false);
        }
    }
}

