/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.xpath;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.xpath.XPathNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XPathProvider {
    public static final String X_PATH_1_0 = "1.0";
    public static final String X_PATH_2_0 = "2.0";
    protected final XmlContext _context;
    protected final XPathNamespaceContext _nsContext = new XPathNamespaceContext();

    public XPathProvider(XmlContext context) {
        this._context = context;
    }

    public abstract String getVersion();

    public void addNamespacePrefix(String prefix, String namespace) {
        this._nsContext.addNamespacePrefix(prefix, namespace);
    }

    public void removeNamespacePrefix(String prefix) {
        this._nsContext.removeNamespacePrefix(prefix);
    }

    public Map<String, String> getPrefixNamespaceMap() {
        return this._nsContext.getPrefixNamespaceMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNSPrefixesInDoc() {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            Map<String, Set<String>> nsMap = model.getNamespacesInDoc();
            for (Map.Entry<String, Set<String>> entry : nsMap.entrySet()) {
                String namespace = entry.getKey();
                Set<String> set = entry.getValue();
                if (set.isEmpty()) {
                    XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)namespace);
                    String prefix = model.getXmlMetadataResolver().getPreferredPrefix(nsKey);
                    if (prefix == null || "".equals(prefix)) {
                        prefix = this.getPrefix(namespace);
                    }
                    this._nsContext.addNamespacePrefix(prefix, namespace);
                    continue;
                }
                for (String prefix : set) {
                    this._nsContext.addNamespacePrefix(prefix, namespace);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateXPath(String expression, QName returnType) throws XPathExpressionException {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            Document document = model.getDocument();
            Object object = this.evaluateXPath(expression, document, returnType);
            return object;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateXPath(String expression, Node subtreeRoot, QName returnType) throws XPathExpressionException {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            XPathFactory factory = this.getXPathFactory();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(this._nsContext);
            Object object = xpath.evaluate(expression, subtreeRoot, returnType);
            return object;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public abstract XPathFactory getXPathFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCanonicalXPathForNode(Node node) {
        XmlModel model = this._context.getModel();
        model.acquireReadLock();
        try {
            if (node != null) {
                switch (node.getNodeType()) {
                    case 9: {
                        String string = "/";
                        return string;
                    }
                    case 1: {
                        int index = this.getChildIndex(node);
                        String ns = node.getNamespaceURI();
                        String xpath = "/";
                        if (ns != null) {
                            xpath = xpath + this.getPrefix(ns) + ":";
                        }
                        xpath = xpath + node.getLocalName() + "[" + index + "]";
                        if (node.getParentNode() != null && node.getParentNode() != node.getOwnerDocument()) {
                            xpath = this.getCanonicalXPathForNode(node.getParentNode()) + xpath;
                        }
                        String string = xpath;
                        return string;
                    }
                    case 2: {
                        String index = this.getCanonicalXPathForNode(((Attr)node).getOwnerElement()) + "/@" + node.getLocalName();
                        return index;
                    }
                    case 3: 
                    case 4: {
                        String index = this.getCanonicalXPathForNode(node.getParentNode()) + "/text()";
                        return index;
                    }
                    case 8: {
                        int index = this.getChildIndex(node);
                        String xpath = "/comment()[" + index + "]";
                        Node parent = node.getParentNode();
                        if (parent.getNodeType() != 9) {
                            xpath = this.getCanonicalXPathForNode(parent) + xpath;
                        }
                        String string = xpath;
                        return string;
                    }
                    case 7: {
                        int index = this.getChildIndex(node);
                        String xpath = "/processing-instruction()[" + index + "]";
                        Node parent = node.getParentNode();
                        if (parent.getNodeType() != 9) {
                            xpath = this.getCanonicalXPathForNode(parent) + xpath;
                        }
                        String string = xpath;
                        return string;
                    }
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return null;
    }

    private String getPrefix(String namespace) {
        String prefix = this._nsContext.getPrefix(namespace);
        if (prefix == null) {
            int index = 1;
            while (prefix == null) {
                String tmp = "ns" + index;
                if (!this._nsContext.containsPrefix(tmp)) {
                    prefix = tmp;
                    this._nsContext.addNamespacePrefix(prefix, namespace);
                }
                ++index;
            }
        }
        return prefix;
    }

    private int getChildIndex(Node node) {
        int index = 1;
        short nodeType = node.getNodeType();
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            for (Node currSibling = parentNode.getFirstChild(); currSibling != node; currSibling = currSibling.getNextSibling()) {
                short currSibType = currSibling.getNodeType();
                if (nodeType != currSibType) continue;
                if (nodeType == 1) {
                    QualifiedName siblingQN;
                    QualifiedName nodeQN = DomUtils.getQualifiedName((Node)node);
                    if (!nodeQN.equals((Object)(siblingQN = DomUtils.getQualifiedName((Node)currSibling)))) continue;
                    ++index;
                    continue;
                }
                ++index;
            }
        }
        return index;
    }
}

