/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.traversal;

import java.util.List;
import java.util.Stack;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlTraversalHandler
implements TraversalHandler {
    Stack<List<TraversalHandler>> _handlerStack = new Stack();

    @Override
    public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        List<TraversalHandler> handlers = resolver.getTraversalHandlers(node);
        this._handleStartNode(handlers, model, node, data);
        this._handlerStack.push(handlers);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                handlers = resolver.getTraversalHandlers(attr);
                this._handleStartNode(handlers, model, attr, data);
            }
        }
    }

    @Override
    public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
        List<TraversalHandler> handlers = this._handlerStack.pop();
        if (handlers != null) {
            for (TraversalHandler handler : handlers) {
                handler.handleEndNode(model, node, data);
            }
        }
    }

    private void _handleStartNode(List<TraversalHandler> handlers, XmlModel model, Node node, MutableTraversalData data) {
        if (handlers != null) {
            for (TraversalHandler handler : handlers) {
                handler.handleStartNode(model, node, data);
            }
        }
    }
}

