/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.task;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlReadOnlyException;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.logging.LogUtils;

public abstract class StandardTransactionTask {
    private TransactionOptions _transOptions;
    private static final Map _sAlreadyLoggedExceptions = Collections.synchronizedMap(new WeakHashMap());

    public final boolean run(AbstractModel model) {
        try {
            return this.runThrowingXCE(model);
        }
        catch (XmlCommitException xce) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runThrowingXCE(AbstractModel model) throws XmlCommitException {
        block25: {
            if (model == null) {
                throw new IllegalArgumentException("null model");
            }
            model.acquireReadLock();
            try {
                if (!this.requiresTask(model)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                model.releaseReadLock();
            }
            AbstractModel wrapperModel = this.__getWrapperTransactionModel(model);
            String txnName = this.getTransactionNameWithoutModelAccess();
            this.__startWrapperTransaction(wrapperModel, txnName);
            try {
                if (this.requiresTask(model)) {
                    if (model == wrapperModel && this._isOkTxnName(txnName)) {
                        this.performTask(model);
                    } else {
                        if (txnName == null) {
                            txnName = this.computeTransactionName(model);
                        }
                        boolean innerCommitted = false;
                        if (this._isOkTxnName(txnName)) {
                            model.startTransaction(txnName);
                            try {
                                this.performTask(model);
                                model.commitTransaction();
                                innerCommitted = true;
                            }
                            finally {
                                if (!innerCommitted) {
                                    model.rollbackTransaction();
                                }
                            }
                        }
                    }
                }
                this.__commitWrapperTransaction(wrapperModel);
                return true;
            }
            catch (CancelTransactionException cte) {
                wrapperModel.rollbackTransaction();
            }
            catch (XmlReadOnlyException xroe) {
                boolean rethrow = this.handleThrownXmlReadOnlyException(model, xroe, txnName);
                wrapperModel.rollbackTransaction();
                if (rethrow) {
                    throw xroe;
                }
            }
            catch (XmlCommitException xce) {
                wrapperModel.rollbackTransaction();
                boolean rethrow = this.handleThrownXmlCommitException(model, xce, txnName);
                if (rethrow) {
                    throw xce;
                }
            }
            catch (RuntimeException re) {
                wrapperModel.rollbackTransaction();
                boolean rethrow = this.handleThrownRuntimeException(model, re, txnName);
                if (rethrow) {
                    throw re;
                }
            }
            catch (Error error) {
                wrapperModel.rollbackTransaction();
                boolean rethrow = this.handleThrownError(model, error, txnName);
                if (!rethrow) break block25;
                throw error;
            }
        }
        return false;
    }

    protected String getTransactionNameWithoutModelAccess() {
        return null;
    }

    protected TransactionOptions getTransactionOptions(String txnName) {
        return new TransactionOptions(txnName);
    }

    protected String computeTransactionName(AbstractModel model) {
        return null;
    }

    protected abstract void performTask(AbstractModel var1) throws XmlCommitException;

    protected boolean requiresTask(AbstractModel model) {
        return true;
    }

    protected boolean handleThrownXmlCommitException(AbstractModel model, XmlCommitException xce, String txnName) {
        this.logException(model, xce, txnName, Level.FINER);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleThrownXmlReadOnlyException(AbstractModel model, XmlReadOnlyException xroe, String txnName) {
        model.acquireReadLock();
        try {
            TransactionToken token = model.getContext().getTransactionToken();
            if (token != null) {
                token.setAbortOnCompletion();
            }
        }
        finally {
            model.releaseReadLock();
        }
        return true;
    }

    protected boolean handleThrownError(AbstractModel model, Error error, String txnName) {
        this.logException(model, error, txnName, Level.WARNING);
        return true;
    }

    protected boolean handleThrownRuntimeException(AbstractModel model, RuntimeException re, String txnName) {
        this.logException(model, re, txnName, Level.WARNING);
        return true;
    }

    protected void logException(AbstractModel model, Throwable t, String txnName, Level level) {
        level = Level.WARNING;
        Logger log = this.getLogger(model);
        assert (log != null);
        String extraMsg = "";
        Level alreadyLoggedLevel = _sAlreadyLoggedExceptions.put(t, level);
        if (alreadyLoggedLevel != null && alreadyLoggedLevel.intValue() >= level.intValue()) {
            t = null;
            extraMsg = "(exception previously logged)";
        }
        LogUtils.log((Logger)log, (Level)level, (String)"Exception in task {0} on model {1}; txn name={2} {3}", (Object[])new Object[]{this, model, txnName, extraMsg}, (Throwable)t);
    }

    protected Logger getLogger(AbstractModel model) {
        return Logger.getLogger(this.getClass().getName());
    }

    protected final void cancelTask() throws CancelTransactionException {
        throw new CancelTransactionException();
    }

    AbstractModel __getWrapperTransactionModel(AbstractModel runModel) {
        return runModel;
    }

    void __startWrapperTransaction(AbstractModel commitModel, String txnName) throws XmlCommitException {
        commitModel.startTransaction(this.getTransactionOptions(txnName));
    }

    void __commitWrapperTransaction(AbstractModel commitModel) throws XmlCommitException {
        commitModel.commitTransaction();
    }

    boolean __isNullNameOK() {
        return false;
    }

    private boolean _isOkTxnName(String txnName) {
        return txnName != null || this.__isNullNameOK();
    }

    protected StandardTransactionTask() {
    }

    private static class CancelTransactionException
    extends RuntimeException {
    }
}

