/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.uri.RootRelativeURIInfo;
import oracle.bali.xml.model.metadata.refinfo.uri.URIInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MultiplexingURIInfo
extends URIInfo {
    protected MultiplexingURIInfo(int errorLevel) {
        super(errorLevel);
    }

    @Override
    public void validate(XmlContext context, Node node) throws ValidationException {
        this._validate(context, node, MultiplexingURIInfo.__getValue(node));
    }

    @Override
    public void validate(XmlContext context, Node node, Object newValue) throws ValidationException {
        this._validate(context, node, this.__convertToString(newValue));
    }

    @Override
    public boolean canGoToDeclaration(XmlContext context, Node node) {
        URIInfo[] list = this.getURIInfos();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].canGoToDeclaration(context, node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void goToDeclaration(XmlContext context, Node node) {
        URIInfo[] list = this.getURIInfos();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].canGoToDeclaration(context, node)) continue;
            list[i].goToDeclaration(context, node);
            return;
        }
    }

    protected abstract URIInfo[] getURIInfos();

    private void _validate(XmlContext context, Node node, String uri) throws ValidationException {
        if (uri == null || "".equals(uri)) {
            String message = context.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, message, node);
        }
        if (!this.isDatabound(context, node)) {
            URIInfo[] infos = this.getURIInfos();
            ValidationException error = null;
            for (int i = 0; i < infos.length; ++i) {
                try {
                    if (infos[i] instanceof RootRelativeURIInfo) {
                        RootRelativeURIInfo rri = (RootRelativeURIInfo)infos[i];
                        rri.__validate(context, node, rri.getRootURL(context), uri);
                    } else {
                        infos[i].validate(context, node, uri);
                    }
                    error = null;
                    break;
                }
                catch (ValidationException ve) {
                    if (error != null) continue;
                    error = ve;
                    continue;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

