/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.uri.URIInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public class ExternalURLInfo
extends URIInfo {
    public ExternalURLInfo() {
    }

    public String getURL(Node node) {
        return ExternalURLInfo.__getValue(node);
    }

    public ExternalURLInfo(int errorLevel) {
        super(errorLevel);
    }

    @Override
    public void validate(XmlContext context, Node node) throws ValidationException {
        this._validate(context, node, this.getURL(node));
    }

    @Override
    public void validate(XmlContext context, Node node, Object newValue) throws ValidationException {
        this._validate(context, node, this.__convertToString(newValue));
    }

    @Override
    public boolean canGoToDeclaration(XmlContext context, Node node) {
        return context.getRefInfoResolver().uriExists(context, null, this.getURL(node));
    }

    @Override
    public void goToDeclaration(XmlContext context, Node node) {
        context.getRefInfoResolver().goToDeclaration(context, node, this);
    }

    private void _validate(XmlContext context, Node node, String uri) throws ValidationException {
        if (uri == null || "".equals(uri)) {
            String message = context.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, message, node);
        }
        if (!this.isDatabound(context, node) && !context.getRefInfoResolver().uriExists(context, null, uri)) {
            String message = context.getTranslatedString("EXTERNAL_URI_NOT_FOUND_FORMAT");
            throw new ValidationException(200, FastMessageFormat.formatMessage(message, uri), node);
        }
    }
}

