/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfoResolver;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MethodJavaInfo
extends SingleClassJavaInfo {
    public abstract String getMethodName(Node var1);

    public abstract void setMethodName(Node var1, String var2, String var3);

    public abstract String getMethodReturnType(XmlContext var1, Node var2);

    public abstract String[] getMethodParameters(XmlContext var1, Node var2);

    @Override
    public boolean canGoToDeclaration(XmlContext context, Node node) {
        return context.getRefInfoResolver().methodExists(context, this.getFullyQualifiedClassName(node), this.getMethodName(node), this.getMethodReturnType(context, node), this.getMethodParameters(context, node));
    }

    @Override
    public void validate(XmlContext context, Node n) throws ValidationException {
        String methodName = this.getMethodName(n);
        this.validateMethodName(context, n, methodName, this.getErrorLevel());
    }

    @Override
    public void validate(XmlContext context, Node node, Object newValue) throws ValidationException {
        this.validateMethodName(context, node, (String)newValue, this.getErrorLevel());
    }

    protected void validateMethodName(XmlContext context, Node n, String methodName, int errorLevel) throws ValidationException {
        if (errorLevel == 2) {
            return;
        }
        RefInfoResolver rir = context.getRefInfoResolver();
        String className = this.getFullyQualifiedClassName(n);
        this.validateClassName(context, n, className, this.getErrorLevel());
        if (methodName == null || "".equals(methodName)) {
            String format = context.getTranslatedString("METHOD_EMPTY");
            int type = errorLevel == 0 ? 136 : 137;
            ValidationException ve = new ValidationException(type, format, n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
        if (!this.isDatabound(context, n) && !rir.methodExists(context, className, methodName, this.getMethodReturnType(context, n), this.getMethodParameters(context, n))) {
            String format = context.getTranslatedString("METHOD_NOT_FOUND");
            int type = errorLevel == 0 ? 138 : 139;
            ValidationException ve = new ValidationException(type, FastMessageFormat.formatMessage(format, methodName, className), n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
    }
}

