/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.operation.AbstractSingleFlavorOperation;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Node;

public abstract class AbstractNodeTargetingOperation
extends AbstractSingleFlavorOperation {
    protected abstract List getApplicableNodesForDataImpl(AbstractModel var1, List var2, TransferDataInfo var3);

    protected abstract boolean applyImpl(AbstractModel var1, Node var2, TransferDataInfo var3, TransactionToken var4) throws IOException, XmlCommitException;

    @Override
    protected final List getApplicableDataAndPositionsImpl(AbstractModel model, List positions, List dataInfos) {
        ArrayList<Node> nodes = new ArrayList<Node>(positions.size());
        HashMap<Node, DomPosition> nodeToFirstPosition = new HashMap<Node, DomPosition>(17);
        for (DomPosition pos : positions) {
            Node node = pos.getTargetNode();
            if (nodeToFirstPosition.containsKey(node)) continue;
            nodes.add(node);
            nodeToFirstPosition.put(node, pos);
        }
        ArrayList<DataAndPositions> ret = new ArrayList<DataAndPositions>(dataInfos.size());
        for (TransferDataInfo data : dataInfos) {
            List applicableNodes = this.getApplicableNodesForDataImpl(model, nodes, data);
            if (applicableNodes.isEmpty()) continue;
            ArrayList<DomPosition> outPosList = new ArrayList<DomPosition>(positions.size());
            for (Node node : applicableNodes) {
                DomPosition pos = (DomPosition)nodeToFirstPosition.get(node);
                if (pos == null) {
                    outPosList.add(DomPositionFactory.before((Node)node));
                    continue;
                }
                outPosList.add(pos);
            }
            ret.add(new DataAndPositions(data, outPosList));
        }
        if (ret.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ret.trimToSize();
        return ret;
    }

    @Override
    public final boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        if (pos == null) {
            return false;
        }
        return this.applyImpl(model, pos.getTargetNode(), data, token);
    }
}

