/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.contract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.contract.ContractDefinition;
import oracle.bali.xml.model.contract.ContractIdentifier;
import oracle.bali.xml.model.contract.IllegalContractException;
import oracle.bali.xml.model.contract.MutableContractDefinition;

public class ContractDefinitionFactory {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model.contract");

    public static MutableContractDefinition createMutableContractDefinition(ContractIdentifier identifier) throws IllegalContractException {
        if (identifier == null) {
            throw new IllegalContractException("The contract identifier cannot be null.");
        }
        return new MutableContractDefinition(identifier);
    }

    public static ContractDefinition createContractDefinition(StructuredMetadataBean contract) throws IllegalContractException {
        if (contract == null || !XmlMetadataConstants.CONTRACT.equals((Object)contract.getName())) {
            throw new IllegalContractException("Unexpected StructuredMetadataBean passed to createContractDefinition: " + contract);
        }
        String idAttr = contract.getProperty(XmlMetadataConstants.ID_ATTR);
        if (!ContractIdentifier.isValidIdentifier(idAttr)) {
            throw new IllegalContractException("ContractDefinitionFactory:  contract definition has invalid identifier: " + idAttr);
        }
        ContractIdentifier identifier = ContractIdentifier.getContractIdentifier(idAttr);
        MutableContractDefinition result = ContractDefinitionFactory.createMutableContractDefinition(identifier);
        List children = contract.getChildren();
        for (StructuredMetadataBean child : children) {
            String childValue;
            QualifiedName childName = child.getName();
            if (XmlMetadataConstants.GLOBAL_DISPLAY_NAME.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setDisplayName(childValue);
                continue;
            }
            if (!XmlMetadataConstants.GLOBAL_DESCRIPTION.equals((Object)childName) || (childValue = child.getValue()) == null) continue;
            result.setDescription(childValue);
        }
        return result;
    }

    public static List<ContractDefinition> createContractDefinitions(StructuredMetadataBean contractDefinitions) {
        if (contractDefinitions == null || !XmlMetadataConstants.CONTRACT_DEFINITIONS.equals((Object)contractDefinitions.getName())) {
            return Collections.emptyList();
        }
        ArrayList<ContractDefinition> resultList = new ArrayList<ContractDefinition>();
        List contractList = contractDefinitions.getChildren();
        for (StructuredMetadataBean contract : contractList) {
            try {
                ContractDefinition result = ContractDefinitionFactory.createContractDefinition(contract);
                resultList.add(result);
            }
            catch (IllegalContractException e) {
                _LOGGER.log(Level.WARNING, "Invalid contract definition encountered (and ignored)", e);
            }
            catch (RuntimeException rE) {
                _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing contract definitions", rE);
            }
        }
        return resultList;
    }

    public static List<ContractDefinition> createContractDefinitions(List<StructuredMetadataBean> contractDefinitionsList) {
        ArrayList<ContractDefinition> resultList = new ArrayList<ContractDefinition>();
        for (StructuredMetadataBean contractDefinitions : contractDefinitionsList) {
            List<ContractDefinition> partialList = ContractDefinitionFactory.createContractDefinitions(contractDefinitions);
            resultList.addAll(partialList);
        }
        return resultList;
    }

    private ContractDefinitionFactory() {
    }
}

