/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation;

import java.util.Iterator;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModelEvent;
import oracle.bali.xml.model.annotation.AnnotationModelListener;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import org.w3c.dom.Node;

public abstract class AnnotationModel {
    private final SafeListenerManager _listenerManager = new SafeListenerManager();
    private final XmlContext _instanceContext;
    private boolean _isDisposed = false;

    public abstract AnnotationProvider getAnnotationProvider(Node var1);

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    public abstract void acquireWriteLock();

    public abstract void releaseWriteLock();

    public abstract void startTransaction(TransactionOptions var1);

    public abstract AnnotationCommitException precommitTransaction(PrecommitOptions var1);

    public abstract boolean commitTransaction(TransactionToken var1);

    public abstract void rollbackTransaction();

    public boolean isReadOnly() {
        return this.getInstanceModel().isReadOnly();
    }

    public final void addModelListener(AnnotationModelListener l) {
        this._listenerManager.addListener(l);
    }

    public final void removeModelListener(AnnotationModelListener l) {
        this._listenerManager.removeListener(l);
    }

    public final void dispose() {
        this._isDisposed = true;
        this.disposeImpl();
        this.fireAnnotationModelDisposedEvent();
    }

    protected void disposeImpl() {
    }

    protected AnnotationModel(XmlContext instanceContext) {
        if (instanceContext == null) {
            throw new IllegalArgumentException("AnnotationModel constructor passed null XmlModel");
        }
        this._instanceContext = instanceContext;
    }

    protected final XmlContext getInstanceContext() {
        return this._instanceContext;
    }

    protected final XmlModel getInstanceModel() {
        return this._instanceContext.getModel();
    }

    protected final void fireAnnotationModelChangedEvent() {
        this._fireAnnotationModelChangedEvent(new AnnotationModelEvent(this, 0));
    }

    protected final void fireAnnotationModelDisposedEvent() {
        this._fireAnnotationModelDisposedEvent(new AnnotationModelEvent(this, 1));
    }

    protected final void fireAnnotationModelEvent(AnnotationModelEvent e) {
        if (e.isModelChanged()) {
            this._fireAnnotationModelChangedEvent(e);
        } else if (e.isModelDisposed()) {
            this._fireAnnotationModelDisposedEvent(e);
        } else {
            throw new IllegalArgumentException("Unknown AnnotationModelEvent Type");
        }
    }

    private void _fireAnnotationModelChangedEvent(AnnotationModelEvent e) {
        DomModel instanceDomModel = this.getInstanceModel().getDomModel();
        if (instanceDomModel.getLockStatus() != 2) {
            this._deliverModelChangedThreaded(e);
        } else {
            this._deliverModelChangedImmediate(e);
        }
    }

    private void _deliverModelChangedThreaded(final AnnotationModelEvent e) {
        Thread t = new Thread("AnnotationModelEvent delivery thread for " + this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    if (!AnnotationModel.this._isDisposed) {
                        DomModel instanceDomModel = AnnotationModel.this.getInstanceModel().getDomModel();
                        instanceDomModel.acquireWriteLock();
                        try {
                            if (AnnotationModel.this._isDisposed) break block8;
                            AnnotationModel.this.acquireWriteLock();
                            try {
                                if (!AnnotationModel.this._isDisposed) {
                                    AnnotationModel.this._deliverModelChangedImmediate(e);
                                }
                            }
                            finally {
                                AnnotationModel.this.releaseWriteLock();
                            }
                        }
                        finally {
                            instanceDomModel.releaseWriteLock();
                        }
                    }
                }
            }
        };
        t.setPriority(10);
        t.start();
    }

    private void _deliverModelChangedImmediate(AnnotationModelEvent e) {
        Iterator iter = this._listenerManager.iterator();
        while (iter.hasNext()) {
            AnnotationModelListener listener = (AnnotationModelListener)iter.next();
            listener.annotationModelChanged(e);
        }
    }

    private void _fireAnnotationModelDisposedEvent(AnnotationModelEvent e) {
        Iterator iter = this._listenerManager.iterator();
        while (iter.hasNext()) {
            AnnotationModelListener listener = (AnnotationModelListener)iter.next();
            listener.annotationModelDisposed(e);
        }
    }
}

