/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import org.w3c.dom.Node;

public class AnnotationMetadataResolver {
    private static final Map<String, Object> _DEFAULT_IMPLICIT_OBJECTS = Collections.emptyMap();
    private MetadataProvider _metadataProvider = null;

    public AnnotationMetadataResolver(MetadataProvider annotationMetadataProvider) {
        if (annotationMetadataProvider == null) {
            throw new IllegalArgumentException("AnnotationMetadataResolver:  null MetadataProvider passed to constructor");
        }
        this._metadataProvider = annotationMetadataProvider;
    }

    public final List<URI> getAnnotationPropertyFormLayouts(AnnotationProvider provider, Node associatedNode) {
        return this.getAnnotationPropertyFormLayoutsImpl(provider, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final int getDisplayOrder(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getDisplayOrderImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getDisplayValue(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getDisplayValueImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isExpert(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isExpertImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getGroup(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getGroupImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getHelpTopic(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getHelpTopicImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isHidden(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isHiddenImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getJavaType(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getJavaTypeImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isPreferred(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isPreferredImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final Object getPropertyEditor(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getPropertyEditorImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isRequired(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isRequiredImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getShortDescription(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getShortDescriptionImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getShortDisplayName(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getShortDisplayNameImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isValueModifable(AnnotationModel annotationModel, AnnotationProvider annotationProvider, QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isValueModifableImpl(annotationModel, annotationProvider, annotationPropertyName, associatedNode);
    }

    public final String getBundleNameForLayoutFile(AnnotationProvider provider, Node associatedNode, URI layoutFile) {
        return this.getBundleNameForLayoutFileImpl(provider, associatedNode, layoutFile, _DEFAULT_IMPLICIT_OBJECTS);
    }

    protected List<URI> getAnnotationPropertyFormLayoutsImpl(AnnotationProvider provider, Node associatedNode, Map<String, Object> implicitObjects) {
        Set<URI> set = this._getLayoutUrisAndProperties(provider, associatedNode, implicitObjects).keySet();
        return Arrays.asList(set.toArray(new URI[0]));
    }

    protected String getBundleNameForLayoutFileImpl(AnnotationProvider provider, Node associatedNode, URI layoutFile, Map<String, Object> implicitObjects) {
        String bundle = null;
        Map<QualifiedName, String> map = this._getLayoutUrisAndProperties(provider, associatedNode, implicitObjects).get(layoutFile);
        if (map != null) {
            bundle = map.get(QualifiedName.getQualifiedName(null, (String)"bundle"));
        }
        return bundle;
    }

    protected int getDisplayOrderImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.DISPLAY_ORDER);
        return this.convertToInt(rawValue, -1);
    }

    protected String getDisplayValueImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.DISPLAY_VALUE);
    }

    protected boolean isExpertImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.EXPERT);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getGroupImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.GROUP);
    }

    protected String getHelpTopicImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.HELP_TOPIC);
    }

    protected boolean isHiddenImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.HIDDEN);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getJavaTypeImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.JAVA_TYPE);
    }

    protected boolean isPreferredImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.PREFERRED);
        return this.convertToBoolean(rawValue, false);
    }

    protected Object getPropertyEditorImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.PROPERTY_EDITOR);
    }

    protected boolean isRequiredImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.REQUIRED);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getShortDescriptionImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.SHORT_DESCRIPTION);
    }

    protected String getShortDisplayNameImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.SHORT_DISPLAY_NAME);
    }

    protected boolean isValueModifableImpl(AnnotationModel annotationModel, AnnotationProvider annotationProvider, QualifiedName annotationPropertyName, Node associatedNode) {
        if (annotationModel.isReadOnly()) {
            return false;
        }
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.WRITABLE);
        return this.convertToBoolean(rawValue, true);
    }

    protected final boolean convertToBoolean(Object rawValue, boolean defaultValue) {
        if (rawValue instanceof String) {
            if ("true".equals(rawValue) || "1".equals(rawValue)) {
                return true;
            }
            if ("false".equals(rawValue) || "0".equals(rawValue)) {
                return false;
            }
        }
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        return defaultValue;
    }

    protected final int convertToInt(Object rawValue, int defaultValue) {
        if (rawValue instanceof String) {
            try {
                return Integer.valueOf((String)rawValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return defaultValue;
    }

    protected final URI convertToURI(Object rawValue) {
        if (rawValue instanceof String) {
            try {
                return new URI((String)rawValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rawValue instanceof URI) {
            return (URI)rawValue;
        }
        return null;
    }

    protected final MetadataProvider getAnnotationMetadataProvider() {
        return this._metadataProvider;
    }

    private Map<URI, Map<QualifiedName, String>> _getLayoutUrisAndProperties(AnnotationProvider provider, Node associatedNode, Map<String, Object> implicitObjects) {
        List formLayoutBeans = this._metadataProvider.getGlobalMetadata(QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"annotationPropertyFormLayout"));
        if (formLayoutBeans != null && !formLayoutBeans.isEmpty()) {
            HashMap<URI, Map<QualifiedName, String>> uriList = new HashMap<URI, Map<QualifiedName, String>>(3);
            for (StructuredMetadataBean formLayoutBean : formLayoutBeans) {
                String rawText = formLayoutBean.getValue();
                URI uri = this.convertToURI(rawText);
                if (uri == null) continue;
                uriList.put(uri, formLayoutBean.getProperties());
            }
            return uriList;
        }
        return Collections.emptyMap();
    }
}

