/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.action.BaseModelAction;
import oracle.bali.xml.model.datatransfer.operation.OperationProcessor;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;

public class PasteAction
extends BaseModelAction {
    private final OperationProcessor _processor = new OperationProcessor(null);
    private static final Logger _LOGGER = Logger.getLogger(PasteAction.class.getName());

    public PasteAction(String nameAndMnemonic) {
        super(nameAndMnemonic, KeyStroke.getKeyStroke(86, 2), "paste", true, true);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
        this._processor.setActionMask(1);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.isEnabledImpl()) {
            try {
                Action act;
                if (this._processor.hasMoreThanOneOperationWithHighestRank() && (act = this.getModel().getAction("paste_special")) != null) {
                    act.actionPerformed(event);
                    return;
                }
                TransactionOptions transOptions = new TransactionOptions(this.getModel().getTranslatedString("PASTE_DESCRIPTION_MULTIPLE"), false, false, true);
                this._processor.forceSimpleApply(null, this.getModel().getTranslatedString("PASTE_DESCRIPTION_MULTIPLE"), transOptions);
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Error in paste", e);
                AbstractModel model = this.getModel();
                XmlContext context = model.getContext();
                String title = context.getTranslatedString("ErrorDuringPasteTitle");
                String message = context.getTranslatedString("ErrorDuringPaste");
                context.showErrorMessage(message, title, e);
            }
        }
    }

    @Override
    public boolean isActiveViewAction() {
        return true;
    }

    @Override
    protected boolean needToUpdateEnabled(XmlModelEvent event) {
        return event.getCursorLocationPropertyChange() != null || this.needsToRespondToReadOnlyChange(event);
    }

    @Override
    protected boolean needToUpdateEnabled(PropertyChangeEvent event) {
        String changedProperty = event.getPropertyName();
        return changedProperty == null || "XmlContext.CLIPBOARD_FLAVORS".equals(changedProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabledImpl() {
        Transferable trans;
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel model = this.getModel();
        ClipboardManager clipboard = model.getContext().getClipboardManager();
        try {
            trans = clipboard.getContents();
        }
        catch (IllegalStateException e) {
            this.scheduleRecalculateEnabled(200);
            return false;
        }
        if (trans == ClipboardManager.EMPTY_CONTENTS || trans == ClipboardManager.UNKNOWN_CONTENTS) {
            return false;
        }
        AugmentableTransferable extendedTrans = TransferUtils.asAugmentableTransferable((Transferable)trans);
        model.acquireReadLock();
        try {
            this._processor.setEditable(!model.isReadOnly());
            this._processor.setTargetModel(model);
            this._processor.setTransferable((ExtendedTransferable)extendedTrans);
            DomPosition cursor = model.getSelection().getCursorLocation();
            if (cursor == null) {
                boolean bl = false;
                return bl;
            }
            this._processor.update(Collections.singletonList(cursor));
            boolean bl = this._processor.hasSupportedOperation();
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasValidInsertoinPoint() {
        AbstractModel model = this.getModel();
        if (model == null) {
            return false;
        }
        model.acquireReadLock();
        try {
            Selection selection = model.getSelection();
            DomPosition cursorPosition = selection.getCursorLocation();
            if (cursorPosition == null) {
                boolean bl = false;
                return bl;
            }
            if (!model.getXmlMetadataResolver().canAddChild(cursorPosition)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public OperationProcessor getOperationProcessor() {
        return this._processor;
    }
}

