/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.share.ImmutableFilteredCollection;
import oracle.bali.xml.util.XmlKeyDisplayNameComparator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlMetadataUtils {
    private XmlMetadataUtils() {
    }

    public static Map buildNsDisplayNameMap(XmlMetadataResolver resolver, Collection namespaces) {
        HashMap<String, String> nsDisplayNameMap = new HashMap<String, String>();
        for (String ns : namespaces) {
            String nsDisplayName = resolver.getShortDisplayName(ImmutableXmlKey.createNamespaceKey((String)ns));
            nsDisplayNameMap.put(nsDisplayName, ns);
        }
        return nsDisplayNameMap;
    }

    public static Map getCreatableChildrenMap(AbstractModel model, DomPosition pos) {
        return XmlMetadataUtils.groupKeysByNamespace(model, model.getXmlMetadataResolver().getCreateableChildrenXmlKeys(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map groupKeysByNamespace(AbstractModel model, Collection keys) {
        if (keys == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ArrayList<XmlKey>> firstMap = new HashMap<String, ArrayList<XmlKey>>();
        for (XmlKey key : keys) {
            String targetNamespace;
            String group = key.getNodeType() != 1 ? "XML" : ((targetNamespace = key.getTargetNamespace()) == null || targetNamespace.equals("") ? model.getTranslatedString("OtherGroup") : targetNamespace);
            ArrayList<XmlKey> collectionForNs = (ArrayList<XmlKey>)firstMap.get(group);
            if (collectionForNs == null) {
                collectionForNs = new ArrayList<XmlKey>();
                firstMap.put(group, collectionForNs);
            }
            collectionForNs.add(key);
        }
        if (firstMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        TreeMap<Object, List> realMap = new TreeMap<Object, List>(Collator.getInstance(model.getContext().getLocale()));
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        XmlKeyDisplayNameComparator keyComparator = new XmlKeyDisplayNameComparator(resolver);
        model.acquireReadLock();
        try {
            for (Map.Entry entry : firstMap.entrySet()) {
                String ns = (String)entry.getKey();
                String nsDisplayName = "XML".equals(ns) ? ns : resolver.getMediumDisplayName(ImmutableXmlKey.createNamespaceKey((String)ns));
                List keysForNs = (List)entry.getValue();
                List nsDisplayNameKeys = (List)realMap.get(nsDisplayName);
                if (nsDisplayNameKeys == null) {
                    Collections.sort(keysForNs, keyComparator);
                    realMap.put(nsDisplayName, keysForNs);
                    continue;
                }
                nsDisplayNameKeys.addAll(keysForNs);
                Collections.sort(nsDisplayNameKeys, keyComparator);
                realMap.put(nsDisplayName, nsDisplayNameKeys);
            }
        }
        finally {
            model.releaseReadLock();
        }
        return realMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPossibleSurround(AbstractModel abstractModel, Node[] nodesToSurround, XmlKey possibleSurroundingKey) {
        if (possibleSurroundingKey.getNodeType() != 1) {
            return false;
        }
        XmlMetadataResolver resolver = abstractModel.getXmlMetadataResolver();
        abstractModel.acquireReadLock();
        try {
            for (int i = 0; i < nodesToSurround.length; ++i) {
                Node parent = nodesToSurround[i].getParentNode();
                XmlKey parentKey = null;
                if (parent != null) {
                    parentKey = resolver.getNodeXmlKey(parent);
                }
                if (resolver.isValidInsertion(possibleSurroundingKey, nodesToSurround[i]) && resolver.isXmlKeyCreatableInMenu(parent, parentKey, possibleSurroundingKey)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            abstractModel.releaseReadLock();
        }
        return true;
    }

    public static final String getNamespaceWhereKeyDefined(XmlKey xmlKey, XmlMetadataResolver resolver) {
        XmlKey baseElementKey;
        ElementDef baseElementDef;
        AttributeDef attrDef;
        if (xmlKey.getNodeType() == 2 && (attrDef = (AttributeDef)resolver.getGrammarComponent(xmlKey)) != null && (baseElementDef = (ElementDef)resolver.getGrammarComponent(baseElementKey = ImmutableXmlKey.createElementKey((List)xmlKey.getElementQNamePath()))) != null) {
            ComplexType previousType;
            ComplexType currentType = previousType = (ComplexType)baseElementDef.getType();
            String currentTypeName = currentType.getName();
            while (currentTypeName != null) {
                if (currentType.getAttributeDefs().contains(attrDef)) {
                    previousType = currentType;
                    currentType = (ComplexType)currentType.getBaseType();
                    currentTypeName = currentType.getName();
                    continue;
                }
                return previousType.getTargetNamespace();
            }
        }
        return xmlKey.getTargetNamespace();
    }

    public static List getPositionWildcards(DomPosition position, AbstractModel model) {
        Node container = position.getContainerNode();
        ElementDef ed = (ElementDef)model.getXmlMetadataResolver().getGrammarComponent(model.getNodeXmlKey(container));
        if (ed != null) {
            return TypeUtils.getElementWildcards((ElementDef)ed);
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection getPotentialConversionTargetKeys(AbstractModel model, Node node, boolean filterByPosition) {
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        switch (node.getNodeType()) {
            case 3: {
                return XmlMetadataUtils._singleKeyIfNotHidden(resolver, (XmlKey)GlobalNodeTypeKey.CDATA_SECTION_KEY);
            }
            case 4: {
                return XmlMetadataUtils._singleKeyIfNotHidden(resolver, (XmlKey)GlobalNodeTypeKey.TEXT_KEY);
            }
            case 1: {
                return XmlMetadataUtils._getPotentialConversionTargetKeys(resolver, (Element)node, filterByPosition);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Collection _getPotentialConversionTargetKeys(final XmlMetadataResolver resolver, Element element, boolean filterByPosition) {
        XmlKey parentKey;
        Node parent;
        Collection<Object> creatable;
        final XmlKey sourceKey = resolver.getNodeXmlKey(element);
        if (filterByPosition) {
            DomPosition pos = DomPositionFactory.before((Node)element);
            creatable = resolver.getCreateableChildrenXmlKeys(pos);
        } else {
            parent = element.getParentNode();
            if (parent == null) {
                creatable = Collections.EMPTY_LIST;
            } else {
                parentKey = resolver.getNodeXmlKey(parent);
                creatable = resolver.getCreateableChildrenXmlKeys(null, parentKey);
            }
        }
        parent = element.getParentNode();
        parentKey = null;
        if (parent != null) {
            parentKey = resolver.getNodeXmlKey(parent);
        }
        final XmlKey fParentKey = parentKey;
        return new ImmutableFilteredCollection(creatable, new ImmutableFilteredCollection.Filter(){

            public boolean accept(Object o) {
                XmlKey key = (XmlKey)o;
                return key.getNodeType() == 1 && !sourceKey.equals((Object)key) && resolver.isXmlKeyCreatableInMenu(parent, fParentKey, key);
            }
        });
    }

    private static Collection _singleKeyIfNotHidden(XmlMetadataResolver resolver, XmlKey key) {
        if (resolver.isHidden(key)) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(key);
    }
}

