/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.xmlComponent;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.inspector.XmlComponentSupport;
import oracle.bali.xml.gui.base.inspector.editors.InspectorPropertyEditorSupport;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.AttributeValueItem;
import org.w3c.dom.Node;

public abstract class AbstractXmlPropertyEditorFactoryDecorator<T>
extends InspectorPropertyEditorSupport
implements PropertyEditorFactory2,
PropertyEditor,
XmlComponentPropertyEditor {
    private Component _editorComponent;
    private final PropertyEditorFactory2 _propertyEditor;
    private XmlComponentWrapper _xmlComponentWrapper;

    public AbstractXmlPropertyEditorFactoryDecorator(PropertyEditorFactory2 propertyEditor) {
        this._propertyEditor = propertyEditor;
    }

    @Override
    public final void setValue(Object o) {
        this._propertyEditor.setValue(o);
    }

    public T getValue() {
        return (T)this._propertyEditor.getValue();
    }

    @Override
    public boolean isPaintable() {
        return this._propertyEditor.isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this._propertyEditor.paintValue(gfx, box);
    }

    @Override
    public final String getAsText() {
        return this._propertyEditor.getAsText();
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        this._propertyEditor.setAsText(text);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this._propertyEditor.addPropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this._propertyEditor.removePropertyChangeListener(l);
    }

    @Override
    public String[] getTags() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getTags();
        }
        return null;
    }

    @Override
    public String getJavaInitializationString() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getJavaInitializationString();
        }
        return "???";
    }

    @Override
    public Component getCustomEditor() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).getCustomEditor();
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        if (this._propertyEditor instanceof PropertyEditor) {
            return ((PropertyEditor)this._propertyEditor).supportsCustomEditor();
        }
        return false;
    }

    public void applyValueFrom(Component c) {
        this._propertyEditor.applyValueFrom(c);
    }

    @Override
    public boolean hasInlineEditor() {
        return this._propertyEditor.hasInlineEditor();
    }

    @Override
    public Component getInlineEditor() {
        return this._propertyEditor.getInlineEditor();
    }

    public EditorComponentInfo getEditorComponentInfo() {
        return this._propertyEditor.getEditorComponentInfo();
    }

    public void setEditorComponentInfo(EditorComponentInfo editorComponentInfo) {
        this._propertyEditor.setEditorComponentInfo(editorComponentInfo);
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this._propertyEditor.getPropertyValueApplier();
    }

    public void setPropertyValueApplier(PropertyValueApplier propertyValueApplier) {
        this._propertyEditor.setPropertyValueApplier(propertyValueApplier);
    }

    @Override
    public void setSelectedItemToStringConverter(ToStringConverter selectedItemToStringConverter) {
        this._propertyEditor.setSelectedItemToStringConverter(selectedItemToStringConverter);
    }

    @Override
    public Component getXmlComponent() {
        if (this._editorComponent == null && this.getEditorComponentInfo() != null) {
            Component attributeValueComponent;
            this._editorComponent = attributeValueComponent = this.getAttributeValueComponent();
        }
        this.updateXmlComponentFromPropertyValue();
        return this._editorComponent;
    }

    private Component getAttributeValueComponent() {
        List<XmlKey> ancestors;
        XmlKey ownerKey;
        PropertyEditorFactory2 attributeValueItemPropertyEditor;
        XmlKey xmlKey = this.getXmlComponentModel().getXmlKey();
        XmlGui xmlGui = this.getXmlComponentModel().getXmlGui();
        Node node = this.getXmlComponentModel().getNode();
        if (node == null) {
            node = this.getXmlComponentModel().getPrecreatedNode();
        }
        Node ownerNode = node;
        if (xmlKey.getNodeType() == 2) {
            ownerNode = this.getXmlComponentModel().getParentAttrNode();
        }
        if ((attributeValueItemPropertyEditor = XmlComponentSupport.createAttributeValueItemPropertyEditor(this._propertyEditor, xmlGui, xmlKey, node, ownerNode, ownerKey = ImmutableXmlKey.createElementKey((List)xmlKey.getElementQNamePath()), ancestors = Collections.singletonList(ownerKey))).getEditorComponentInfo() != null) {
            PropertyValueApplier propertyValueApplier = new PropertyValueApplier(){

                public void apply(Object newValue) {
                    AbstractXmlPropertyEditorFactoryDecorator.this.setValue(newValue);
                }
            };
            return XmlComponentSupport.getInlineEditorComponent(attributeValueItemPropertyEditor, propertyValueApplier);
        }
        return null;
    }

    @Override
    public void updateXmlComponentFromPropertyValue() {
        String textValue;
        if (this._editorComponent instanceof JTextComponent) {
            ((JTextComponent)this._editorComponent).setText(this.getAsText());
        } else if (this._editorComponent instanceof JComboBox && ((JComboBox)this._editorComponent).isEditable() && (textValue = this.getAsText()) != null) {
            this.setTextJComboBox(this.getAsText(), (JComboBox)this._editorComponent);
        }
    }

    public void setTextJComboBox(String text, JComboBox mComboBox) {
        mComboBox.setSelectedItem(null);
        boolean textSet = false;
        int itemCount = mComboBox.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Object item = mComboBox.getItemAt(i);
            if (item instanceof AttributeValueItem) {
                AttributeValueItem itemAsAttributeValue = (AttributeValueItem)item;
                try {
                    if (!text.equals(itemAsAttributeValue.selectValue())) continue;
                    mComboBox.setSelectedItem(item);
                    textSet = true;
                    break;
                }
                catch (PropertyVetoException e) {
                    continue;
                }
            }
            if (item == null || !text.equals(item.toString())) continue;
            mComboBox.setSelectedItem(item);
            textSet = true;
            break;
        }
        if (!textSet && mComboBox.isEditable()) {
            mComboBox.setSelectedItem(text);
        }
    }

    @Override
    public void updatePropertyValueFromXmlComponent() {
        if (this._editorComponent instanceof JTextComponent) {
            String textValue = ((JTextComponent)this._editorComponent).getText();
            this.setAsText(textValue);
        } else if (this._editorComponent instanceof JComboBox && ((JComboBox)this._editorComponent).isEditable()) {
            String textValue = this.getTextJComboBox((JComboBox)this._editorComponent);
            if (textValue != null) {
                this.setAsText(textValue);
            }
        } else {
            this.setAsText(this._propertyEditor.getAsText());
        }
    }

    public String getTextJComboBox(JComboBox mComboBox) {
        Object selectedItem = mComboBox.getSelectedItem();
        Object editingItem = mComboBox.getEditor().getItem();
        if (mComboBox.isEditable() && editingItem != null) {
            return editingItem.toString();
        }
        if (selectedItem instanceof AttributeValueItem) {
            AttributeValueItem selectedItemAsAttributeValue = (AttributeValueItem)selectedItem;
            try {
                return selectedItemAsAttributeValue.selectValue();
            }
            catch (PropertyVetoException e) {
                return null;
            }
        }
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return null;
    }

    public XmlComponentModel getXmlComponentModel() {
        return this._xmlComponentWrapper.getXmlComponentModel();
    }

    @Override
    public XmlComponentWrapper getXmlComponentWrapper() {
        return this._xmlComponentWrapper;
    }

    @Override
    public XmlComponentPropertyEditor setXmlComponentWrapper(XmlComponentWrapper xmlComponentWrapper) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        return this;
    }

    @Override
    public void addChildFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeChildFocusListener(FocusListener focusListener) {
    }

    @Override
    public XmlComponentLayoutOption getXmlComponentLayoutOption() {
        return null;
    }

    @Override
    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        this._xmlComponentWrapper.getXmlWrappedComponent().setEnabled(enabled);
        return this;
    }

    @Override
    public boolean updatePropertyValue() {
        return true;
    }

    @Override
    public void dispose() {
    }
}

