/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.ProcessingInstructionTargetPropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlKeyPropertyRow;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.NameToStringUtils;
import org.w3c.dom.Node;

public class XmlDomPropertyModel
extends PropertyModel {
    public static final Object COLUMN_IS_DATABOUND = XmlSpecificColumns.COLUMN_IS_DATABOUND;
    public static final Object COLUMN_SUPPORTS_DATABINDING = XmlSpecificColumns.COLUMN_SUPPORTS_DATABINDING;
    public static final Object COLUMN_HELP_TOPIC = XmlSpecificColumns.COLUMN_HELP_TOPIC;
    public static final Object COLUMN_NODE = XmlSpecificColumns.COLUMN_NODE;
    public static final Object COLUMN_IS_REQUIRED = XmlSpecificColumns.COLUMN_IS_REQUIRED;
    public static final Object COLUMN_IS_COMMON = XmlSpecificColumns.COLUMN_IS_COMMON;
    public static final Object COLUMN_IS_SET = XmlSpecificColumns.COLUMN_IS_SET;
    public static final Object COLUMN_DISPLAY_ORDER = XmlSpecificColumns.COLUMN_DISPLAY_ORDER;
    public static final Object COLUMN_IS_PREFERRED = XmlSpecificColumns.COLUMN_IS_PREFERRED;
    public static final Object COLUMN_IS_FAVORITE = XmlSpecificColumns.COLUMN_IS_FAVORITE;
    public static final Object COLUMN_XMLKEY = XmlSpecificColumns.COLUMN_XMLKEY;
    public static final Object COLUMN_IS_DEPRECATED = XmlSpecificColumns.COLUMN_IS_DEPRECATED;
    public static final Object COLUMN_TOOLTIP = XmlSpecificColumns.COLUMN_TOOLTIP;
    public static final Object COLUMN_HIDDEN_IN_PROPERTIES_DIALOG = XmlSpecificColumns.COLUMN_HIDDEN_IN_PROPERTIES_DIALOG;
    public static final Object COLUMN_ENUMERATED_VALUES_INFO = XmlSpecificColumns.COLUMN_ENUMERATED_VALUES_INFO;
    public static final Object COLUMN_DEFAULT_VALUE = XmlSpecificColumns.COLUMN_DEFAULT_VALUE;
    public static final Object COLUMN_INSPECTOR_GUI = XmlSpecificColumns.COLUMN_INSPECTOR_GUI;
    public static final Object COLUMN_ANCESTOR_NODE = XmlSpecificColumns.COLUMN_TARGET_NODE;
    public static final Object COLUMN_ANCESTOR_KEY = XmlSpecificColumns.COLUMN_TARGET_KEY;
    public static final Object COLUMN_IS_CUSTOMIZED_AT_TIP = XmlSpecificColumns.COLUMN_IS_CUSTOMIZED_AT_TIP;
    public static final Object COLUMN_NEAREST_ANCESTOR_NODE = XmlSpecificColumns.COLUMN_NEAREST_ANCESTOR_NODE;
    public static final Object COLUMN_OWNER_NODE = XmlSpecificColumns.COLUMN_OWNER_NODE;
    public static final Object COLUMN_OWNER_KEY = XmlSpecificColumns.COLUMN_OWNER_KEY;
    public static final Object COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER = XmlSpecificColumns.COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER;
    public static final Object COLUMN_KEY = XmlSpecificColumns.COLUMN_KEY;
    public static final Object COLUMN_INSPECTABLE_KEY = XmlSpecificColumns.COLUMN_INSPECTABLE_KEY;
    public static final Object COLUMN_INSPECTABLE_PROMOTION_PATH = XmlSpecificColumns.COLUMN_INSPECTABLE_PROMOTION_PATH;
    private Node _node;
    private XmlKey _key;
    private List<XmlKey> _keys;
    private BaseInspectorGui _gui;
    private boolean isBeingQueried = false;
    private transient String _name;
    private transient List<? extends PropertyRow> _attrRows;
    private transient int _lockCount;
    private final transient ConcurrentHashMap<Object, PropertyRow> _propertyIdToRow = new ConcurrentHashMap();
    private final Map<PropertyRowOwner, Map<Object, PropertyRow>> _keyToRow = new HashMap<PropertyRowOwner, Map<Object, PropertyRow>>(5);
    private static Object[] _COLUMNS;
    private static int _INDEX_INSPECTOR_GUI;
    private static int _INDEX_ANCESTOR_NODE;
    private static int _INDEX_ANCESTOR_KEY;
    private static int _INDEX_INSPECTABLE_KEY;
    private static int _INDEX_INSPECTABLE_PROMOTION_PATH;
    private static Object _COLUMNS_LOCK;

    public XmlDomPropertyModel(Node ancestor, BaseInspectorGui gui) {
        this(ancestor, gui.getView().getXmlMetadataResolver().getNodeXmlKey(ancestor), gui);
    }

    public XmlDomPropertyModel(Node ancestor, XmlKey ancestorKey, BaseInspectorGui gui) {
        this(ancestor, Collections.singletonList(ancestorKey), gui);
    }

    public XmlDomPropertyModel(Node ancestor, List<XmlKey> keys, BaseInspectorGui gui) {
        if (gui == null) {
            throw new IllegalArgumentException("No gui");
        }
        this._node = ancestor;
        this._gui = gui;
        this._key = keys.get(0);
        this._keys = keys;
        this._update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getColumnMapping() {
        if (_COLUMNS == null) {
            Object object = _COLUMNS_LOCK;
            synchronized (object) {
                if (_COLUMNS == null) {
                    Object[] orig = PropertyRowColumnUtils.getColumnMapping();
                    Object[] cols = new Object[orig.length + 5];
                    System.arraycopy(orig, 0, cols, 0, orig.length);
                    int i = orig.length;
                    _INDEX_INSPECTOR_GUI = i++;
                    _INDEX_ANCESTOR_NODE = i++;
                    _INDEX_ANCESTOR_KEY = i++;
                    _INDEX_INSPECTABLE_KEY = i++;
                    _INDEX_INSPECTABLE_PROMOTION_PATH = i++;
                    assert (i == cols.length);
                    cols[XmlDomPropertyModel._INDEX_INSPECTOR_GUI] = COLUMN_INSPECTOR_GUI;
                    cols[XmlDomPropertyModel._INDEX_ANCESTOR_NODE] = COLUMN_ANCESTOR_NODE;
                    cols[XmlDomPropertyModel._INDEX_ANCESTOR_KEY] = COLUMN_ANCESTOR_KEY;
                    cols[XmlDomPropertyModel._INDEX_INSPECTABLE_KEY] = COLUMN_INSPECTABLE_KEY;
                    cols[XmlDomPropertyModel._INDEX_INSPECTABLE_PROMOTION_PATH] = COLUMN_INSPECTABLE_PROMOTION_PATH;
                    _COLUMNS = cols;
                }
            }
        }
        return _COLUMNS;
    }

    public int getRowCount() {
        return this._attrRows.size();
    }

    public void startRead() {
        if (this._gui == null) {
            return;
        }
        this.getView().acquireReadLock();
        ++this._lockCount;
    }

    public void stopRead() {
        if (this._gui == null) {
            return;
        }
        this.getView().releaseReadLock();
        --this._lockCount;
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (this._gui == null) {
            return DOES_NOT_EXIST;
        }
        PropertyRow rowAttrs = this.getPropertyRow(rowIndex);
        return this._getPropertyWithLockIfNeeded(rowAttrs, columnIndex);
    }

    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        PropertyRow row = this.getPropertyRow(rowIndex);
        switch (columnIndex) {
            case 2: {
                if (newValue == null) {
                    PropertyRow.UpdateResult result = this._setRowIsSet(false, row);
                    break;
                }
                PropertyRow.UpdateResult result = row.setRowValue(newValue);
                break;
            }
            case 16: {
                if (row instanceof XmlKeyPropertyRow) {
                    PropertyRow.UpdateResult result = ((XmlKeyPropertyRow)row).setDataboundValue(newValue);
                    break;
                }
                PropertyRow.UpdateResult result = PropertyRow.UpdateResult.NO_UPDATE;
                break;
            }
            case 5: {
                PropertyRow.UpdateResult result = this._setRowIsSet(newValue, row);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getColumnIndex(Object columnID) {
        if (columnID == COLUMN_ID) {
            return 0;
        }
        return super.getColumnIndex(columnID);
    }

    public Object getPropertyByID(int columnIndex, Object propertyID) {
        if (this._gui == null) {
            return DOES_NOT_EXIST;
        }
        PropertyRow row = this.getPropertyRow(propertyID);
        if (row != null) {
            return this._getPropertyWithLockIfNeeded(row, columnIndex);
        }
        return DOES_NOT_EXIST;
    }

    public String getTargetDisplayName() {
        return this._name;
    }

    public void dispose() {
        super.dispose();
        this.invalidateValueData();
    }

    public void invalidateValueData() {
        this._disposeOldRows();
        this.getGui().__clearNodeMessages(this._getAncestorNode());
        this._update();
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int row, int column) {
        if (this._gui == null) {
            return false;
        }
        boolean editable = super.isCellEditable(row, column);
        if (editable && (editable = this._gui.isUserEditable())) {
            this.startRead();
            try {
                editable = !this.getView().getXmlMetadataResolver().isImmutable(this._getAncestorNode());
            }
            finally {
                this.stopRead();
            }
        }
        return editable;
    }

    public String toString() {
        return super.toString() + ", node=" + this._node;
    }

    public void disposeModel() {
        if (this.isBeingQueried) {
            throw new IllegalStateException("PropertyModel cannot be disposed while it's being queried!");
        }
        this._disposeOldRows();
        this._attrRows = Collections.emptyList();
        this._propertyIdToRow.clear();
        this._keyToRow.clear();
        this._gui = null;
        this._node = null;
        this._keys = Collections.emptyList();
    }

    public Object getMatchingId(Object id) {
        PropertyRow row;
        String str;
        List<Object> keys;
        if (this._gui == null) {
            return false;
        }
        if (id instanceof String && !(keys = this._parseStringPropertyIdToKey(str = (String)id)).isEmpty() && (row = this._getPropertyRow(this._getAllKeys(keys))) != null) {
            return row.getColumnValue(0);
        }
        return null;
    }

    private List<Object> _getAllKeys(List<Object> keys) {
        ArrayList<Object> allKeys = new ArrayList<Object>(this._keys.size() - 1 + keys.size());
        for (int i = 1; i < this._keys.size(); ++i) {
            allKeys.add(this._keys.get(i));
        }
        allKeys.addAll(keys);
        return allKeys;
    }

    private PropertyRow _getPropertyRow(List<Object> keys) {
        Object key = keys.get(keys.size() - 1);
        PropertyRow row = null;
        Set<PropertyRowOwner> s = this._keyToRow.keySet();
        boolean found = false;
        for (PropertyRowOwner pro : s) {
            List<XmlKey> promotionPath;
            Map<Object, PropertyRow> m = this._keyToRow.get(pro);
            row = m.get(key);
            if (row != null && (promotionPath = row.getOwner().getPromotionPath()).size() == keys.size()) {
                if (keys.size() == 1) {
                    found = true;
                } else {
                    for (int i = 1; i < promotionPath.size() && promotionPath.get(i).equals(keys.get(i - 1)); ++i) {
                        if (i != promotionPath.size() - 1) continue;
                        found = true;
                    }
                }
            }
            if (!found) continue;
            return row;
        }
        return null;
    }

    public boolean isSettable(Object oldValue, Object newValue) {
        return true;
    }

    protected Object getProperty(PropertyRow row, int columnIndex) {
        if (_COLUMNS == null) {
            this.getColumnMapping();
        }
        if (columnIndex == _INDEX_INSPECTOR_GUI) {
            return this.getGui();
        }
        if (columnIndex == _INDEX_ANCESTOR_NODE) {
            return this._getAncestorNode();
        }
        if (columnIndex == _INDEX_ANCESTOR_KEY) {
            return this._getAncestorKey();
        }
        if (columnIndex == _INDEX_INSPECTABLE_KEY) {
            return this._getInspectableKey();
        }
        if (columnIndex == _INDEX_INSPECTABLE_PROMOTION_PATH) {
            return this._getInspectablePromotionPath();
        }
        return row.getColumnValue(columnIndex);
    }

    protected final XmlView getView() {
        return this._gui.getView();
    }

    public final BaseInspectorGui getGui() {
        return this._gui;
    }

    protected final PropertyRow getPropertyRow(int rowIndex) {
        return this._attrRows.get(rowIndex);
    }

    protected final PropertyRow getPropertyRow(Object propertyId) {
        return this._propertyIdToRow.get(propertyId);
    }

    private Node _getAncestorNode() {
        return this._node;
    }

    private XmlKey _getAncestorKey() {
        return this._key;
    }

    private XmlKey _getInspectableKey() {
        return this._keys.get(this._keys.size() - 1);
    }

    private List<XmlKey> _getInspectablePromotionPath() {
        return this._keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _getPropertyWithLockIfNeeded(PropertyRow row, int columnIndex) {
        if (this._gui == null) {
            return DOES_NOT_EXIST;
        }
        this.isBeingQueried = true;
        this.startRead();
        try {
            Object object = this.getProperty(row, columnIndex);
            return object;
        }
        finally {
            this.stopRead();
            this.isBeingQueried = false;
        }
    }

    private int _getPropertyIndex(PropertyRow row) {
        return this._attrRows.indexOf(row);
    }

    private void _fireEvents(PropertyRow.UpdateResult result, PropertyRow row, int index) {
        switch (result) {
            case NO_UPDATE: {
                break;
            }
            case INVALIDATE_CELL: {
                this.fireTableCellUpdated(this._getPropertyIndex(row), index);
                break;
            }
            case INVALIDATE_MODEL: {
                this.invalidateValueData();
            }
        }
    }

    private void _disposeOldRows() {
        for (int i = 0; i < this._attrRows.size(); ++i) {
            PropertyRow row = this._attrRows.get(i);
            row.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _update() {
        this.startRead();
        try {
            List<Object> propertyRows;
            String oldName = this._name;
            this._name = null;
            Node targetNode = this._node;
            XmlKey nodeKey = this._key;
            short nodeType = nodeKey.getNodeType();
            PropertyRowOwner owner = new PropertyRowOwner(this.getGui(), targetNode, nodeKey, this._keys);
            switch (nodeType) {
                case 1: {
                    propertyRows = this.getGui().__createPropertyRows(owner);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    propertyRows = Collections.singletonList(new XmlKeyPropertyRow(this.getGui(), nodeKey, targetNode, owner));
                    break;
                }
                case 7: {
                    ArrayList l = new ArrayList(2);
                    ProcessingInstructionTargetPropertyRow targetRow = new ProcessingInstructionTargetPropertyRow(this.getGui(), nodeKey, targetNode, owner);
                    XmlKeyPropertyRow dataRow = new XmlKeyPropertyRow(this.getGui(), nodeKey, targetNode, owner);
                    l.add(targetRow);
                    l.add(dataRow);
                    propertyRows = l;
                    break;
                }
                default: {
                    propertyRows = Collections.emptyList();
                }
            }
            this._propertyIdToRow.clear();
            this._keyToRow.clear();
            this._attrRows = propertyRows;
            for (int i = 0; i < this._attrRows.size(); ++i) {
                PropertyRow row = this._attrRows.get(i);
                this._propertyIdToRow.put(row.getColumnValue(0), row);
                PropertyRowOwner o = row.getOwner();
                Map<Object, PropertyRow> props = this._keyToRow.get(o);
                if (props == null) {
                    props = new HashMap<Object, PropertyRow>(35);
                }
                props.put(row.getColumnValue(39), row);
                this._keyToRow.put(o, props);
            }
            this._name = this._getName();
            if (this._name != null) {
                this.firePropertyChanged("targetDisplayName", oldName, this._name);
            }
        }
        finally {
            this.stopRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getName() {
        if (this._gui == null) {
            return null;
        }
        this.startRead();
        try {
            Node n = null;
            if (this._keys.size() == 1) {
                n = this._getAncestorNode();
            }
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            String string = n != null ? resolver.getMediumDisplayName(this._getAncestorNode()) : resolver.getMediumDisplayName(this._getInspectableKey());
            return string;
        }
        finally {
            this.stopRead();
        }
    }

    private PropertyRow.UpdateResult _setRowIsSet(Object value, PropertyRow row) {
        boolean isSet;
        if (Boolean.FALSE.equals(value) && (isSet = Boolean.TRUE.equals(row.getColumnValue(5)))) {
            row.setDefaultRowValue();
            return PropertyRow.UpdateResult.INVALIDATE_MODEL;
        }
        return PropertyRow.UpdateResult.NO_UPDATE;
    }

    private List<Object> _parseStringPropertyIdToKey(String str) {
        ArrayList<Object> keys;
        block10: {
            XmlKey targetKey = this._getInspectableKey();
            XmlKey derivedKey = null;
            keys = new ArrayList<Object>();
            boolean isAnnotation = str.startsWith("+");
            if (isAnnotation) {
                str = str.substring(1);
            }
            try {
                int[] index = new int[]{0};
                while (index[0] < str.length()) {
                    XmlKey parsedKey;
                    if (str.charAt(index[0]) == ' ') {
                        index[0] = index[0] + 1;
                    }
                    if ((parsedKey = NameToStringUtils.parseXmlKeyWithPrefixMappings(Collections.singletonMap(null, targetKey.getNamespace()), (CharSequence)str, (int[])index)) == null) continue;
                    if (isAnnotation) {
                        keys.add(parsedKey.getElementQName());
                        continue;
                    }
                    if (parsedKey.getNodeType() == 2) {
                        XmlKey baseKey = keys.isEmpty() ? targetKey : (XmlKey)keys.get(keys.size() - 1);
                        derivedKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getGui().getGuiContext().getGrammarResolver(), (XmlKey)baseKey, (QualifiedName)parsedKey.getAttributeQName());
                    } else if (parsedKey.getNodeType() == 1) {
                        derivedKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getGui().getGuiContext().getGrammarResolver(), (XmlKey)targetKey, (List)parsedKey.getElementQNamePath());
                    } else {
                        this.getGui().getLogger().log(Level.WARNING, "Unexpected key type parsed from {0}; key={1}", new Object[]{str, parsedKey});
                    }
                    keys.add(derivedKey);
                }
            }
            catch (NameToStringUtils.ParseException e) {
                Logger logger = this.getGui().getLogger();
                if (!logger.isLoggable(Level.FINER)) break block10;
                logger.log(Level.FINER, "Failed to parse to property ID: " + str, e);
            }
        }
        return keys;
    }

    public final Comparator<PropertyRow> getRowComparator() {
        return this.getGui().__getRowComparator();
    }

    static {
        _COLUMNS_LOCK = new Object();
    }

    private static enum XmlSpecificColumns {
        COLUMN_IS_DATABOUND,
        COLUMN_SUPPORTS_DATABINDING,
        COLUMN_HELP_TOPIC,
        COLUMN_NODE,
        COLUMN_IS_REQUIRED,
        COLUMN_IS_COMMON,
        COLUMN_IS_SET,
        COLUMN_DISPLAY_ORDER,
        COLUMN_IS_PREFERRED,
        COLUMN_IS_FAVORITE,
        COLUMN_XMLKEY,
        COLUMN_IS_DEPRECATED,
        COLUMN_TOOLTIP,
        COLUMN_HIDDEN_IN_PROPERTIES_DIALOG,
        COLUMN_ENUMERATED_VALUES_INFO,
        COLUMN_DEFAULT_VALUE,
        COLUMN_INSPECTOR_GUI,
        COLUMN_TARGET_NODE,
        COLUMN_TARGET_KEY,
        COLUMN_IS_CUSTOMIZED_AT_TIP,
        COLUMN_NEAREST_ANCESTOR_NODE,
        COLUMN_OWNER_NODE,
        COLUMN_OWNER_KEY,
        COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER,
        COLUMN_KEY,
        COLUMN_INSPECTABLE_KEY,
        COLUMN_INSPECTABLE_PROMOTION_PATH;

    }
}

