/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;

class PromotedPropertiesRowCreator
extends PropertyRowCreator {
    @Override
    public List<PropertyRow> getProperties(BaseInspectorGui gui, PropertyRowOwner owner) {
        List<XmlKey> grammarChildrenKeys = this._getGrammarKeys(gui, owner);
        if (grammarChildrenKeys.isEmpty()) {
            return Collections.emptyList();
        }
        List<PropertyRow> rows = new ArrayList<PropertyRow>();
        PropertyRowOwner newOwner = null;
        for (XmlKey k : grammarChildrenKeys) {
            newOwner = new PropertyRowOwner(gui, owner.getTargetNode(), owner.getTargetKey(), this._getNewList(owner.getPromotionPath(), k));
            rows = PropertyRowColumnUtils.mergeSortedLists(rows, gui.__createPropertyRows(newOwner), gui.__getRowComparator(), false);
        }
        return rows;
    }

    protected List<XmlKey> _getGrammarKeys(BaseInspectorGui gui, PropertyRowOwner owner) {
        XmlKey ownerKey = owner.getParentKey();
        XmlMetadataResolver resolver = gui.getView().getXmlMetadataResolver();
        Set<XmlKey> children = resolver.getVirtualAttributeKeys(ownerKey);
        ArrayList<XmlKey> vadsChildren = new ArrayList<XmlKey>();
        for (XmlKey k : children) {
            String vads = resolver.getVirtualAttributeDataSource(k);
            if (vads == null || !vads.equals("##properties") && !vads.equals("##propertiesAndPresence")) continue;
            vadsChildren.add(k);
        }
        return vadsChildren;
    }

    private List<XmlKey> _getNewList(List<XmlKey> oldList, XmlKey key) {
        ArrayList<XmlKey> newList = new ArrayList<XmlKey>(oldList.size() + 1);
        newList.addAll(oldList);
        newList.add(key);
        return newList;
    }
}

