/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.explorer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.base.explorer.BaseExplorerGui;
import oracle.bali.xml.gui.base.explorer.TreePathList;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.message.MessageUtils;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.util.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XmlTreeModel
implements TreeModel {
    private static final Log LOG = new Log("expiration");
    private Object _errorsFolder = null;
    private TreePath _errorsFolderPath = null;
    private final List _errorNodes = Collections.synchronizedList(new ArrayList());
    private final boolean _showErrors;
    private int _nonWarningCount = 0;
    private BaseExplorerGui _gui;
    private final SafeListenerManager _treeModelListeners = new SafeListenerManager();
    private static final Logger _LOGGER = Logger.getLogger(XmlTreeModel.class.getName());
    private static final Object _ROOT_NODE = new String("root");
    private static final TreePath _ROOT_PATH = new TreePath(_ROOT_NODE);
    private static final String _INSERTION_EVENT = "insertion";
    private static final String _REMOVAL_EVENT = "removal";
    private static final String _STRUCTURE_CHANGE_EVENT = "structure change";
    private static final String _NODES_CHANGED_EVENT = "nodes changed";

    XmlTreeModel(boolean showErrors) {
        this._showErrors = showErrors;
    }

    public final BaseExplorerGui getGui() {
        if (this._gui == null) {
            throw new IllegalStateException("Cannot get gui before __attachGui!");
        }
        return this._gui;
    }

    public final XmlView getView() {
        return this.getGui().getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreePath getPathForDomElement(XmlView view, Node node) {
        view.acquireReadLock();
        try {
            if (node == null) {
                TreePath treePath = null;
                return treePath;
            }
            Document ownerDoc = node.getOwnerDocument();
            if (ownerDoc == null) {
                TreePath treePath = _ROOT_PATH;
                return treePath;
            }
            TreeTraversal strategy = view.getTreeTraversal();
            int pathLength = DomUtils.getNodeDepth((TreeTraversal)strategy, (Node)node);
            if (pathLength < 0) {
                TreePath treePath = null;
                return treePath;
            }
            Object[] path = new Object[++pathLength];
            path[0] = _ROOT_NODE;
            int pathIndex = pathLength - 1;
            do {
                path[pathIndex] = node;
                --pathIndex;
            } while ((node = strategy.getParentNode(node)) != ownerDoc);
            TreePath treePath = new TreePath(path);
            return treePath;
        }
        finally {
            view.releaseReadLock();
        }
    }

    public TreePath getPathForDomElement(Node node) {
        return XmlTreeModel.getPathForDomElement(this.getView(), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node pathToSourceDom(TreePath path) {
        if (path != null) {
            this.getView().acquireReadLock();
            try {
                Node node;
                Object lastComponent = path.getLastPathComponent();
                if (lastComponent instanceof Node && DomUtils.getOwnerDocument((Node)(node = (Node)lastComponent)) == this.getView().getDocument()) {
                    Node node2 = node;
                    return node2;
                }
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        return null;
    }

    public static List getAncestorNodeListFromPath(XmlView view, TreePath path) {
        Object last = path.getLastPathComponent();
        if (last instanceof Node) {
            return new TreePathList(path);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getRoot() {
        return _ROOT_NODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLeaf(Object objectNode) {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        if (this._gui.isNodeToEvade(objectNode)) {
            return true;
        }
        if (objectNode instanceof Node) {
            this.getView().acquireReadLock();
            try {
                boolean bl = this.getTreeTraversal().getFirstChild((Node)objectNode) == null;
                return bl;
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        if (objectNode == _ROOT_NODE) {
            return false;
        }
        return objectNode != this._getErrorsFolder();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new IllegalStateException("Tree isn't mutable");
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this._treeModelListeners.addListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._treeModelListeners.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getChild(Object parent, int index) {
        Object child;
        block11: {
            XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
            this.getView().acquireReadLock();
            child = null;
            try {
                if (this._gui.isNodeToEvade(parent)) {
                    child = null;
                    break block11;
                }
                if (parent instanceof Node) {
                    TreeTraversal treeTraversal = this.getTreeTraversal();
                    try {
                        child = treeTraversal.getChild((Node)parent, index);
                        if (child == null && !this.getView().getBaseModel().isDeliveringEvents()) {
                            throw new IllegalStateException("TreeTraversal.getChild() returns null for index= " + index);
                        }
                        break block11;
                    }
                    catch (IllegalStateException ise) {
                        _LOGGER.log(Level.SEVERE, "TreeTraversal.getChild() returns null for index= " + index + " Verify that the traversal returns the correct child node for index=" + index + " and that node removals are performed within a XMLModel transaction" + " so that model listeners are notified." + this.getView().getDebugInfo() + " parent=[" + XmlTreeModel.debugOutput((Node)parent, treeTraversal, true, false) + "]", ise);
                    }
                    break block11;
                }
                if (parent == _ROOT_NODE) {
                    if (this._errorsFolderVisible()) {
                        --index;
                    }
                    child = index == -1 ? this._getErrorsFolder() : this._getRootDomNode(index);
                } else {
                    child = parent == this._getErrorsFolder() ? this._errorNodes.get(index) : null;
                }
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount(Object parent) {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        XmlView view = this._gui.getView();
        int childCount = 0;
        view.acquireReadLock();
        try {
            if (this._gui.isNodeToEvade(parent)) {
                childCount = 0;
            } else if (parent instanceof Node) {
                TreeTraversal treeTraversal = this.getTreeTraversal();
                childCount = treeTraversal.getChildCount((Node)parent);
            } else {
                childCount = parent == _ROOT_NODE ? (this._errorsFolderVisible() ? 1 : 0) + this._getRootDomNodeCount() : (parent == this._getErrorsFolder() ? this._getErrorsCount() : 0);
            }
        }
        finally {
            view.releaseReadLock();
        }
        return childCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        try {
            this.getView().acquireReadLock();
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in XmlTreeModel.getIndexOfChild: {0}", (Object)e);
            return -1;
        }
        try {
            if (parent == null || child == null || this._gui.isNodeToEvade(parent) || this._gui.isNodeToEvade(child)) {
                int e = -1;
                return e;
            }
            if (child instanceof Node) {
                Node cNode = (Node)child;
                int index = XmlTreeModel.getChildIndex(this.getTreeTraversal(), cNode, this.getView());
                if (this.getTreeTraversal().getParentNode(cNode) == cNode.getOwnerDocument() && this._errorsFolderVisible()) {
                    ++index;
                }
                int n = index;
                return n;
            }
            if (child == this._getErrorsFolder()) {
                int n = 0;
                return n;
            }
            if (child instanceof Issue) {
                int n = this._errorNodes.indexOf(child);
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreePath getErrorsFolderTreePathIfVisible() {
        this.getView().acquireReadLock();
        try {
            if (this._errorsFolderVisible()) {
                TreePath treePath = this._getErrorsFolderPath();
                return treePath;
            }
            TreePath treePath = null;
            return treePath;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    protected void postAttachmentHook() {
    }

    protected final TreeTraversal getTreeTraversal() {
        return this.getView().getTreeTraversal();
    }

    void __attachGui(BaseExplorerGui gui) {
        if (gui == null) {
            throw new IllegalArgumentException("No BaseExplorerGui specified");
        }
        if (this._gui != null) {
            throw new IllegalStateException("__attachGui called twice");
        }
        this._gui = gui;
        this.postAttachmentHook();
    }

    void __handleModelChangeEvent(XmlModelEvent event) {
        _LOGGER.log(Level.FINER, "XmlTreeModel received model event: {0}", event);
        this._fireErrorsFolderEvent(event);
        this._fireDomEvent(event);
    }

    private void _fireDomEvent(XmlModelEvent event) {
        boolean fireEvent = event.isDomTreeChanged();
        if (!fireEvent) {
            PropertyChange validChange = event.getDomDocumentValidPropertyChange();
            boolean bl = fireEvent = validChange != null && validChange.getNewBooleanValue();
        }
        if (fireEvent) {
            Node changeRoot = event.getChangeRoot();
            TreePath targetPath = changeRoot == null || changeRoot.getNodeType() == 9 ? _ROOT_PATH : this.getPathForDomElement(changeRoot);
            TreeModelEvent treeEvent = new TreeModelEvent((Object)this, targetPath);
            this._fireTreeModelEvent(treeEvent, _STRUCTURE_CHANGE_EVENT);
        }
    }

    private void _fireErrorsFolderEvent(XmlModelEvent event) {
        PropertyChange issueListChange = event.getIssueListPropertyChange();
        if (issueListChange != null) {
            boolean hasErrorsNow;
            IssueList issueList = (IssueList)issueListChange.getNewValue();
            boolean hadErrorsBefore = this._getErrorsCount() > 0;
            this._createErrorNodes(issueList);
            boolean bl = hasErrorsNow = this._getErrorsCount() > 0;
            String eventType = hadErrorsBefore && hasErrorsNow ? _STRUCTURE_CHANGE_EVENT : (hadErrorsBefore ? _REMOVAL_EVENT : (hasErrorsNow ? _INSERTION_EVENT : null));
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "Errors folder change: hadBefore={0} hasNow={1} event={2}", new Object[]{new Boolean(hadErrorsBefore), new Boolean(hasErrorsNow), eventType});
            }
            if (eventType == null) {
                return;
            }
            TreeModelEvent treeEvent = eventType == _STRUCTURE_CHANGE_EVENT ? new TreeModelEvent((Object)this, this._getErrorsFolderPath()) : new TreeModelEvent((Object)this, _ROOT_PATH, new int[]{0}, new Object[]{this._getErrorsFolder()});
            this._fireTreeModelEvent(treeEvent, eventType);
        }
    }

    private void _fireTreeModelEvent(TreeModelEvent treeEvent, String eventType) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "XmlTreeModel event of type {0}: {1}", new Object[]{eventType, treeEvent});
        }
        Iterator listeners = this._treeModelListeners.iterator();
        while (listeners.hasNext()) {
            TreeModelListener tml = (TreeModelListener)listeners.next();
            if (eventType == _STRUCTURE_CHANGE_EVENT) {
                tml.treeStructureChanged(treeEvent);
                continue;
            }
            if (eventType == _INSERTION_EVENT) {
                tml.treeNodesInserted(treeEvent);
                continue;
            }
            if (eventType == _REMOVAL_EVENT) {
                tml.treeNodesRemoved(treeEvent);
                continue;
            }
            if (eventType == _NODES_CHANGED_EVENT) {
                tml.treeNodesChanged(treeEvent);
                continue;
            }
            throw new IllegalStateException("Invalid event type: " + eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createErrorNodes(IssueList issueList) {
        List list = this._errorNodes;
        synchronized (list) {
            this._errorNodes.clear();
            if (this._showErrors) {
                this._nonWarningCount = 0;
                for (int i = 0; i < issueList.size(); ++i) {
                    Issue issue = issueList.getIssueAt(i);
                    if (!MessageUtils.isAtLeastWarning(issue)) continue;
                    if (Severity.ERROR == issue.getSeverity()) {
                        ++this._nonWarningCount;
                    }
                    this._errorNodes.add(issue);
                }
                for (Issue issue : issueList.getOptionalAnalyses()) {
                    this._errorNodes.add(issue);
                }
            }
        }
    }

    private Object _getErrorsFolder() {
        if (this._errorsFolder == null) {
            this._errorsFolder = new ErrorsFolder();
        }
        return this._errorsFolder;
    }

    private TreePath _getErrorsFolderPath() {
        if (this._errorsFolderPath == null) {
            this._errorsFolderPath = new TreePath(new Object[]{_ROOT_NODE, this._getErrorsFolder()});
        }
        return this._errorsFolderPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _getRootDomNode(int index) {
        this.getView().acquireReadLock();
        try {
            Document doc = this.getView().getDocument();
            if (doc == null) {
                Node node = null;
                return node;
            }
            Node node = this.getView().getTreeTraversal().getChild((Node)doc, index);
            return node;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getRootDomNodeCount() {
        XmlView view = this.getView();
        view.acquireReadLock();
        try {
            Document doc = view.getDocument();
            if (doc == null) {
                int n = 0;
                return n;
            }
            int n = view.getTreeTraversal().getChildCount((Node)doc);
            return n;
        }
        finally {
            view.releaseReadLock();
        }
    }

    private boolean _errorsFolderVisible() {
        return this._getErrorsCount() != 0;
    }

    private int _getErrorsCount() {
        return this._errorNodes.size();
    }

    private static int getChildIndex(TreeTraversal traversal, Node node, XmlView view) {
        if (node == null) {
            return -1;
        }
        Node parentNode = traversal.getParentNode(node);
        if (parentNode == null || !DomUtils.isStandardChildNode((Node)node)) {
            return -1;
        }
        int childIndex = 0;
        Node currSibling = traversal.getFirstChild(parentNode);
        Document ownerDocument = null;
        Element ownerNode = null;
        while (currSibling != node) {
            if (currSibling == null) {
                try {
                    if (node != null && (ownerDocument = node.getOwnerDocument()) != null) {
                        ownerNode = ownerDocument.getDocumentElement();
                        throw new IllegalStateException("Traversal " + traversal + " thinks " + parentNode + " is the parent of " + node + " but the parent doesn't believe that it is its child. ");
                    }
                    throw new IllegalStateException("Traversal " + traversal + " thinks " + parentNode + " is the parent of " + node + " but the parent doesn't believe that it is its child. ");
                }
                catch (IllegalStateException ise) {
                    _LOGGER.log(Level.SEVERE, "Child node not found within parent when using view's traversal. Verify that the traversal returns the child node for the parent and that node removals are performed within a XMLModel transaction so that model listeners are notified." + view.getDebugInfo() + " parent=[" + XmlTreeModel.debugOutput(parentNode, traversal, true, false) + "]" + " child=[" + XmlTreeModel.debugOutput(node, null, false, false) + "]" + " Traversal thinks " + parentNode + " is the parent of " + node, ise);
                    return -1;
                }
            }
            if (DomUtils.isStandardChildNode((Node)currSibling)) {
                ++childIndex;
            }
            currSibling = traversal.getNextSibling(currSibling);
        }
        return childIndex;
    }

    private static String debugOutput(Node node, TreeTraversal treeTraversal, boolean printChildren1, boolean printChildren2) {
        Element element;
        NamedNodeMap attrs;
        String retString = "";
        if (node == null) {
            return retString;
        }
        retString = retString + "<" + node.getNodeName();
        if (DomUtils.isElement((Node)node) && (attrs = (element = (Element)node).getAttributes()) != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                retString = retString + " " + attr.getName() + "=" + attr.getValue();
            }
        }
        retString = retString + ">";
        if (printChildren1) {
            Node child = null;
            child = treeTraversal != null ? treeTraversal.getFirstChild(node) : node.getFirstChild();
            while (child != null) {
                retString = retString + XmlTreeModel.debugOutput(child, treeTraversal, printChildren2, printChildren2);
                if (treeTraversal != null) {
                    child = treeTraversal.getNextSibling(child);
                    continue;
                }
                child = child.getNextSibling();
            }
            retString = retString + "</" + node.getNodeName() + ">";
        }
        return retString;
    }

    public final class ErrorsFolder {
        private final String _errorsMsg;
        private final String _warningsMsg;

        public ErrorsFolder() {
            this._errorsMsg = XmlTreeModel.this.getGui().getTranslatedString("EXPLORER.ERRORS_FOLDER_FORMAT");
            this._warningsMsg = XmlTreeModel.this.getGui().getTranslatedString("EXPLORER.WARNINGS_FOLDER_FORMAT");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWarningsMode() {
            List list = XmlTreeModel.this._errorNodes;
            synchronized (list) {
                return XmlTreeModel.this._nonWarningCount == 0;
            }
        }

        public String toString() {
            int allCount = XmlTreeModel.this._getErrorsCount();
            if (allCount == 0) {
                return "";
            }
            String format = this.isWarningsMode() ? this._warningsMsg : this._errorsMsg;
            return MessageFormat.format(format, IntegerUtils.getInteger((int)XmlTreeModel.this._getErrorsCount()));
        }
    }
}

