/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.gui.base.explorer.BaseListGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlListModel
extends AbstractListModel {
    private List<Node> _items = null;
    private final BaseListGui _gui;
    private volatile boolean _processingXmlModelEvent = false;

    XmlListModel(BaseListGui gui) {
        this._gui = gui;
        this._gui.addModelListener(new Listener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        this._view().acquireReadLock();
        try {
            this._ensureBuilt();
            int n = this._items.size();
            return n;
        }
        finally {
            this._view().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getElementAt(int index) {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        this._view().acquireReadLock();
        try {
            this._ensureBuilt();
            Node node = this._items.get(index);
            return node;
        }
        finally {
            this._view().releaseReadLock();
        }
    }

    int __getIndexForNode(Node node) {
        this._ensureBuilt();
        return this._items.indexOf(node);
    }

    Node __getNodeForIndex(int i) {
        this._ensureBuilt();
        if (i >= 0 && i < this._items.size()) {
            return this._items.get(i);
        }
        return null;
    }

    public boolean isProcessingXmlModelEvent() {
        return this._processingXmlModelEvent;
    }

    private synchronized void _ensureBuilt() {
        if (this._items == null) {
            this._items = this._build();
        }
    }

    private List<Node> _build() {
        ArrayList<Node> items = new ArrayList<Node>();
        Document doc = this._view().getDocument();
        Node firstChild = this._traversal().getFirstChild((Node)doc);
        for (Node node : this._traversal().allNodes(firstChild)) {
            items.add(node);
        }
        return items;
    }

    private synchronized void _update(XmlModelEvent event) {
        if (this._items != null && event.isDomStructureChanged()) {
            int oldSize = this._items.size();
            this._items = this._build();
            int newSize = this._items.size();
            if (newSize < oldSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (newSize > oldSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
            this.fireContentsChanged(this, 0, Math.min(oldSize, newSize));
        }
    }

    private TreeTraversal _traversal() {
        return this._view().getTreeTraversal();
    }

    private XmlView _view() {
        return this._gui.getView();
    }

    private class Listener
    extends XmlModelAdapter {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelChanged(XmlModelEvent event) {
            XmlListModel.this._processingXmlModelEvent = true;
            try {
                XmlListModel.this._update(event);
            }
            finally {
                XmlListModel.this._processingXmlModelEvent = false;
            }
        }
    }
}

