/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.explorer;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.base.explorer.XmlTreeSelectionModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

public class BaseExplorerGui
extends XmlGui {
    private XmlTreeModel _treeModel;
    private final List<XmlTreeSelectionModel> _selModels = new LinkedList<XmlTreeSelectionModel>();
    private Set _removedNodesToEvade;
    private boolean _modelInvalidated;
    private final Object _modelInvalidatedLock = new Object();

    public BaseExplorerGui(XmlView view) {
        super(view);
        this.setModelInvalidated(false);
    }

    public XmlTreeModel getTreeModel() {
        if (this._treeModel == null) {
            this._treeModel = this.createTreeModel();
            this._treeModel.__attachGui(this);
        }
        return this._treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this._treeModel = null;
            this._selModels.clear();
        }
        finally {
            super.dispose();
        }
    }

    public void ensureActiveGuiAcquired() {
    }

    protected final TreeSelectionModel createTreeSelectionModel() {
        XmlTreeSelectionModel sel = new XmlTreeSelectionModel(this);
        sel.__initializeFromView();
        this._selModels.add(sel);
        return sel;
    }

    protected final void disposeTreeSelectionModel(TreeSelectionModel sel) {
        this._selModels.remove(sel);
    }

    protected final XmlTreeModel createTreeModel() {
        return new XmlTreeModel(this.showErrorsFolder());
    }

    protected boolean showErrorsFolder() {
        return true;
    }

    protected Set getLeadSelectionNodes() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void handleModelChangeEvent(XmlModelEvent event) {
        super.handleModelChangeEvent(event);
        if (this.isModelInvalidated() && event.isDomTreeChanged()) {
            this.setModelInvalidated(false);
        }
        HashSet<Node> previouslySelectedRemovedNodes = new HashSet<Node>();
        if (event.matchesFlags(2)) {
            for (XmlTreeSelectionModel sel : this._selModels) {
                TreePath[] paths = sel.getSelectionPaths();
                if (paths == null) continue;
                for (int i = 0; i < paths.length; ++i) {
                    Object lastComp = paths[i].getLastPathComponent();
                    if (!(lastComp instanceof Node)) continue;
                    Node node = (Node)lastComp;
                    if (this.getView().isInModelDocumentHierarchy(node)) continue;
                    previouslySelectedRemovedNodes.add(node);
                }
            }
            Set leads = this.getLeadSelectionNodes();
            previouslySelectedRemovedNodes.addAll(leads);
            this._removedNodesToEvade = previouslySelectedRemovedNodes;
        }
        try {
            this.handleModelChangeEventImpl(event);
        }
        finally {
            this._removedNodesToEvade = null;
        }
    }

    protected void handleModelChangeEventImpl(XmlModelEvent event) {
        this._updateTreeModel(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleModelInvalidateEvent(XmlModelEvent event) {
        Object object = this._modelInvalidatedLock;
        synchronized (object) {
            if (!this._modelInvalidated && event.isDomTreeChanged()) {
                this._modelInvalidated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelInvalidated(boolean modelInvalidated) {
        Object object = this._modelInvalidatedLock;
        synchronized (object) {
            this._modelInvalidated = modelInvalidated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModelInvalidated() {
        Object object = this._modelInvalidatedLock;
        synchronized (object) {
            return this._modelInvalidated;
        }
    }

    protected void addNodeToEvade(Node node) {
        if (this._removedNodesToEvade == null) {
            this._removedNodesToEvade = new HashSet();
        }
        this._removedNodesToEvade.add(node);
    }

    @Override
    protected void handleViewAttached(XmlModelEvent event) {
        super.handleViewAttached(event);
        this._updateTreeModel(event);
    }

    @Override
    protected void handleViewDetached(XmlModelEvent event) {
        super.handleViewDetached(event);
        if (this._treeModel != null) {
            this._updateTreeModel(event);
        }
    }

    public final boolean isNodeToEvade(Object node) {
        return this._removedNodesToEvade != null && this._removedNodesToEvade.contains(node);
    }

    private void _updateTreeModel(XmlModelEvent event) {
        for (XmlTreeSelectionModel sel : this._selModels) {
            sel.__handleEventBeforeTreeModel(event);
        }
        this._removedNodesToEvade = null;
        this.getTreeModel().__handleModelChangeEvent(event);
        for (XmlTreeSelectionModel sel : this._selModels) {
            sel.__handleEventAfterTreeModel(event);
        }
    }
}

