/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.binding;

import java.beans.PropertyEditor;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.DatabindingHandler;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public abstract class BaseDatabindingEditorGui
extends XmlGui {
    public BaseDatabindingEditorGui(XmlView view) {
        super(view);
    }

    public abstract PropertyEditor getDatabindingPropertyEditor(XmlContext var1, XmlKey var2, Node var3, Node var4);

    public void setDatabound(Node n, XmlKey attrKey, Node owner, boolean dataBound) {
        DatabindingHandler handler = this.getDatabindingHandler(attrKey);
        if (handler == null) {
            throw new IllegalArgumentException("No databinding handler for key " + attrKey);
        }
        handler.setDatabound(this.getGuiContext(), attrKey, n, owner, dataBound);
    }

    public final boolean isDatabound(Node node, Node owner) {
        TreeTraversal ownerTraversal;
        XmlKey derivedXmlKey;
        String nodeValue = node.getNodeValue();
        if (nodeValue == null && node instanceof XMLElement) {
            nodeValue = DomUtils.getTextNodeValue((Node)node);
        }
        XmlKey xmlKey = this.getView().getXmlMetadataResolver().getNodeXmlKey(node);
        if (!DomUtils.isInDocumentHierarchy((Node)owner) && (derivedXmlKey = XmlModelUtils.getOwnerTraversalDerivedXmlKey(ownerTraversal = XmlModelUtils.getPropertyEditorOwnerTraversal(owner), node, this.getView())) != null) {
            xmlKey = derivedXmlKey;
        }
        return this.isDataboundImpl(node, xmlKey, nodeValue, owner);
    }

    public final boolean isDatabound(XmlKey key, Node owner, Object value) {
        return this.isDataboundImpl(null, key, value, owner);
    }

    protected final boolean isDataboundImpl(Node node, XmlKey key, Object value, Node owner) {
        if (!this.getView().getXmlMetadataResolver().getSupportsDatabinding(key)) {
            return false;
        }
        DatabindingHandler handler = this.getDatabindingHandler(key);
        return handler != null ? handler.isDatabound(this.getGuiContext(), key, node, owner, value) : false;
    }

    protected final DatabindingHandler getDatabindingHandler(XmlKey key) {
        if (key.getNodeType() != 0) {
            key = ImmutableXmlKey.createNamespaceKey((String)key.getTargetNamespace());
        }
        return this.getView().getXmlMetadataResolver().getDatabindingHandler(key);
    }
}

