/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.gui.GuiEventProcessor;
import oracle.bali.xml.gui.GuiXmlContextLifecycleListener;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;

public abstract class GuiXmlContext
extends XmlContext {
    public static final String ACTIVE_GUI_PROPERTY = "activeGui";
    public static final String DROP_TARGET_GUI_PROPERTY = "dropTargetGui";
    private transient XmlGui _lastActiveNonNullGui;
    private transient XmlGui _dropTargetGui;
    private transient ExtendedTransferable _dropTransferable;
    private final Map<XmlUsage, XmlGui> _guis = Collections.synchronizedMap(new LinkedHashMap(8));
    private final List<XmlGuiFactory> _guiFactories = new LinkedList<XmlGuiFactory>();
    private static final GuiEventProcessor _DEFAULT_EVENT_PROCESSOR = new GuiEventProcessor();

    public abstract XmlGui getActiveGui();

    public final XmlGui getDropTargetGui() {
        return this._dropTargetGui;
    }

    public final void releaseDropTarget(XmlGui releasingGui) {
        if (this._dropTargetGui == releasingGui) {
            this._dropTargetGui = null;
            this.firePropertyChange(DROP_TARGET_GUI_PROPERTY, releasingGui, null);
        }
    }

    public final void acquireDropTarget(XmlGui acquiringGui) {
        if (this._dropTargetGui != acquiringGui) {
            XmlGui oldValue = this._dropTargetGui;
            this._dropTargetGui = acquiringGui;
            this.firePropertyChange(DROP_TARGET_GUI_PROPERTY, oldValue, acquiringGui);
        }
    }

    public final XmlGui getGui(XmlUsage usage) {
        return this.getGui(usage, true);
    }

    public final XmlGui getGui(XmlUsage usage, boolean createIfNeeded) {
        XmlGui cached = this._guis.get(usage);
        if (cached != null) {
            return cached;
        }
        if (!createIfNeeded) {
            return null;
        }
        XmlView view = this.getView(usage);
        if (view == null) {
            return null;
        }
        XmlGui created = null;
        Iterator<XmlGuiFactory> factoryItor = this._guiFactories.iterator();
        while (created == null && factoryItor.hasNext()) {
            XmlGuiFactory factory = factoryItor.next();
            created = factory.createGui(view, usage);
        }
        if (created != null) {
            this._guis.put(usage, created);
            try {
                created.__setUsage(usage);
                created.__setEventProcessor(this.createEventProcesor(created));
                created.postCreationHook();
            }
            catch (Throwable e) {
                this._guis.remove(usage);
                this.getLogger().log(Level.INFO, "Unexpeceted exception creating " + created, e);
                created = null;
            }
        }
        if (created != null) {
            final XmlGui gui = created;
            this.deliverLifecycleEvent(new XmlContext.LifecycleEventDeliverer(){

                @Override
                public void deliverToListener(XmlContextLifecycleListener listener) {
                    if (listener instanceof GuiXmlContextLifecycleListener) {
                        ((GuiXmlContextLifecycleListener)listener).postGuiSetup(gui);
                    }
                }
            });
        }
        return created;
    }

    public void registerGuiFactory(XmlGuiFactory factory) {
        if (factory != null && !this._guiFactories.contains(factory)) {
            this._guiFactories.add(factory);
        }
    }

    public boolean isUserEditable() {
        return !this.getModel().isReadOnly();
    }

    public final synchronized void setDropTransferable(Transferable trans) {
        if (trans == null) {
            this._dropTransferable = null;
        } else if (trans != this._dropTransferable) {
            AugmentableTransferable augmentable = XmlTransferUtils.performAugmentation(trans, this);
            this._dropTransferable = augmentable;
        }
    }

    public final synchronized ExtendedTransferable getDropTransferable() {
        return this._dropTransferable;
    }

    @Override
    protected void disposeImpl() {
        Collection<XmlGui> guis = this._guis.values();
        if (guis != null) {
            XmlGui[] array = new XmlGui[guis.size()];
            array = guis.toArray(array);
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].dispose();
                    continue;
                }
                catch (RuntimeException re) {
                    this.getLogger().log(Level.SEVERE, "Exception during dispose", re);
                }
            }
        }
        this._lastActiveNonNullGui = null;
        this._dropTargetGui = null;
        super.disposeImpl();
    }

    protected GuiEventProcessor createEventProcesor(XmlGui gui) {
        return _DEFAULT_EVENT_PROCESSOR;
    }

    protected final XmlGui setActiveGui(XmlGui newActiveGui, XmlGui oldActiveGui) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "SetActiveGui on {0}: {1} --> {2}", new Object[]{this, oldActiveGui == null ? "null" : oldActiveGui.getUsage().toString(), newActiveGui == null ? "null" : newActiveGui.getUsage().toString()});
        }
        if (oldActiveGui != newActiveGui) {
            if (newActiveGui != null && !newActiveGui.isGuiActivatable()) {
                XmlGui nonActivatableGui = newActiveGui;
                newActiveGui = oldActiveGui != null ? oldActiveGui : (this._lastActiveNonNullGui != null ? this._lastActiveNonNullGui : null);
                oldActiveGui = nonActivatableGui;
            }
            if (oldActiveGui != null) {
                oldActiveGui.deactivate();
            }
            if (newActiveGui != null) {
                this._lastActiveNonNullGui = newActiveGui;
                this.setActiveView(newActiveGui.getView());
                newActiveGui.activate();
            } else {
                this.setActiveView(null);
            }
        }
        return newActiveGui;
    }

    @Override
    protected ResourceBundle getBundle() {
        return super.getBundle();
    }

    @Override
    protected ResourceBundle createBundle() {
        return PaternalResourceBundle.getOrCreateCachedBundle(this.createBundle("oracle.bali.xml.gui.resource.GuiBundle"), super.createBundle());
    }

    void __destroyGuiReference(XmlGui gui) {
        if (this.getActiveGui() == gui) {
            this.setActiveGui(null, gui);
        }
        this.releaseDropTarget(gui);
        XmlGui removed = this._guis.remove(gui.getUsage());
        assert (removed == gui);
    }
}

