/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.XmlDocumentScanner;
import oracle.bali.xml.dom.buffer.util.EncodingParser;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;

public class EncodingUtils {
    public static final int DEFAULT_ENCODING_SCAN_SIZE = 512;
    public static final String DEFAULT_ENCODING_UTF8 = "UTF-8";
    private static Logger _sLogger = null;
    private static final String _ERROR = "Unexpected exception encountered while determining file encoding";

    public static int fillEncodingScanArray(InputStream inputStream, byte[] scanArray, int encodingScanSize) throws IOException {
        int length = 0;
        if (inputStream != null) {
            int bytesRead = 0;
            for (int bytesRemaining = encodingScanSize; bytesRemaining > 0 && (bytesRead = inputStream.read(scanArray, length, bytesRemaining)) != -1; bytesRemaining -= bytesRead) {
                length += bytesRead;
            }
        }
        return length;
    }

    public static String getEncodingClass(byte[] scanArray, int length) {
        String encodingClass = DEFAULT_ENCODING_UTF8;
        if (length > 4) {
            int[] convertedBytes = new int[4];
            for (int i = 0; i < 4; ++i) {
                convertedBytes[i] = scanArray[i] & 0xFF;
            }
            boolean foundByteOrderMark = false;
            if (convertedBytes[0] == 254 && convertedBytes[1] == 255 && (convertedBytes[2] != 0 || convertedBytes[3] != 0)) {
                foundByteOrderMark = true;
                encodingClass = "UTF-16BE";
            } else if (convertedBytes[0] == 255 && convertedBytes[1] == 254 && (convertedBytes[2] != 0 || convertedBytes[3] != 0)) {
                foundByteOrderMark = true;
                encodingClass = "UTF-16LE";
            } else if (convertedBytes[0] == 239 && convertedBytes[1] == 187 && convertedBytes[2] == 191) {
                foundByteOrderMark = true;
                encodingClass = DEFAULT_ENCODING_UTF8;
            }
            if (!foundByteOrderMark) {
                if (convertedBytes[0] == 0 && convertedBytes[1] == 60 && convertedBytes[2] == 0 && convertedBytes[3] == 63) {
                    encodingClass = "UTF-16BE";
                } else if (convertedBytes[0] == 60 && convertedBytes[1] == 0 && convertedBytes[2] == 63 && convertedBytes[3] == 0) {
                    encodingClass = "UTF-16LE";
                } else if (convertedBytes[0] == 76 && convertedBytes[1] == 111 && convertedBytes[2] == 167 && convertedBytes[3] == 148) {
                    encodingClass = "Cp037";
                }
            }
        }
        return encodingClass;
    }

    public static String getScanText(byte[] scanArray, int length, String encodingClass) {
        String scanText = "";
        if (length > 0) {
            try {
                scanText = DEFAULT_ENCODING_UTF8.equals(encodingClass) ? new String(scanArray, 0, length, "ISO-8859-1") : new String(scanArray, 0, length, encodingClass);
            }
            catch (Exception e) {
                EncodingUtils._getLogger().log(Level.SEVERE, _ERROR, e);
            }
        }
        return scanText;
    }

    public static ReadTextBuffer getTemporaryTextBuffer(byte[] scanArray, int length, String encodingClass) {
        String scanText = EncodingUtils.getScanText(scanArray, length, encodingClass);
        return TextBufferFactory.createReadTextBuffer((String)scanText);
    }

    public static AttributeLocator getEncodingAttributeLocator(ReadTextBuffer buffer) {
        AttributeLocator encodingLocator = null;
        if (buffer != null) {
            XmlDocumentScanner scanner = new XmlDocumentScanner();
            EncodingParser encodingParser = new EncodingParser(scanner);
            try {
                encodingLocator = encodingParser.findEncodingLocator(buffer);
            }
            catch (Exception e) {
                encodingLocator = null;
                EncodingUtils._getLogger().log(Level.SEVERE, _ERROR, e);
            }
        }
        return encodingLocator;
    }

    public static String getAttributeValue(ReadTextBuffer buffer, AttributeLocator locator) {
        TextLocator valueLocator;
        String value = null;
        if (buffer != null && locator != null && (valueLocator = locator.getValueLocator()) != null) {
            int length;
            int valueStartOffset = ((Locator)valueLocator).getStartOffset();
            if (locator.isStartQuotePresent()) {
                ++valueStartOffset;
            }
            int valueEndOffset = ((Locator)valueLocator).getEndOffset();
            if (locator.isEndQuotePresent()) {
                --valueEndOffset;
            }
            if ((length = valueEndOffset - valueStartOffset) > 0) {
                try {
                    value = buffer.getString(valueStartOffset, length);
                }
                catch (Exception e) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static Logger _getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(EncodingUtils.class.getName());
        }
        return _sLogger;
    }
}

