/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.buffer.AbstractBufferDomParser;
import oracle.bali.xml.dom.buffer.BufferDomParseCancelledException;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.javatools.buffer.ReadTextBuffer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BufferDomDocumentParser
extends AbstractBufferDomParser {
    public static final Object DECLARATION_LOCATOR_KEY = "declaration locator";
    public static final Object DOCUMENT_TYPE_LOCATOR_KEY = "doctype locator";
    private Document _document = null;
    private DocumentType _documentType = null;
    private XmlDeclarationInfo _xmlDeclarationInfo = null;
    private ArrayList _tempNodes = new ArrayList();
    private ArrayList _tempLocators = new ArrayList();
    private ElementLocator _fakeRootLocator = null;
    private volatile boolean _parseCancelled = false;
    private int _numTempNodesBeforeDoctype = 0;

    public BufferDomDocumentParser(DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory docScannerFactory, WhitespaceHandler whitespaceHandler) {
        super(domImpl, parserConfiguration, docScannerFactory, whitespaceHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(ReadTextBuffer textBuffer, LocatorManager manager, Map locatorMap) throws BufferDomParseCancelledException {
        this._parseCancelled = false;
        if (textBuffer == null || manager == null || locatorMap == null) {
            throw new IllegalArgumentException("parse() parameters cannot be null");
        }
        Document parsedDocument = null;
        try {
            parsedDocument = this._parse(textBuffer, manager, locatorMap);
        }
        finally {
            this.doCleanup();
        }
        if (this._parseCancelled) {
            parsedDocument = null;
            locatorMap.clear();
            throw new BufferDomParseCancelledException();
        }
        return parsedDocument;
    }

    public void cancelParse() {
        this._parseCancelled = true;
        DocumentScanner scanner = this.getCurrentDocumentScanner();
        if (scanner != null) {
            scanner.stopScanning();
        }
    }

    @Override
    public void handleXMLDeclaration(String version, String encoding, String standalone, DeclarationLocator locator) {
        if (this._xmlDeclarationInfo != null || this._document != null || this._documentType != null || !this._tempNodes.isEmpty()) {
            if (this.getLogger().isLoggable(Level.WARNING)) {
                this.getLogger().log(Level.WARNING, "XML declaration encountered but was not first in document; it was ignored. version={0} encoding={1} standalone={2} locator={3} oldDecl={4} doctype={5} doc={6} tempnodes={7}", new Object[]{version, encoding, standalone, locator, this._xmlDeclarationInfo, this._documentType, this._document, this._tempNodes});
            }
            return;
        }
        Float versionFloat = null;
        Boolean standaloneBoolean = null;
        try {
            if (version != null) {
                versionFloat = Float.valueOf(version);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if ("yes".equals(standalone)) {
            standaloneBoolean = Boolean.TRUE;
        } else if ("no".equals(standalone)) {
            standaloneBoolean = Boolean.FALSE;
        }
        this._xmlDeclarationInfo = new XmlDeclarationInfo(versionFloat, encoding, standaloneBoolean);
        this.mapToLocator(DECLARATION_LOCATOR_KEY, locator);
    }

    @Override
    public void handleDocumentType(ResolvedName name, String publicID, String systemID, SimpleLocator locator) {
        if (this._document == null) {
            String rawName = name.getRawName();
            if (rawName != null) {
                try {
                    this._documentType = this.getDOMImplementation().createDocumentType(name.getRawName(), publicID, systemID);
                    this._numTempNodesBeforeDoctype = this._tempNodes.size();
                }
                catch (Exception e) {
                    this._documentType = null;
                    this.getLogger().log(Level.WARNING, "Exception creating doctype", e);
                }
            }
        } else {
            this.getLogger().log(Level.WARNING, "Doctype encountered after document created, at {0}", locator);
        }
        this.mapToLocator(DOCUMENT_TYPE_LOCATOR_KEY, locator);
    }

    @Override
    public void handleText(String text, TextLocator locator) {
        Element root;
        ArrayList tempNodeBackup = null;
        ArrayList tempLocatorBackup = null;
        if (this._document == null) {
            tempNodeBackup = new ArrayList(this._tempNodes);
            tempLocatorBackup = new ArrayList(this._tempLocators);
        }
        Document docBefore = this._document;
        this._considerFakeRoot(locator.getStartOffset());
        super.handleText(text, locator);
        if (docBefore == null && this._document != null && (root = this._document.getDocumentElement()) != null && root.getFirstChild() == null) {
            this._fakeRootLocator = null;
            this._document = null;
            this.setCurrentParent(null);
            this.clearRegularLocators();
            assert (tempNodeBackup != null);
            assert (tempLocatorBackup != null);
            this._tempNodes = tempNodeBackup;
            this._tempLocators = tempLocatorBackup;
            if (this._documentType != null) {
                this._documentType = this.getDOMImplementation().createDocumentType(this._documentType.getName(), this._documentType.getPublicId(), this._documentType.getSystemId());
            }
        }
    }

    @Override
    public void handleCDATASection(String text, SimpleLocator locator) {
        this._considerFakeRoot(locator.getStartOffset());
        super.handleCDATASection(text, locator);
    }

    @Override
    protected Document getOwnerDocument() {
        return this._document;
    }

    @Override
    protected void handleDocumentScannerException() {
        this._document = null;
    }

    @Override
    protected void handleCommentOrPIBeforeDocumentCreated(Node node, Locator locator) {
        this._tempNodes.add(node);
        this._tempLocators.add(locator);
    }

    @Override
    protected Element handleElementBeforeDocumentCreated(ResolvedName name, ElementLocator locator) {
        ResolvedName nameToUseForRoot;
        ResolvedName simulatedRoot = this.getParserConfiguration().getSimulatedRootName();
        if (simulatedRoot == null || name.matches(simulatedRoot)) {
            nameToUseForRoot = name;
            simulatedRoot = null;
        } else {
            nameToUseForRoot = simulatedRoot;
        }
        DOMImplementation impl = this.getDOMImplementation();
        try {
            this._document = impl.createDocument(nameToUseForRoot.getNamespace(), nameToUseForRoot.getRawName(), this._documentType);
        }
        catch (Exception e) {
            this._document = null;
            this.getLogger().log(Level.WARNING, "Exception creating Document", e);
        }
        if (this._document != null) {
            Element toReturn;
            Element actualRoot = this._document.getDocumentElement();
            if (simulatedRoot != null) {
                toReturn = this._document.createElementNS(name.getNamespace(), name.getRawName());
                actualRoot.appendChild(toReturn);
                this._createFakeRootLocator(locator.getStartOffset());
                this.mapToLocator(actualRoot, this._fakeRootLocator);
            } else {
                toReturn = actualRoot;
            }
            this._plugInTempNodes();
            return toReturn;
        }
        return null;
    }

    private void _plugInTempNodes() {
        Element rootElement = this._document.getDocumentElement();
        DocumentType doctype = this._document.getDoctype();
        Node tempNode = null;
        Locator tempLocator = null;
        int tempSize = this._tempNodes.size();
        for (int i = 0; i < tempSize; ++i) {
            tempNode = (Node)this._tempNodes.get(i);
            tempNode = this._document.importNode(tempNode, true);
            tempLocator = (Locator)this._tempLocators.get(i);
            this.mapToLocator(tempNode, tempLocator);
            if (doctype != null && i < this._numTempNodesBeforeDoctype) {
                this._document.insertBefore(tempNode, doctype);
                continue;
            }
            this._document.insertBefore(tempNode, rootElement);
        }
        this._tempNodes.clear();
        this._tempLocators.clear();
    }

    private void _considerFakeRoot(int offset) {
        ResolvedName simulatedRoot;
        if (this._document == null && (simulatedRoot = this.getParserConfiguration().getSimulatedRootName()) != null) {
            this._document = this.getDOMImplementation().createDocument(simulatedRoot.getNamespace(), simulatedRoot.getRawName(), this._documentType);
            this._createFakeRootLocator(offset);
            Element fakeRootElem = this._document.getDocumentElement();
            this.mapToLocator(fakeRootElem, this._fakeRootLocator);
            this.setCurrentParent(fakeRootElem);
            this._plugInTempNodes();
        }
    }

    private void _createFakeRootLocator(int offset) {
        assert (this._fakeRootLocator == null);
        SimpleLocator fakeStart = this.getLocatorManager().createBackwardsBiasedSimpleLocator(offset, offset, false);
        SimpleLocator fakeName = (SimpleLocator)fakeStart.getCopy();
        SimpleLocator fakeEnd = this.getLocatorManager().createSimpleLocator(offset, offset, false);
        this._fakeRootLocator = this.getLocatorManager().createElementLocator(fakeStart, fakeName, fakeEnd);
    }

    private Document _parse(ReadTextBuffer buffer, LocatorManager manager, Map locatorMap) {
        this._document = null;
        this._documentType = null;
        this._xmlDeclarationInfo = null;
        this._fakeRootLocator = null;
        this._numTempNodesBeforeDoctype = 0;
        this._tempNodes.clear();
        this._tempLocators.clear();
        this.doParse(buffer, manager, locatorMap, null, null);
        if (this._document == null && !this.getDOMImplementation().getClass().getName().startsWith("MDS")) {
            this._considerFakeRoot(buffer.getLength());
            if (this._document == null) {
                this._document = this.getDOMImplementation().createDocument(null, "bogusRoot", this._documentType);
                this._document.removeChild(this._document.getDocumentElement());
                this._plugInTempNodes();
            }
        }
        if (this._fakeRootLocator != null) {
            int len = buffer.getLength();
            this._fakeRootLocator.getEndTagLocator().setStartOffset(len);
            this._fakeRootLocator.getEndTagLocator().setEndOffset(len);
            this._fakeRootLocator.attach(manager, true);
        }
        Document returnDoc = this._document;
        this._document = null;
        this._documentType = null;
        this._fakeRootLocator = null;
        this._numTempNodesBeforeDoctype = 0;
        return returnDoc;
    }

    XmlDeclarationInfo __getXmlDeclarationInfo() {
        return this._xmlDeclarationInfo;
    }
}

