/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.Services;

public class ADFServicesImpl
implements Services {
    private List<ServicePlugin> plugins = null;
    private URL url = null;

    private static final URL newURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ADFServicesImpl(URL url, Enumeration svcs) {
        String proto = url.getProtocol();
        if ("code-source".equalsIgnoreCase(proto) || "zip".equalsIgnoreCase(proto)) {
            String urlStr = url.toString();
            int colon = urlStr.indexOf(58);
            this.url = url.getPath().indexOf(33) == -1 ? ADFServicesImpl.newURL("file" + urlStr.substring(colon)) : ADFServicesImpl.newURL("jar:file" + urlStr.substring(colon));
        } else {
            this.url = url;
        }
        this.plugins = new ArrayList<ServicePlugin>(6);
        while (svcs.hasMoreElements()) {
            ServicePlugin plugin = new ServicePlugin(svcs.nextElement().toString());
            String remainder = plugin.getRemainder();
            if (remainder != null) {
                plugin = this.loadExtendsPlugin(plugin);
            }
            this.plugins.add(plugin);
        }
    }

    private ServicePlugin loadExtendsPlugin(ServicePlugin plugin) {
        try {
            Class clazz = ClassUtils.forName(plugin.getRemainder());
            Class[] paramTypes = new Class[]{String.class};
            Constructor ctor = clazz.getConstructor(paramTypes);
            Object[] params = new Object[]{plugin.toString()};
            return (ServicePlugin)ctor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ServicePlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public URL getServiceURL() {
        return this.url;
    }
}

