/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.net.URL;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.services.DescriptorContext;

public class DescriptorContextFactory {
    private DescriptorContextFactory() {
    }

    public static DescriptorContextFactory getInstance() {
        return new DescriptorContextFactory();
    }

    public DescriptorContext getContext(URL jarURL) throws NamingException {
        return this.getContext(jarURL, new Hashtable());
    }

    public DescriptorContext getContext(URL jarURL, Hashtable env) throws NamingException {
        if (!env.containsKey("java.naming.factory.initial")) {
            env.put("java.naming.factory.initial", "oracle.adf.share.services.jndi.DescriptorFactory");
        }
        if (jarURL != null) {
            env.put("java.naming.provider.url", jarURL);
        }
        Hashtable<?, ?> newEnv = new InitialContext(env).getEnvironment();
        return (DescriptorContext)newEnv.get("oracle.adf.share.services.DescriptorContext");
    }
}

