/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;

public class SensorTable {
    private static ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>> sSensor = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFPerfSensor putSensor(String name, ADFPerfSensor sensor) {
        ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>> concurrentHashMap = sSensor;
        synchronized (concurrentHashMap) {
            ClassLoader clsLoader = ClassUtils.getClassLoader();
            ConcurrentHashMap<String, ADFPerfSensor> hashtable = sSensor.get(clsLoader);
            ADFPerfSensor s = null;
            if (hashtable != null) {
                s = hashtable.get(name);
            }
            if (s == null) {
                if (hashtable == null) {
                    hashtable = new ConcurrentHashMap();
                    sSensor.put(clsLoader, hashtable);
                }
                hashtable.put(name, sensor);
                s = sensor;
            }
            return s;
        }
    }

    public static ADFPerfSensor getSensor(String name) {
        ClassLoader clsLoader = ClassUtils.getClassLoader();
        ConcurrentHashMap<String, ADFPerfSensor> hashtable = sSensor.get(clsLoader);
        ADFPerfSensor s = null;
        if (hashtable != null) {
            s = hashtable.get(name);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupSensors(ClassLoader classLoader) {
        ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>> concurrentHashMap = sSensor;
        synchronized (concurrentHashMap) {
            Iterator it = sSensor.keySet().iterator();
            while (it.hasNext()) {
                ClassLoader clLoader = (ClassLoader)it.next();
                if (clLoader != classLoader && !ClassUtils.isAncestor(clLoader, classLoader)) continue;
                ConcurrentHashMap<String, ADFPerfSensor> ht = sSensor.get(clLoader);
                Collection<ADFPerfSensor> pt = ht.values();
                for (ADFPerfSensor p : pt) {
                    p.reset();
                }
                ht.clear();
                it.remove();
            }
        }
    }
}

