/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLoggerFactory;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.analytics.AnalyticsFileHandler;
import oracle.adf.share.logging.internal.diagnostic.ADFLogRecord;
import oracle.adf.share.logging.internal.perf.PerfFileHandler;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

public class ADFLogger {
    private Logger mLogger = null;
    private Logger diaglogger = null;
    public static final Level INTERNAL_ERROR = ADFLoggerLevel.access$000();
    public static final Level ERROR = ADFLoggerLevel.access$100();
    public static final Level TRACE = ADFLoggerLevel.access$200();
    public static final Level NOTIFICATION = ADFLoggerLevel.access$300();
    public static final Level WARNING = ADFLoggerLevel.access$400();
    public static final String ENTERRING_TAG = "begin";
    public static final String EXITING_TAG = "end";
    public static final String ADD_CONTEXT_DATA_TAG = "add_context_data";
    public static final String ADF_MESSAGE_DELIMITER = ";#;";
    public static final String ADF_MESSAGE_STATUS = "ADF_MESSAGE_STATUS";
    public static final String ADF_MESSAGE_ACTION_NAME = "ADF_MESSAGE_ACTION_NAME";
    public static final String ADF_MESSAGE_ACTION_DESC = "ADF_MESSAGE_ACTION_DESC";
    public static final String ADF_MESSAGE_PAYLOAD = "ADF_MESSAGE_PAYLOAD";
    public static final String ADF_MESSAGE_CONTEXT_DATA = "ADF_MESSAGE_CONTEXT_DATA";
    public static final String ADF_MESSAGE_DEFAULT_CONTEXT_DATA = "ADF_MESSAGE_DEFAULT_CONTEXT_DATA";
    public static final String ADF_ANALYTICS_LOGGER_NAME = "oracle.adf.analytics";
    public static final String ADF_PERF_LOGGER_NAME = "oracle.adf.perf";
    public static final String ADF_ODL_LOGGER_NAME = "oracle.adf.share.logging.AdfOdlLogger";
    public static final String ADF_LOGGER_MESSAGE_BUNDLE = "oracle.adf.share.logging.resources.LoggerMessageBundle";

    protected ADFLogger(Logger log) {
        if (log == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_REQUIRED"));
        }
        this.mLogger = log;
        this.diaglogger = Logger.getLogger(ADF_ODL_LOGGER_NAME);
        try {
            DMSContextManager.setKeyAttribute((String)ADF_MESSAGE_CONTEXT_DATA, (int)1);
            DMSContextManager.setKeyAttribute((String)ADF_MESSAGE_ACTION_NAME, (int)1);
            DMSContextManager.setKeyAttribute((String)ADF_MESSAGE_ACTION_DESC, (int)1);
            DMSContextManager.setKeyAttribute((String)ADF_MESSAGE_STATUS, (int)1);
            DMSContextManager.setKeyAttribute((String)ADF_MESSAGE_DEFAULT_CONTEXT_DATA, (int)1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public static ADFLogger createADFLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_NAME_REQUIRED"));
        }
        Logger logger = ADFLoggerFactory.getADFLogger(name, null);
        return new ADFLogger(logger);
    }

    public static ADFLogger createADFLogger(String name, String resourceBundleName) {
        if (name == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_NAME_REQUIRED"));
        }
        Logger logger = ADFLoggerFactory.getADFLogger(name, resourceBundleName);
        return new ADFLogger(logger);
    }

    public static ADFLogger createADFLogger(Class c) {
        if (c == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return ADFLogger.createADFLogger(name);
    }

    public static ADFLogger createADFLogger(Class c, String resourceBundleName) {
        if (c == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return ADFLogger.createADFLogger(name, resourceBundleName);
    }

    public static ADFLogger createADFLogger(Package p) {
        if (p == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return ADFLogger.createADFLogger(name);
    }

    public static ADFLogger createADFLogger(Package p, String resourceBundleName) {
        if (p == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return ADFLogger.createADFLogger(name, resourceBundleName);
    }

    public static ADFLogger getAnonymousLogger() {
        return new ADFLogger(Logger.getAnonymousLogger());
    }

    public static ADFLogger getAnonymousLogger(String resourceBundleName) {
        return new ADFLogger(Logger.getAnonymousLogger(resourceBundleName));
    }

    public ResourceBundle getResourceBundle() {
        return this.mLogger.getResourceBundle();
    }

    public String getResourceBundleName() {
        return this.mLogger.getResourceBundleName();
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.mLogger.setFilter(newFilter);
    }

    public Filter getFilter() {
        return this.mLogger.getFilter();
    }

    public void log(LogRecord record) {
        this.mLogger.log(record);
    }

    public void log(String msg) {
        this.log(ADFLoggerLevel.TRACE, msg);
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            ADFLogRecord lr = new ADFLogRecord(this.getClass(), level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(String actionName, HashMap<String, String> contextData) {
        if (this.isLoggable(Level.CONFIG) && actionName != null) {
            String ctxData;
            ResourceBundle rb = this.getResourceBundle();
            String actionDesc = "";
            String disCol = "";
            String disColValue = "";
            if (rb != null) {
                String actionNamePrefix = actionName.trim().replace(' ', '_');
                try {
                    actionDesc = rb.getString(actionNamePrefix + "_DESC");
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                try {
                    disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                    String val = contextData.get(disCol);
                    if (val != null) {
                        disColValue = val;
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            ExecutionContext context = ExecutionContext.get();
            if (contextData == null) {
                contextData = new HashMap();
            }
            if ((ctxData = this.convertContextDataMap(contextData)).length() > 0) {
                context.setValue(ADF_MESSAGE_CONTEXT_DATA, ctxData);
            }
            context.setValue(ADF_MESSAGE_ACTION_NAME, actionName);
            context.setValue(ADF_MESSAGE_ACTION_DESC, actionDesc);
            context.setValue(ADF_MESSAGE_STATUS, ENTERRING_TAG);
            if (disCol != null && disCol.trim().length() > 0) {
                context.setValue(ADF_MESSAGE_DEFAULT_CONTEXT_DATA, disCol + "=" + disColValue);
            }
            try {
                this.mLogger.log(Level.CONFIG, actionName);
            }
            finally {
                context.setValue(ADF_MESSAGE_CONTEXT_DATA, null);
                context.setValue(ADF_MESSAGE_ACTION_NAME, null);
                context.setValue(ADF_MESSAGE_ACTION_DESC, null);
                context.setValue(ADF_MESSAGE_STATUS, null);
                context.setValue(ADF_MESSAGE_DEFAULT_CONTEXT_DATA, null);
                if (ctxData.length() > 0) {
                    context.setValue(ADF_MESSAGE_CONTEXT_DATA, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextData(String actionName, HashMap<String, String> contextData) {
        if (this.isLoggable(Level.CONFIG)) {
            String ctxData;
            ExecutionContext context = ExecutionContext.get();
            if (contextData == null) {
                contextData = new HashMap();
            }
            if ((ctxData = this.convertContextDataMap(contextData)).length() > 0) {
                context.setValue(ADF_MESSAGE_CONTEXT_DATA, ctxData);
            }
            context.setValue(ADF_MESSAGE_ACTION_NAME, actionName);
            context.setValue(ADF_MESSAGE_STATUS, ADD_CONTEXT_DATA_TAG);
            try {
                this.mLogger.log(Level.CONFIG, actionName);
            }
            finally {
                context.setValue(ADF_MESSAGE_CONTEXT_DATA, null);
                context.setValue(ADF_MESSAGE_ACTION_NAME, null);
                context.setValue(ADF_MESSAGE_STATUS, null);
            }
        }
    }

    private String convertContextDataMap(HashMap<String, String> payload) {
        if (payload == null || payload.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        for (String key : payload.keySet()) {
            sb.append(key).append("=").append(payload.get(key)).append(ADF_MESSAGE_DELIMITER);
        }
        String data = sb.toString();
        data = data.substring(0, data.length() - ADF_MESSAGE_DELIMITER.length());
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(String actionName) {
        if (this.isLoggable(Level.CONFIG)) {
            ExecutionContext context = ExecutionContext.get();
            context.setValue(ADF_MESSAGE_STATUS, EXITING_TAG);
            context.setValue(ADF_MESSAGE_ACTION_NAME, actionName);
            try {
                this.diaglogger.log(Level.CONFIG, actionName);
            }
            finally {
                context.setValue(ADF_MESSAGE_STATUS, null);
                context.setValue(ADF_MESSAGE_ACTION_NAME, null);
            }
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.mLogger.entering(sourceClass, sourceMethod);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.mLogger.entering(sourceClass, sourceMethod, param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.mLogger.entering(sourceClass, sourceMethod, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.mLogger.exiting(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.mLogger.exiting(sourceClass, sourceMethod, result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.mLogger.throwing(sourceClass, sourceMethod, thrown);
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void throwing(Level level, String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(level, sourceClass, sourceMethod, "", thrown);
    }

    public void severe(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, param1);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, params);
    }

    public void warning(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, param1);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, params);
    }

    public void info(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, param1);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, params);
    }

    public void config(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.mLogger.logp(Level.CONFIG, sourceClass, sourceMethod, msg, param1);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg, params);
    }

    public void fine(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, param1);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, params);
    }

    public void finer(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, param1);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void finest(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, param1);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object params1, Object params2, Object params3) {
        this.logp(level, sourceClass, sourceMethod, msg, new Object[]{params1, params2, params3});
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.mLogger.setLevel(newLevel);
    }

    public Level getLevel() {
        return this.mLogger.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this.mLogger.isLoggable(level);
    }

    public String getName() {
        return this.mLogger.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.mLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.mLogger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.mLogger.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.mLogger.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this.mLogger.getUseParentHandlers();
    }

    public Logger getParent() {
        return this.mLogger.getParent();
    }

    public void setParent(Logger parent) {
        this.mLogger.setParent(parent);
    }

    private ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        ClassLoader cl = ClassUtils.getClassLoader();
        return ResourceBundle.getBundle(name, currentLocale, cl);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.mLogger.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.mLogger.getName());
        String ebname = this.mLogger.getResourceBundleName();
        if (ebname != null) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this.mLogger.getResourceBundle());
        }
        this.mLogger.log(lr);
    }

    public void internal(Throwable t) {
        this.internal("", t);
    }

    public void internal(String message, Throwable t) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, t);
    }

    public void internal(String message, Object param) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, param);
    }

    public void internal(String message, Object[] params) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, params);
    }

    public void severe(Throwable t) {
        this.severe("", t);
    }

    public void severe(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public void severe(String message, Object param) {
        this.log(Level.SEVERE, message, param);
    }

    public void severe(String message, Object[] params) {
        this.log(Level.SEVERE, message, params);
    }

    public void warning(Throwable t) {
        this.warning("", t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void warning(String message, Object param) {
        this.log(Level.WARNING, message, param);
    }

    public void warning(String message, Object[] params) {
        this.log(Level.WARNING, message, params);
    }

    public void info(Throwable t) {
        this.info("", t);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void info(String message, Object param) {
        this.log(Level.INFO, message, param);
    }

    public void info(String message, Object[] params) {
        this.log(Level.INFO, message, params);
    }

    public void fine(Throwable t) {
        this.fine("", t);
    }

    public void fine(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public void fine(String message, Object param) {
        this.log(Level.FINE, message, param);
    }

    public void fine(String message, Object[] params) {
        this.log(Level.FINE, message, params);
    }

    public void finer(Throwable t) {
        this.finer("", t);
    }

    public void finer(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    public void finer(String message, Object param) {
        this.log(Level.FINER, message, param);
    }

    public void finer(String message, Object[] params) {
        this.log(Level.FINER, message, params);
    }

    public void finest(Throwable t) {
        this.finest("", t);
    }

    public void finest(String message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    public void finest(String message, Object param) {
        this.log(Level.FINEST, message, param);
    }

    public void finest(String message, Object[] params) {
        this.log(Level.FINEST, message, params);
    }

    public boolean isInternal() {
        return this.isLoggable(ADFLoggerLevel.INTERNAL_ERROR);
    }

    public boolean isSevere() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public boolean isFine() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isFiner() {
        return this.isLoggable(Level.FINER);
    }

    public boolean isFinest() {
        return this.isLoggable(Level.FINEST);
    }

    public static void flush() {
        int i;
        Logger logger = ADFLoggerFactory.getADFLogger(ADF_PERF_LOGGER_NAME, null);
        Handler[] h = logger.getHandlers();
        for (i = 0; i < h.length; ++i) {
            if (!(h[i] instanceof PerfFileHandler)) continue;
            h[i].flush();
        }
        logger = ADFLoggerFactory.getADFLogger(ADF_ANALYTICS_LOGGER_NAME, null);
        h = logger.getHandlers();
        for (i = 0; i < h.length; ++i) {
            if (!(h[i] instanceof AnalyticsFileHandler)) continue;
            h[i].flush();
        }
    }

    @Deprecated
    public static String getECID() {
        String ecid = null;
        try {
            ecid = LoggingUtils.getECID();
            if (ecid != null) {
                ExecutionContext.stash((Object)ecid);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return ecid;
    }

    @Deprecated
    public static void setECID(String ecid) {
        try {
            ExecutionContext.get((Object)ecid);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public String getFormattedMessage(String msg) {
        return this.getFormattedMessage(msg, null);
    }

    public String getFormattedMessage(String msg, Object[] params) {
        String returnMessage = msg;
        ADFLogRecord lr = new ADFLogRecord(this.getClass(), Level.ALL, msg);
        ResourceBundle res = this.getResourceBundle();
        if (res != null) {
            lr.setResourceBundle(res);
        }
        if (params != null) {
            lr.setParameters(params);
        }
        Handler[] handlers = this.getHandlers();
        Formatter formatter = null;
        if (handlers.length > 0) {
            formatter = handlers[0].getFormatter();
        }
        if (formatter == null) {
            formatter = new SimpleFormatter();
        }
        returnMessage = formatter.format(lr);
        return returnMessage;
    }

    static {
        Logger baLogger = ADFLoggerFactory.getADFLogger(ADF_ANALYTICS_LOGGER_NAME, null);
        try {
            AnalyticsFileHandler.setupLoggerHandler(baLogger);
        }
        catch (Throwable t) {
            System.out.println(t.toString());
        }
    }

    private static class ADFLoggerLevel
    extends Level {
        private int currentADFLevel;
        private String adfName;
        private static final Level INTERNAL_ERROR = new ADFLoggerLevel("INTERNAL_ERROR", Level.SEVERE.intValue() + 100);
        private static final Level ERROR = Level.SEVERE;
        private static final Level WARNING = Level.WARNING;
        private static final Level NOTIFICATION = Level.INFO;
        private static final Level TRACE = Level.FINE;

        private ADFLoggerLevel(String name, int value) {
            super(name, value, null);
            this.currentADFLevel = value;
            this.adfName = name;
        }

        private Object readResolve() throws ObjectStreamException {
            return new ADFLoggerLevel(this.adfName, this.currentADFLevel);
        }

        static /* synthetic */ Level access$100() {
            return ERROR;
        }

        static /* synthetic */ Level access$300() {
            return NOTIFICATION;
        }

        static /* synthetic */ Level access$400() {
            return WARNING;
        }
    }
}

