/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.logging.ADFLogger;

public final class AdfJndiHelper {
    private static ADFLogger logger = null;
    public static final String READ_ONLY_FILESYSTEM_BACKING_STORE = "oracle.adf.share.jndi.FileSystemBackingStore.readonly";
    public static final String READ_ONLY_BACKING_STORE = "oracle.adf.share.jndi.DocumentBackingStore.isReadOnly";
    public static final String CREATE_SESSION_BACKING_STORE = "oracle.adf.share.jndi.DocumentBackingStore.doCreateSession";
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.BaseMessages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.jndi.resources.BaseMessages");
    public static final String NAMED_CONTEXT_ENV = "named.adf.context";
    public static final String CONN_INIT_REQUIRED = "AdfJndiHelper_IsConnectionInitRequired";
    public static final String CONN_MBEAN_EXECUTING = "AdfJndiHelper_ConnectionRuntimeMBeansExecuting";

    private static ADFLogger getLogger() {
        if (logger == null) {
            logger = ADFLogger.createADFLogger("oracle.adf.share.jndi");
        }
        return logger;
    }

    public static final Context createReadOnlyFileSystemContext(String connectionsFile) {
        return AdfJndiHelper.createReadOnlyFileSystemContext(connectionsFile, null);
    }

    public static final Context createReadOnlyFileSystemContext(String connectionsFile, String namedContext) {
        InitialContext ctx = null;
        Hashtable<String, String> mContextEnv = new Hashtable<String, String>(3);
        mContextEnv.put("java.naming.factory.initial", "oracle.adf.share.jndi.InitialContextFactoryImpl");
        mContextEnv.put("java.naming.provider.url", connectionsFile);
        mContextEnv.put(READ_ONLY_FILESYSTEM_BACKING_STORE, "true");
        if (namedContext != null) {
            mContextEnv.put(NAMED_CONTEXT_ENV, namedContext);
        }
        try {
            ctx = new InitialContext(mContextEnv);
        }
        catch (NamingException e) {
            AdfJndiHelper.getLogger().severe(resBundle.getString("CONTEXT_NOT_CREATED"), e);
        }
        return ctx;
    }

    public static final Context createDefaultNonCachedConnectionsContext() throws NamingException {
        InitialContext ctx = null;
        Hashtable<String, String> mContextEnv = new Hashtable<String, String>(5);
        mContextEnv.put("java.naming.factory.initial", "oracle.adf.share.jndi.InitialContextFactoryImpl");
        mContextEnv.put("java.naming.provider.url", "META-INF/connections.xml");
        mContextEnv.put("oracle.adf.share.jndi.documentstore", "oracle.adf.share.jndi.MDSBackingStore");
        try {
            ctx = new InitialContext(mContextEnv);
        }
        catch (NamingException e) {
            AdfJndiHelper.getLogger().severe(resBundle.getString("CONTEXT_NOT_CREATED"), e);
            throw e;
        }
        return ctx;
    }
}

