/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class GetResourcesAsStreamsPrivAction
implements PrivilegedExceptionAction {
    ClassLoader _loader;
    String _resourceName;

    public GetResourcesAsStreamsPrivAction(ClassLoader loader, String resourceName) {
        this._loader = loader;
        this._resourceName = resourceName;
    }

    public List<InputStream> run() throws IOException {
        Enumeration<URL> fileInsts = this._loader.getResources(this._resourceName);
        if (fileInsts == null) {
            throw new IOException("Polcy File:" + this._resourceName + " Not found on the classpath");
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        while (fileInsts.hasMoreElements()) {
            URL oneRes = fileInsts.nextElement();
            InputStream is = null;
            try {
                is = oneRes.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (is == null) continue;
            streams.add(is);
        }
        return streams;
    }
}

