/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLName {
    final String _nsURI;
    final String _defaultPrefix;
    final String _localName;

    public XMLName(String nsURI, String defaultPrefix, String localName) {
        this._nsURI = nsURI;
        this._defaultPrefix = defaultPrefix;
        this._localName = localName;
    }

    String getQname(String preferredPrefix) {
        return preferredPrefix != null ? this.getQnameImpl(preferredPrefix) : this.getQname();
    }

    private String getQname() {
        return this.getQnameImpl(this._defaultPrefix);
    }

    private String getQnameImpl(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this._localName;
        }
        return prefix + ":" + this._localName;
    }

    static boolean isDefaultNamespace(Element elem, String namespaceURI) {
        String prefix = elem.getPrefix();
        if (prefix == null) {
            return namespaceURI.equals(elem.getNamespaceURI());
        }
        Attr attr = elem.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr != null) {
            return namespaceURI.equals(attr.getValue());
        }
        Element ancestorElement = XMLName.getParentElement(elem);
        if (ancestorElement != null) {
            return XMLName.isDefaultNamespace(ancestorElement, namespaceURI);
        }
        return false;
    }

    static String lookupPrefix(Element elem, String namespaceURI) {
        if (elem == null || namespaceURI == null || namespaceURI.length() == 0) {
            return null;
        }
        return XMLName.lookupNamespacePrefix(elem, namespaceURI, elem);
    }

    private static String lookupNamespacePrefix(Element elem, String namespaceURI, Element originalElement) {
        String prefix;
        String elemURI = elem.getNamespaceURI();
        if (elemURI != null && elemURI.equals(namespaceURI) && (prefix = elem.getPrefix()) != null && namespaceURI.equals(XMLName.lookupNamespaceURI(originalElement, prefix))) {
            return prefix;
        }
        NamedNodeMap attrs = elem.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!"xmlns".equals(attr.getPrefix()) || !namespaceURI.equals(attr.getValue()) || !namespaceURI.equals(XMLName.lookupNamespaceURI(originalElement, attr.getLocalName()))) continue;
            return attr.getLocalName();
        }
        Element ancestorElement = XMLName.getParentElement(elem);
        if (ancestorElement != null) {
            return XMLName.lookupNamespacePrefix(ancestorElement, namespaceURI, originalElement);
        }
        return null;
    }

    private static String lookupNamespaceURI(Element elem, String prefix) {
        String nsURI = elem.getNamespaceURI();
        if (nsURI != null && prefix.equals(elem.getPrefix())) {
            return nsURI;
        }
        NamedNodeMap attrs = elem.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if ("xmlns".equals(attr.getPrefix()) && attr.getLocalName().equals(prefix)) {
                return XMLName.nullifyIfEmpty(attr.getValue());
            }
            if (!"xmlns".equals(attr.getLocalName()) || attr.getPrefix() != null) continue;
            return XMLName.nullifyIfEmpty(attr.getValue());
        }
        Element ancestorElement = XMLName.getParentElement(elem);
        if (ancestorElement != null) {
            return XMLName.lookupNamespaceURI(ancestorElement, prefix);
        }
        return null;
    }

    private static String nullifyIfEmpty(String s) {
        return s != null && s.length() > 0 ? s : null;
    }

    private static Element getParentElement(Element elem) {
        Node curNode = elem;
        do {
            if ((curNode = curNode.getParentNode()) != null) continue;
            return null;
        } while (curNode.getNodeType() != 1);
        return (Element)curNode;
    }
}

