/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.Method;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

final class SetImpl
extends XMLBindingInfo {
    private final int _xmlType;
    private transient BindingContext _bc;

    SetImpl(int elemOrAttr, String xmlName) {
        super(xmlName);
        this._xmlType = elemOrAttr;
    }

    SetImpl(int elemOrAttr, String uri, String defaultPrefix, String xmlName) {
        super(uri, defaultPrefix, xmlName, null);
        this._xmlType = elemOrAttr;
    }

    @Override
    Object invoke(BindingContext bc, Object proxy, Method method, Object[] args) {
        this._bc = bc;
        this.callSetter(method.getParameterTypes()[0], args[0]);
        return null;
    }

    void invoke(BindingContext bc, Method method, Object value) {
        this._bc = bc;
        this.callSetter(method.getReturnType(), value);
    }

    private void callSetter(Class propertyType, Object value) {
        if (propertyType == String.class) {
            this.callSetter_String(BindingContext.obj2String(value));
        } else if (propertyType == Boolean.class) {
            this.callSetter_Boolean(value);
        } else if (propertyType == Integer.class) {
            this.callSetter_Integer(value);
        } else {
            this.callSetterForUniqueElem(value);
        }
    }

    private void callSetterForUniqueElem(Object value) {
        Element newElem = BindingContext.extractElementFromProxy(value);
        NodeListImpl nodeList = BindingContext.getChildrenByQName(this._bc._contextElem, this._nsURI, this._localName);
        Element curElem = nodeList.getLength() > 0 ? (Element)nodeList.item(0) : null;
        this._bc.setElement(newElem, curElem, this);
    }

    private void callSetter_Boolean(Object value) {
        this.callSetter_String(BindingContext.obj2String(value));
    }

    private void callSetter_Integer(Object value) {
        this.callSetter_String(BindingContext.obj2String(value));
    }

    private void callSetter_String(String arg) {
        switch (this._xmlType) {
            case 0: {
                this.insertChangeDeleteLeafElem(arg);
                return;
            }
            case 1: {
                this.insertChangeDeleteAttr(arg);
                return;
            }
        }
        throw new IllegalStateException("Invalid XML type in XMLBindingInfo: " + this._xmlType);
    }

    private void insertChangeDeleteLeafElem(String arg) {
        boolean createTextNodeIfNecessary = arg != null;
        Text text = BindingContext.findFirstTextNodeInChildElement(this._bc._contextElem, this, createTextNodeIfNecessary);
        this.insertChangeDeleteText(text, arg);
    }

    private void insertChangeDeleteText(Text text, String arg) {
        if (text != null) {
            this.changeDeleteText(text, arg);
        } else if (arg != null) {
            this.insertLeafElem(arg);
        }
    }

    private void changeDeleteText(Text text, String arg) {
        if (arg != null) {
            if (!arg.equals(text.getNodeValue())) {
                text.setNodeValue(arg);
            }
        } else {
            Element parentElem = (Element)text.getParentNode();
            NamedNodeMap attrs = parentElem.getAttributes();
            if (attrs.getLength() > 0) {
                parentElem.removeChild(text);
            } else {
                BindingContext.deleteElement(parentElem);
            }
        }
    }

    private void insertLeafElem(String arg) {
        Text newText = this._bc._rt._document.createTextNode(arg);
        Element newElem = this._bc.createElement(this);
        newElem.appendChild(newText);
        this._bc.insertElem(this, newElem);
    }

    private void insertChangeDeleteAttr(String arg) {
        Attr attr = this._bc._contextElem.getAttributeNodeNS(this._nsURI, this._localName);
        if (attr != null) {
            this.changeOrDeleteAttr(attr, arg);
        } else {
            this.insertAttribute(arg);
        }
    }

    private void changeOrDeleteAttr(Attr attr, String arg) {
        if (arg != null) {
            if (!arg.equals(attr.getValue())) {
                attr.setValue(arg);
            }
        } else {
            this._bc._contextElem.removeAttributeNode(attr);
        }
    }

    private void insertAttribute(String arg) {
        if (arg != null) {
            String preferredPrefix = this._bc.findPrefix(this._nsURI);
            if ("".equals(preferredPrefix)) {
                preferredPrefix = null;
            }
            this._bc._contextElem.setAttributeNS(this._nsURI, this.getQname(preferredPrefix), arg);
        }
    }
}

