/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementProxy;
import oracle.javatools.xml.bind.IndentPrefs;
import oracle.javatools.xml.bind.XMLBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMBindingRuntime {
    private static IndentPrefs _defaultIndentPrefs = new IndentPrefs();
    final Document _document;
    private final ElementProxy _handler;
    final XMLBinding _binding;
    private final Class _rootInterface;
    private Object _proxy;
    final String _eol = "\n";
    boolean _enableWhitespace = true;
    private IndentPrefs _indent;

    public DOMBindingRuntime(Document document, XMLBinding binding) {
        DOMBindingRuntime.checkNull(document, "document must not be null");
        DOMBindingRuntime.checkNull(binding, "binding must not be null");
        this._document = document;
        Element rootElem = document.getDocumentElement();
        BindingContext bc = new BindingContext(this, binding.getRootInterface(), rootElem, 1);
        this._handler = new ElementProxy(bc);
        this._binding = binding;
        this._rootInterface = binding.getRootInterface();
        DOMBindingRuntime.checkNull(this._rootInterface, "root interface must not be null");
    }

    public static Element getBoundElement(Object proxyObj) {
        if (proxyObj != null) {
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(proxyObj);
                if (handler instanceof ElementProxy) {
                    return ((ElementProxy)handler)._bc._contextElem;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void checkNull(Object obj, String npeMesg) {
        if (obj == null) {
            throw new NullPointerException(npeMesg);
        }
    }

    public static void setDefaultIndentPrefs(IndentPrefs defaultIndentPrefs) {
        if (defaultIndentPrefs != null) {
            _defaultIndentPrefs = defaultIndentPrefs;
        }
    }

    public void setIndentWidth(int width, boolean useTabs) {
        this.setIndentWidth(width, useTabs, 8);
    }

    public void setIndentWidth(final int width, final boolean useTabs, final int tabSize) {
        this._indent = new IndentPrefs(){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public boolean getUseSpaces() {
                return !useTabs;
            }

            @Override
            public int getTabSize() {
                return tabSize;
            }
        };
    }

    public void setEnableWhitespace(boolean enableWhitespace) {
        this._enableWhitespace = enableWhitespace;
    }

    char[] getIndent(int depth) {
        int i;
        if (depth == 0 || this._indent.getWidth() == 0) {
            return new char[0];
        }
        int width = this._indent.getWidth();
        width = Math.max(width, 0);
        width = Math.min(width, 1000);
        int numSpaces = depth * width;
        int numTabs = 0;
        if (!this._indent.getUseSpaces()) {
            int tabSize = this._indent.getTabSize();
            if (tabSize <= 0) {
                tabSize = 8;
            }
            numTabs = numSpaces / tabSize;
            numSpaces %= tabSize;
        }
        char[] chars = new char[numTabs + numSpaces];
        for (i = 0; i < numTabs; ++i) {
            chars[i] = 9;
        }
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        return chars;
    }

    public Object getProxy() {
        if (this._proxy == null) {
            this._proxy = BindingContext.createProxy(this._rootInterface, this._handler);
        }
        if (this._indent == null) {
            this.setIndentWidth(_defaultIndentPrefs.getWidth(), !_defaultIndentPrefs.getUseSpaces(), _defaultIndentPrefs.getTabSize());
        }
        return this._proxy;
    }
}

