/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public interface Filter<T> {
    public boolean matches(T var1);

    public static class Instances {
        public static <Q> Filter<Q> nonNull(Filter<Q> base) {
            if (base == null) {
                return Instances.acceptsAll();
            }
            return base;
        }

        public static <Q> Filter<Q> acceptsAll() {
            return Instances._all(true);
        }

        public static <Q> Filter<Q> acceptsNone() {
            return Instances._all(false);
        }

        private static <Q> Filter<Q> _all(final boolean result) {
            return new Filter<Q>(){

                @Override
                public boolean matches(Object value) {
                    return result;
                }
            };
        }

        public static <Q> Filter<Q> or(Filter<Q>[] filters) {
            return new Or<Q>(filters);
        }

        public static <Q> Filter<Q> and(Filter<Q>[] filters) {
            return new And<Q>(filters);
        }

        private static class And<Q>
        implements Filter<Q> {
            private Filter<Q>[] _filters;

            And(Filter<Q>[] filters) {
                this._filters = filters;
            }

            @Override
            public boolean matches(Q value) {
                for (int i = 0; i < this._filters.length; ++i) {
                    if (this._filters[i].matches(value)) continue;
                    return false;
                }
                return true;
            }
        }

        private static class Or<Q>
        implements Filter<Q> {
            private Filter<Q>[] _filters;

            Or(Filter<Q>[] filters) {
                this._filters = filters;
            }

            @Override
            public boolean matches(Q value) {
                for (int i = 0; i < this._filters.length; ++i) {
                    if (!this._filters[i].matches(value)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

