/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import oracle.javatools.logging.Diagnostics;

public final class EventThreadHangMonitor
extends EventQueue {
    private static final EventQueue INSTANCE = new EventThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS;
    private static final boolean LOG_ALL_THREADS;
    private static final boolean KEEP_DUMPING;
    private static final boolean LOG_TO_DIAGNOSTIC_DIR;
    private static AWTEvent currentEvent;
    private static int count;
    private static PrintStream logStream;
    private static final long NO_CURRENT_EVENT = 0L;
    private long startedLastEventDispatchAt = 0L;
    private boolean reportedHang = false;
    private Thread eventDispatchThread = null;
    private static final String THREAD_NAME = "EventDispatchThreadHangMonitor";

    private static void openLogFile() {
        File file = Diagnostics.newLockedFile((String)"AWTHANGCHECK");
        if (file == null) {
            return;
        }
        try {
            logStream = new PrintStream(new FileOutputStream(file, true));
            OutputStreamWriter writer = new OutputStreamWriter(logStream);
            Diagnostics.writeBanner((Writer)writer, (String)("AWT EDT Hang Monitor logging started at " + new Date()));
            logStream.println();
            Diagnostics.writeBanner((Writer)writer, (String)"Configuration");
            logStream.println("Monitor threshold: " + UNREASONABLE_DISPATCH_DURATION_MS + "ms");
            logStream.println("Log all threads: " + LOG_ALL_THREADS);
            logStream.println("Keep dumping: " + KEEP_DUMPING);
            Diagnostics.writeSystemConfiguration((Writer)writer);
            logStream.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EventThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer(THREAD_NAME, true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    private long timeSoFar() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.startedLastEventDispatchAt;
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this.preDispatchEvent(event);
        super.dispatchEvent(event);
        this.postDispatchEvent();
    }

    private synchronized void preDispatchEvent(AWTEvent event) {
        if (!EventQueue.isDispatchThread()) {
            this.stream().println("WARNING! Event posted on non-event thread " + Thread.currentThread() + ": " + event);
        }
        if (this.eventDispatchThread == null) {
            this.eventDispatchThread = Thread.currentThread();
        }
        currentEvent = event;
        this.reportedHang = false;
        this.startedLastEventDispatchAt = System.currentTimeMillis();
    }

    private synchronized void postDispatchEvent() {
        if (this.reportedHang) {
            this.stream().println(">>> [" + this.timeSoFar() + "ms] Event dispatch thread unstuck processing " + currentEvent);
            this.stream().println();
            if (LOG_TO_DIAGNOSTIC_DIR) {
                this.stream().close();
                logStream = null;
            }
        }
        this.startedLastEventDispatchAt = 0L;
    }

    private PrintStream stream() {
        if (!LOG_TO_DIAGNOSTIC_DIR) {
            return System.out;
        }
        if (logStream != null) {
            return logStream;
        }
        EventThreadHangMonitor.openLogFile();
        if (logStream == null) {
            return System.out;
        }
        return logStream;
    }

    static {
        count = 0;
        logStream = null;
        long duration = 500L;
        try {
            duration = Integer.parseInt(System.getProperty("ide.awthangmonitor.threshold", "500"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        UNREASONABLE_DISPATCH_DURATION_MS = duration;
        LOG_ALL_THREADS = Boolean.getBoolean("ide.awthangmonitor.allthreads");
        KEEP_DUMPING = Boolean.getBoolean("ide.awthangmonitor.keepdumping");
        LOG_TO_DIAGNOSTIC_DIR = Boolean.getBoolean("ide.awthangmonitor.autologfiles");
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventQueue eventQueue = INSTANCE;
            synchronized (eventQueue) {
                this.checkForHang();
            }
        }

        private void checkForHang() {
            if (EventThreadHangMonitor.this.startedLastEventDispatchAt == 0L) {
                return;
            }
            if (EventThreadHangMonitor.this.timeSoFar() > UNREASONABLE_DISPATCH_DURATION_MS) {
                this.reportHang();
            }
        }

        private void reportHang() {
            if (!KEEP_DUMPING && EventThreadHangMonitor.this.reportedHang) {
                return;
            }
            StackTraceElement[] edtStackTrace = EventThreadHangMonitor.this.eventDispatchThread.getStackTrace();
            if (EventThreadHangMonitor.this.reportedHang) {
                EventThreadHangMonitor.this.stream().println("--- [" + EventThreadHangMonitor.this.timeSoFar() + "ms] still processing event");
            } else {
                Diagnostics.writeBanner((Writer)new OutputStreamWriter(EventThreadHangMonitor.this.stream()), (String)("[" + ++count + "] AWT hang exceeding " + UNREASONABLE_DISPATCH_DURATION_MS + "ms detected"));
                EventThreadHangMonitor.this.stream().println("<<< [" + EventThreadHangMonitor.this.timeSoFar() + "ms] event dispatch thread stuck processing event " + currentEvent);
            }
            EventThreadHangMonitor.this.reportedHang = true;
            if (LOG_ALL_THREADS) {
                Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                EventThreadHangMonitor.this.stream().println("Full thread dump at " + new Date() + ":");
                for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                    Thread thread = entry.getKey();
                    if (EventThreadHangMonitor.THREAD_NAME.equals(thread.getName())) continue;
                    StackTraceElement[] stackTrace = entry.getValue();
                    EventThreadHangMonitor.this.stream().printf("\"%s\" %s prio=%s %s%n", thread.getName(), thread.isDaemon() ? "daemon" : "", String.valueOf(thread.getPriority()), String.valueOf((Object)thread.getState()).toLowerCase());
                    this.printStackTrace(EventThreadHangMonitor.this.stream(), stackTrace);
                    EventThreadHangMonitor.this.stream().println();
                }
            } else {
                this.printStackTrace(EventThreadHangMonitor.this.stream(), edtStackTrace);
            }
        }

        private void printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
            if (stackTrace.length == 0) {
                out.println("    (no stack)");
            }
            String ourEventQueueClassName = EventThreadHangMonitor.class.getName();
            for (StackTraceElement stackTraceElement : stackTrace) {
                if (stackTraceElement.getClassName().equals(ourEventQueueClassName)) {
                    return;
                }
                out.println("    " + stackTraceElement);
            }
        }
    }
}

