/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.PlatformUtils;

public class PrintOptions
extends HashStructureAdapter
implements Copyable {
    private static final String PRINT_COLORS = "printColors";
    private static final String PRINT_FONT_STYLES = "printFontStyles";
    private static final String WRAP_BEHAVIOR = "wrapBehavior";
    public static final int WRAP_NONE = 0;
    public static final int WRAP_FILL_WIDTH = 1;
    private static final String WRAP_SYMBOL = "wrapSymbol";
    private static final String PRINT_LINE_NUMBERS = "printLineNumbers";
    public static final int LINE_NUMBERS_NONE = 0;
    public static final int LINE_NUMBERS_EVERY = 1;
    private static final String PRINT_PAGE_NUMBERS = "printPageNumbers";
    private static final String PRINT_FILE_HEADER = "printFileHeader";
    private static final String FONT_FAMILY = "fontFamily";
    private static final String FONT_SIZE = "fontSize";

    public PrintOptions() {
        this(HashStructure.newInstance());
    }

    public PrintOptions(HashStructure hash) {
        super(hash);
        String defaultFontFamily = PlatformUtils.isMac() ? "Monospaced" : "DialogInput";
        this._hash.getString(FONT_FAMILY, defaultFontFamily);
    }

    public Object clone() {
        return this.copyTo(null);
    }

    public boolean getPrintColors() {
        return this._hash.getBoolean(PRINT_COLORS, true);
    }

    public void setPrintColors(boolean printColors) {
        this._hash.putBoolean(PRINT_COLORS, printColors);
    }

    public boolean getPrintFontStyles() {
        return this._hash.getBoolean(PRINT_FONT_STYLES, true);
    }

    public void setPrintFontStyles(boolean printFontStyles) {
        this._hash.putBoolean(PRINT_FONT_STYLES, printFontStyles);
    }

    public int getWrapBehavior() {
        return this._hash.getInt(WRAP_BEHAVIOR, 1);
    }

    public void setWrapBehavior(int wrapBehavior) {
        this._hash.putInt(WRAP_BEHAVIOR, wrapBehavior);
    }

    public String getWrapSymbol() {
        return this._hash.getString(WRAP_SYMBOL, "\\");
    }

    public void setWrapSymbol(String wrapSymbol) {
        this._hash.putString(WRAP_SYMBOL, wrapSymbol);
    }

    public int getPrintLineNumbers() {
        return this._hash.getInt(PRINT_LINE_NUMBERS, 1);
    }

    public void setPrintLineNumbers(int printLineNumbers) {
        this._hash.putInt(PRINT_LINE_NUMBERS, printLineNumbers);
    }

    public boolean getPrintPageNumbers() {
        return this._hash.getBoolean(PRINT_PAGE_NUMBERS, true);
    }

    public void setPrintPageNumbers(boolean printPageNumbers) {
        this._hash.putBoolean(PRINT_PAGE_NUMBERS, printPageNumbers);
    }

    public boolean getPrintFileHeader() {
        return this._hash.getBoolean(PRINT_FILE_HEADER, true);
    }

    public void setPrintFileHeader(boolean printFileHeader) {
        this._hash.putBoolean(PRINT_FILE_HEADER, printFileHeader);
    }

    public String getFontFamily() {
        return this._hash.getString(FONT_FAMILY, "DialogInput");
    }

    public void setFontFamily(String fontFamily) {
        this._hash.putString(FONT_FAMILY, fontFamily);
    }

    public int getFontSize() {
        return this._hash.getInt(FONT_SIZE, 10);
    }

    public void setFontSize(int fontSize) {
        this._hash.putInt(FONT_SIZE, fontSize);
    }
}

