/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JWindow;
import oracle.javatools.editor.popup.PopupWindowListener;

public final class PopupWindow {
    JAWSLabel _jawsLabel;
    AccessibleContext accessibleContext;
    Component content;
    JWindow window;
    boolean visible;
    PopupWindowListener listener;

    PopupWindow(Component content, JWindow window) {
        this.content = content;
        this.window = window;
        this._jawsLabel = new JAWSLabel();
        this._jawsLabel.setPreferredSize(new Dimension(0, 0));
        this.accessibleContext = this._jawsLabel.getAccessibleContext();
        window.getContentPane().add((Component)this._jawsLabel, "South");
    }

    public void setAccessibleName(String name) {
        this._jawsLabel.setText(name);
    }

    private class JAWSLabel
    extends JLabel {
        private JAWSLabel() {
        }

        @Override
        public void setText(String text) {
            String oldText = this.getText();
            super.setText(text);
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.firePropertyChange("AccessibleName", oldText, text);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJAWSLabel();
            }
            return this.accessibleContext;
        }

        private class AccessibleJAWSLabel
        extends JLabel.AccessibleJLabel {
            private AccessibleJAWSLabel() {
                super(JAWSLabel.this);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
                super.addPropertyChangeListener(listener);
                String str = JAWSLabel.this.getText();
                if (str != null) {
                    JAWSLabel.this.setText("");
                    JAWSLabel.this.setText(str);
                }
            }
        }
    }
}

