/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.TagBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.HTMLTokens;

public class HTMLBlockRenderer
extends LexerBlockRenderer
implements HTMLTokens {
    protected TagBlockRenderer tagRenderer;
    protected BlockRenderer jsRenderer;
    protected BlockRenderer styleRenderer;
    protected HTMLLexer scratchLexer;
    protected LexerToken scratchToken;

    public HTMLBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.tagRenderer = this.createTagRenderer(textBuffer);
        this.jsRenderer = this.createJSRenderer(textBuffer);
        this.styleRenderer = this.createCSSRenderer(textBuffer);
    }

    protected TagBlockRenderer createTagRenderer(TextBuffer textBuffer) {
        return new TagBlockRenderer(textBuffer);
    }

    protected BlockRenderer createCSSRenderer(TextBuffer textBuffer) {
        return LanguageModule.createBlockRendererForFileType("css", textBuffer);
    }

    protected BlockRenderer createJSRenderer(TextBuffer textBuffer) {
        return LanguageModule.createBlockRendererForFileType("js", textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        HTMLLexer lexer = new HTMLLexer();
        lexer.setRecognizeEmbeddedTags(true);
        lexer.setRecognizeScripts(true);
        lexer.setRecognizeStyles(true);
        return lexer;
    }

    public void setRecognizeJSP(boolean recognizeJSP) {
        HTMLLexer htmlLexer = (HTMLLexer)this.getLexer();
        htmlLexer.setRecognizeJSP(recognizeJSP);
        htmlLexer.setRecognizeEmbeddedTags(recognizeJSP);
        this.tagRenderer.setRecognizeJSP(recognizeJSP);
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 11: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderHTMLTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 13: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderHTMLScript(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 14: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderHTMLStyle(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                throw new UnsupportedOperationException("cannot map jsp tags");
            }
            case 11: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
            case 12: {
                return "html-comment-style";
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderHTMLScript(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this.scratchLexer == null) {
            this.scratchLexer = (HTMLLexer)this.createLexer();
            this.scratchLexer.setRecognizeScripts(false);
            this.scratchLexer.setRecognizeStyles(false);
            this.scratchToken = this.scratchLexer.createLexerToken();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        this.scratchLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        this.scratchLexer.setPosition(tokenStart);
        int tagToken = this.scratchLexer.lex(this.scratchToken);
        int tagStart = tokenStart;
        int tagEnd = this.scratchToken.getEndOffset();
        this.renderHTMLTag(fragmentsList, tagToken, tagStart, tagEnd, Math.max(tagStart, clipStart), Math.min(tagEnd, clipEnd));
        this.scratchLexer.setTextBuffer(null);
        int endScriptStartOffset = this.findScriptEnd(textBuffer, tagEnd, tokenEnd);
        int endScriptEndOffset = tokenEnd;
        BlockRenderer rendererToUse = this.getRenderer(textBuffer, tagStart, tagEnd);
        rendererToUse.renderBlock(fragmentsList, tagEnd, endScriptStartOffset, Math.max(tagEnd, clipStart), Math.min(endScriptStartOffset, clipEnd));
        if (endScriptStartOffset < endScriptEndOffset) {
            this.renderHTMLTag(fragmentsList, tagToken, endScriptStartOffset, endScriptEndOffset, Math.max(endScriptStartOffset, clipStart), Math.min(endScriptEndOffset, clipEnd));
        }
    }

    protected void renderHTMLStyle(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (this.scratchLexer == null) {
            this.scratchLexer = (HTMLLexer)this.createLexer();
            this.scratchLexer.setRecognizeStyles(false);
            this.scratchLexer.setRecognizeScripts(false);
            this.scratchToken = this.scratchLexer.createLexerToken();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        this.scratchLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        this.scratchLexer.setPosition(tokenStart);
        int tagToken = this.scratchLexer.lex(this.scratchToken);
        int tagStart = tokenStart;
        int tagEnd = this.scratchToken.getEndOffset();
        this.renderHTMLTag(fragmentsList, tagToken, tagStart, tagEnd, Math.max(tagStart, clipStart), Math.min(tagEnd, clipEnd));
        this.scratchLexer.setTextBuffer(null);
        int endScriptStartOffset = this.findScriptEnd(textBuffer, tagEnd, tokenEnd);
        int endScriptEndOffset = tokenEnd;
        BlockRenderer rendererToUse = this.getStyleRenderer(textBuffer, tagStart, tagEnd);
        int newClipStart = Math.max(tagEnd, clipStart);
        int newClipEnd = Math.min(endScriptStartOffset, clipEnd);
        rendererToUse.renderBlock(fragmentsList, tagEnd, endScriptStartOffset, newClipStart, newClipEnd);
        if (endScriptStartOffset < endScriptEndOffset) {
            this.renderHTMLTag(fragmentsList, tagToken, endScriptStartOffset, endScriptEndOffset, Math.max(endScriptStartOffset, clipStart), Math.min(endScriptEndOffset, clipEnd));
        }
    }

    protected BlockRenderer getRenderer(TextBuffer textBuffer, int scriptStart, int scriptEnd) {
        return this.jsRenderer;
    }

    protected int findScriptEnd(TextBuffer textBuffer, int startOffset, int endOffset) {
        int charsLeft;
        char c;
        int currentOffset;
        for (currentOffset = startOffset; !(currentOffset >= endOffset || (c = textBuffer.getChar(currentOffset)) == '<' && (charsLeft = endOffset - currentOffset) >= 3 && textBuffer.getChar(currentOffset + 1) == '/' && ('a' <= (c = textBuffer.getChar(currentOffset + 2)) && c <= 'z' || 'A' <= c && c <= 'Z')); ++currentOffset) {
        }
        return currentOffset;
    }

    protected boolean isScriptEnd(TextBuffer textBuffer, int startOffset, int endOffset) {
        char c;
        if (endOffset - startOffset < 9) {
            return false;
        }
        int current = startOffset;
        if ((c = textBuffer.getChar(current++)) != '<') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != '/') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = textBuffer.getChar(current++)) != 't' && c != 'T') {
            return false;
        }
        return (c = textBuffer.getChar(current++)) == '>';
    }

    protected BlockRenderer getStyleRenderer(TextBuffer textBuffer, int styleStart, int styleEnd) {
        return this.styleRenderer;
    }

    protected void renderHTMLTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        this.tagRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

