/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerBlockRenderer
implements BlockRenderer {
    protected TextBuffer textBuffer;
    protected Lexer lexer;
    protected LexerToken lexerToken;

    public LexerBlockRenderer(TextBuffer textBuffer) {
        this.textBuffer = textBuffer;
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected abstract Lexer createLexer();

    protected final Lexer getLexer() {
        if (this.lexer == null) {
            this.lexer = this.createLexer();
        }
        return this.lexer;
    }

    protected final LexerToken getLexerToken() {
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.createLexerToken();
        }
        return this.lexerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderBlock(StyledFragmentsList fragmentsList, int blockStartOffset, int blockEndOffset, int clipStartOffset, int clipEndOffset) {
        TextBuffer textBuffer = this.getTextBuffer();
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        Lexer lexer2 = lexer;
        synchronized (lexer2) {
            lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            lexer.setPosition(blockStartOffset);
            int lastEndOffset = clipStartOffset;
            while (lastEndOffset < clipEndOffset) {
                int token = lexer.lex(lexerToken);
                int tokenStart = lexerToken.getStartOffset();
                int tokenEnd = lexerToken.getEndOffset();
                if (tokenEnd <= clipStartOffset) continue;
                if (tokenStart > lastEndOffset) {
                    int defaultTextEnd = Math.min(tokenStart, clipEndOffset);
                    fragmentsList.add(this.getDefaultStyleName(), lastEndOffset, defaultTextEnd);
                }
                this.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStartOffset, clipEndOffset);
                lastEndOffset = tokenEnd;
            }
            lexer.setTextBuffer(null);
        }
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        String tokenStyleName = this.mapTokenToStyleName(token);
        if ((tokenStart = Math.max(clipStart, tokenStart)) < (tokenEnd = Math.min(clipEnd, tokenEnd))) {
            fragmentsList.add(tokenStyleName, tokenStart, tokenEnd);
        }
    }

    protected abstract String mapTokenToStyleName(int var1);

    protected String getDefaultStyleName() {
        return "base-plain-style";
    }
}

