/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;

public final class HistoryReadTextBuffer
implements ReadTextBuffer {
    private static HistoryReadTextBuffer singleton = new HistoryReadTextBuffer();
    private ReadTextBuffer buffer;
    private char[] changedData;
    private int changedOffset;
    private int changedLength;
    private boolean isInsert;

    public static synchronized HistoryReadTextBuffer acquireReadTextBuffer(ReadTextBuffer buffer, BasicDocumentEvent event) {
        HistoryReadTextBuffer dcBuffer = singleton;
        singleton = null;
        if (dcBuffer == null) {
            dcBuffer = new HistoryReadTextBuffer();
        }
        dcBuffer.setBuffer(buffer, event);
        return dcBuffer;
    }

    public static synchronized void releaseReadTextBuffer(HistoryReadTextBuffer buffer) {
        buffer.clearBuffer();
        singleton = buffer;
    }

    private HistoryReadTextBuffer() {
    }

    private void setBuffer(ReadTextBuffer readTextBuffer, BasicDocumentEvent documentEvent) {
        this.isInsert = documentEvent.getType() == DocumentEvent.EventType.INSERT;
        this.changedLength = documentEvent.getLength();
        this.changedOffset = documentEvent.getOffset();
        this.changedData = documentEvent.getData();
        this.buffer = readTextBuffer;
    }

    private void clearBuffer() {
        this.buffer = null;
        this.changedData = null;
    }

    public int getLength() {
        return this.isInsert ? this.buffer.getLength() - this.changedLength : this.buffer.getLength() + this.changedLength;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        if (this.isInsert) {
            if (offset < this.changedOffset) {
                return this.buffer.getChar(offset);
            }
            return this.buffer.getChar(offset + this.changedLength);
        }
        if (offset < this.changedOffset) {
            return this.buffer.getChar(offset);
        }
        if (offset < this.changedOffset + this.changedLength) {
            return this.changedData[offset - this.changedOffset];
        }
        return this.buffer.getChar(offset - this.changedLength);
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.getChar(offset + i);
        }
        return chars;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (length == 0) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            if (offset > this.getLength()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(this.getChar(offset + i));
        }
        return builder.toString();
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        throw new IllegalStateException("not implemented");
    }

    public void readLock() {
        this.buffer.readLock();
    }

    public boolean tryReadLock() {
        return this.buffer.tryReadLock();
    }

    public void readUnlock() {
        this.buffer.readUnlock();
    }

    public int getLockStatus() {
        return this.buffer.getLockStatus();
    }
}

