/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class DefaultWordLocator
implements WordLocator {
    private LanguageSupport support;

    public DefaultWordLocator(LanguageSupport support) {
        this.support = support;
    }

    @Override
    public int getWordStart(int offset) {
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        boolean spaceChange = false;
        boolean lineStart = true;
        boolean lineEnd = false;
        while (offset > 0) {
            if (this.isWordStart(offset, caseChange, spaceChange, lineStart, lineEnd)) {
                return offset;
            }
            --offset;
            spaceChange = true;
        }
        return 0;
    }

    @Override
    public int getPreviousWordStart(int offset) {
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        boolean spaceChange = false;
        boolean lineStart = DefaultWordLocator.useLineStartForWordBoundary();
        boolean lineEnd = DefaultWordLocator.useLineEndForWordBoundary();
        while (--offset > 0) {
            if (!this.isWordStart(offset, caseChange, spaceChange, lineStart, lineEnd)) continue;
            return offset;
        }
        return 0;
    }

    @Override
    public int getNextWordStart(int offset) {
        int length = this.getTextBuffer().getLength();
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        boolean spaceChange = false;
        boolean lineStart = DefaultWordLocator.useLineStartForWordBoundary();
        boolean lineEnd = DefaultWordLocator.useLineEndForWordBoundary();
        while (++offset < length) {
            if (!this.isWordStart(offset, caseChange, spaceChange, lineStart, lineEnd)) continue;
            return offset;
        }
        return length;
    }

    @Override
    public int getWordEnd(int offset) {
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        if (offset == this.getWordStart(offset)) {
            ++offset;
        }
        int length = this.getTextBuffer().getLength();
        boolean spaceChange = false;
        boolean lineStart = false;
        boolean lineEnd = true;
        while (offset < length) {
            if (this.isWordEnd(offset, caseChange, spaceChange, lineStart, lineEnd)) {
                return offset;
            }
            ++offset;
            spaceChange = true;
        }
        return length;
    }

    @Override
    public int getPreviousWordEnd(int offset) {
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        boolean spaceChange = false;
        boolean lineStart = DefaultWordLocator.useLineStartForWordBoundary();
        boolean lineEnd = DefaultWordLocator.useLineEndForWordBoundary();
        while (--offset > 0) {
            if (!this.isWordStart(offset, caseChange, spaceChange, lineStart, lineEnd)) continue;
            return offset;
        }
        return 0;
    }

    @Override
    public int getNextWordEnd(int offset) {
        int length = this.getTextBuffer().getLength();
        boolean caseChange = DefaultWordLocator.useCaseChangeForWordBoundary();
        boolean spaceChange = false;
        boolean lineStart = DefaultWordLocator.useLineStartForWordBoundary();
        boolean lineEnd = DefaultWordLocator.useLineEndForWordBoundary();
        while (++offset < length) {
            if (!this.isWordEnd(offset, caseChange, spaceChange, lineStart, lineEnd)) continue;
            return offset;
        }
        return length;
    }

    protected final ReadTextBuffer getTextBuffer() {
        return this.support.getDocument().getTextBuffer();
    }

    protected boolean isSpaceCharacter(int c) {
        return Character.isWhitespace(c);
    }

    protected boolean isIdentifierCharacter(int c, boolean caseChange) {
        return c != 95 ? Character.isJavaIdentifierPart(c) : !caseChange;
    }

    protected boolean isWordStart(int offset, boolean caseChange, boolean spaceChange, boolean lineStart, boolean lineEnd) {
        ReadTextBuffer buffer = this.getTextBuffer();
        int length = buffer.getLength();
        if (offset <= 0 || offset >= length) {
            return true;
        }
        char next = buffer.getChar(offset);
        char previous = buffer.getChar(offset - 1);
        if (this.isSpaceCharacter(next)) {
            if (spaceChange && !this.isSpaceCharacter(previous)) {
                return true;
            }
            if (lineEnd && next == '\n') {
                return true;
            }
            return lineStart && previous == '\n';
        }
        if (this.isIdentifierCharacter(next, caseChange)) {
            if (this.isSpaceCharacter(previous)) {
                return true;
            }
            if (this.isIdentifierCharacter(previous, caseChange)) {
                if (!caseChange) {
                    return false;
                }
                if (Character.isLowerCase((int)next)) {
                    return false;
                }
                if (Character.isLowerCase((int)previous)) {
                    return true;
                }
                if (offset + 1 >= length) {
                    return false;
                }
                return Character.isLowerCase(this.getTextBuffer().getChar(offset + 1));
            }
            return true;
        }
        if (this.isSpaceCharacter(previous)) {
            return true;
        }
        return this.isIdentifierCharacter(previous, caseChange);
    }

    protected boolean isWordEnd(int offset, boolean caseChange, boolean spaceChange, boolean lineStart, boolean lineEnd) {
        ReadTextBuffer buffer = this.getTextBuffer();
        int length = buffer.getLength();
        if (offset <= 0 || offset >= length) {
            return true;
        }
        char previous = buffer.getChar(offset - 1);
        char next = buffer.getChar(offset);
        if (this.isSpaceCharacter(previous)) {
            if (spaceChange && !this.isSpaceCharacter(next)) {
                return true;
            }
            if (lineEnd && next == '\n') {
                return true;
            }
            return lineStart && previous == '\n';
        }
        if (this.isIdentifierCharacter(previous, caseChange)) {
            if (this.isSpaceCharacter(next)) {
                return true;
            }
            if (this.isIdentifierCharacter(next, caseChange)) {
                if (!caseChange) {
                    return false;
                }
                if (Character.isLowerCase((int)next)) {
                    return false;
                }
                if (Character.isLowerCase((int)previous)) {
                    return true;
                }
                if (offset + 1 >= length) {
                    return false;
                }
                return Character.isLowerCase(this.getTextBuffer().getChar(offset + 1));
            }
            return true;
        }
        if (this.isSpaceCharacter(next)) {
            return true;
        }
        return this.isIdentifierCharacter(next, caseChange);
    }

    protected static boolean useCaseChangeForWordBoundary() {
        return EditorProperties.getProperties().getBooleanProperty("word-boundary-use-case");
    }

    protected static boolean useLineStartForWordBoundary() {
        return EditorProperties.getProperties().getBooleanProperty("word-boundary-use-line-start");
    }

    protected static boolean useLineEndForWordBoundary() {
        return EditorProperties.getProperties().getBooleanProperty("word-boundary-use-line-end");
    }
}

