/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.editor.folding.FoldingBlock;

public abstract class AbstractFoldingBlock
implements FoldingBlock {
    private FoldingBlock parent;
    private List children;
    private boolean isExpanded;

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    @Override
    public FoldingBlock getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FoldingBlock parent) {
        this.parent = parent;
    }

    @Override
    public void add(FoldingBlock child) {
        FoldingBlock oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
    }

    @Override
    public void remove(FoldingBlock child) {
        if (this.children != null && this.children.remove(child)) {
            child.setParent(null);
        }
    }

    @Override
    public void removeAll() {
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            FoldingBlock child = (FoldingBlock)it.next();
            child.setParent(null);
        }
        if (this.children != null) {
            this.children.clear();
        }
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public Iterator getChildren() {
        return this.children != null ? this.children.iterator() : Collections.EMPTY_LIST.iterator();
    }

    @Override
    public int length() {
        int endOffset = this.getEndOffset();
        int startOffset = this.getStartOffset();
        return Math.abs(endOffset - startOffset);
    }

    @Override
    public boolean bounds(int offset) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        return offset > startOffset && offset < endOffset;
    }

    @Override
    public abstract int getStartOffset();

    @Override
    public abstract int getEndOffset();

    @Override
    public abstract String getReplacementText();
}

