/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.LocaleUtils;

class BasicEditorToolTip
extends JToolTip {
    private MultiLineLabel _multiLineLabel;
    private JLabel _jLabel;

    @Override
    public void updateUI() {
        super.updateUI();
        this.setLayout(new BorderLayout());
        if (this._jLabel == null) {
            this._jLabel = new JLabel();
            this._jLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
            this._jLabel.setBackground(UIManager.getColor("ToolTip.background"));
            this._jLabel.setFont(UIManager.getFont("ToolTip.font"));
            this.add(this._jLabel);
        }
        this._multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
        this._multiLineLabel.setMaximumColumns(80);
        this._multiLineLabel.setPreferredAspectRatio(30.0f);
        this._multiLineLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
        this._multiLineLabel.setBackground(UIManager.getColor("ToolTip.background"));
        this._multiLineLabel.setFont(UIManager.getFont("ToolTip.font"));
    }

    @Override
    public void setTipText(String text) {
        this._jLabel.setText(text);
        this._multiLineLabel.setText(text);
        this.removeAll();
        if (text == null || text.toLowerCase().startsWith("<html>")) {
            this.add(this._jLabel);
        } else {
            this.add((Component)this._multiLineLabel);
        }
        super.setTipText(text);
    }

    @Override
    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)this.getComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.getLayout().preferredLayoutSize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.getLayout().minimumLayoutSize(this);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        UIUtils.fillBackground((Graphics)g, (JComponent)this);
    }
}

