/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorToolTip;
import oracle.javatools.editor.BasicEditorUI;
import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.NavigationListener;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.keys.KeyHandlerFactory;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;
import oracle.javatools.ui.Components;
import oracle.javatools.util.Log;
import oracle.javatools.util.WeightedList;

public class BasicEditorPane
extends JEditorPane
implements ActionInvoker,
Autoscroll,
PropertyChangeListener {
    private static final Log LOG = new Log("expiration");
    private HashMap properties;
    private MultiKeyHandler handler;
    private final ArrayList layerList;
    private ArrayList pluginList;
    private PopupManager popupManager;
    private ToolTipProvider tooltipProvider;
    private FeedbackManager feedbackManager;
    private final ArrayList<CharacterTypedListener> typedListeners;
    private final List<NavigationListener> navigationListeners = new ArrayList<NavigationListener>();
    private WeightedList<ActionPreInvoker> preInvokers;
    private ArrayList<ActionHookInvoker> hookInvokers;
    private ArrayList<ActionPostInvoker> postInvokers;
    private boolean isProtected;
    private boolean isEditable;
    private boolean isReadOnly;
    private OffsetMark limitStartOff;
    private OffsetMark limitEndOff;
    private CodeExpansionL codeExpansionL = new CodeExpansionL();
    private int beginEditCount;
    private int beginNavigationCount;
    private DocEdit editInProgress;
    private NavEdit navInProgress;
    private boolean undoInProgress;
    private UndoHelper undoHelper;
    private static final String UNDO_NAVIGATION = "undo-navigation";
    private WeakReference<BasicEditorPane> reference = new WeakReference<BasicEditorPane>(this);
    static final EditDescriptor cutDescriptor;
    static final EditDescriptor pasteDescriptor;
    static final EditDescriptor replaceDescriptor;
    static final EditDescriptor duplicateDescriptor;
    static final EditDescriptor deletePrevDescriptor;
    private static final EditDescriptor navigateDescriptor;
    private static final String MERGE_NAVIGATION = "merge-navigation";
    private static final String EDIT_MERGE_COUNT = "edit-merge-count";
    private static final String NAVIGATION_MERGE_COUNT = "navigation-merge-count";

    public BasicEditorPane() {
        this.updateColors();
        this.updateFont();
        this.popupManager = null;
        this.tooltipProvider = null;
        this.feedbackManager = null;
        this.isProtected = false;
        this.isReadOnly = false;
        this.isEditable = this.isEditable();
        this.beginEditCount = 0;
        this.beginNavigationCount = 0;
        this.editInProgress = null;
        this.navInProgress = null;
        this.undoInProgress = false;
        this.undoHelper = new UndoHelper();
        this.addFocusListener(this.undoHelper);
        this.layerList = new ArrayList();
        this.typedListeners = new ArrayList();
        this.preInvokers = new WeightedList();
        this.postInvokers = new ArrayList();
        BasicDocument document = (BasicDocument)this.getDocument();
        document.addPropertyChangeListener(this);
        this.installKeyboardSupport();
        this.pluginList = new ArrayList();
        this.installBuiltInPlugins();
    }

    public void setLanguageSupport(String fileName) {
        BasicDocument document = (BasicDocument)this.getDocument();
        document.setLanguageSupport(fileName);
    }

    public void beginEdit(EditDescriptor editDescriptor) {
        ++this.beginEditCount;
        if (this.beginEditCount == 1) {
            if (this.beginNavigationCount > 0) {
                System.err.println("Navigation count: " + this.beginNavigationCount);
            }
            if (this.editInProgress != null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            BasicDocument document = (BasicDocument)this.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            textBuffer.beginEdit();
            this.editInProgress = new DocEdit();
            this.editInProgress.recordCaretStart(this, editDescriptor);
        }
    }

    public void beginFormatEdit(EditDescriptor editDescriptor) {
        ++this.beginEditCount;
        if (this.beginEditCount == 1) {
            if (this.beginNavigationCount > 0) {
                System.err.println("Navigation count: " + this.beginNavigationCount);
            }
            if (this.editInProgress != null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            this.editInProgress = new DocEdit();
            this.editInProgress.recordCaretStart(this, editDescriptor);
        }
    }

    public void endEdit(boolean mergeIntoPrevious, UndoableEdit wrappedEdit) {
        if (this.beginEditCount == 0) {
            throw new IllegalStateException("Unmatched endEdit");
        }
        --this.beginEditCount;
        if (this.beginEditCount == 0) {
            if (this.editInProgress == null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            DocEdit endingEdit = this.editInProgress;
            this.editInProgress = null;
            if (mergeIntoPrevious) {
                endingEdit.requestForceMerge();
            }
            endingEdit.recordCaretEnd(this);
            BasicDocument document = (BasicDocument)this.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            UndoableEdit edit = textBuffer.endEdit();
            endingEdit.recordEdit(edit);
            if (wrappedEdit != null) {
                CompoundEdit compoundEdit = new CompoundEdit();
                compoundEdit.addEdit(endingEdit);
                compoundEdit.addEdit(wrappedEdit);
                compoundEdit.end();
                this.undoHelper.fireUndoableEditEvent(document, compoundEdit);
            } else {
                this.undoHelper.fireUndoableEditEvent(document, endingEdit);
            }
        }
    }

    public void endFormatEdit(boolean mergeIntoPrevious, UndoableEdit formattedEdit) {
        if (this.beginEditCount == 0) {
            throw new IllegalStateException("Unmatched endEdit");
        }
        --this.beginEditCount;
        if (this.beginEditCount == 0) {
            if (this.editInProgress == null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            DocEdit endingEdit = this.editInProgress;
            this.editInProgress = null;
            if (mergeIntoPrevious) {
                endingEdit.requestForceMerge();
            }
            endingEdit.recordCaretEnd(this);
            BasicDocument document = (BasicDocument)this.getDocument();
            if (formattedEdit != null) {
                endingEdit.recordEdit(formattedEdit);
                this.undoHelper.fireUndoableEditEvent(document, endingEdit);
            }
        }
    }

    public void endEdit() {
        this.endEdit(false);
    }

    public void endEdit(boolean mergeIntoPrevious) {
        this.endEdit(mergeIntoPrevious, null);
    }

    public void beginNavigation() {
        if (!this.isUndoInProgress() && this.beginEditCount == 0) {
            if (this.isNavigationUndoable()) {
                ++this.beginNavigationCount;
                if (this.beginNavigationCount == 1) {
                    if (this.navInProgress != null) {
                        throw new IllegalStateException("Unexpected beginNavigation()");
                    }
                    this.navInProgress = new NavEdit();
                    this.navInProgress.recordCaretStart(this, BasicEditorPane.navigateDescriptor);
                }
            } else {
                this.undoHelper.clearNextMerge();
            }
        }
    }

    public void endNavigation() {
        if (!this.isUndoInProgress() && this.beginEditCount == 0) {
            if (this.isNavigationUndoable()) {
                --this.beginNavigationCount;
                if (this.beginNavigationCount == 0) {
                    if (this.navInProgress == null) {
                        throw new IllegalStateException("Unexpected endNavigation()");
                    }
                    NavEdit endingEdit = this.navInProgress;
                    this.navInProgress = null;
                    endingEdit.recordCaretEnd(this);
                    BasicDocument document = (BasicDocument)this.getDocument();
                    this.undoHelper.fireUndoableEditEvent(document, endingEdit);
                }
            } else {
                this.undoHelper.clearNextMerge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        this.beginNavigation();
        try {
            int offset = this.getCaretPosition();
            this.setCaretPosition(offset);
        }
        finally {
            this.endNavigation();
        }
    }

    public void setCaretPositionCenter(int position) {
        Document document = this.getDocument();
        if (document != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            this.ensureVisibleAndCentered(position);
            this.setCaretPosition(position, true);
        }
    }

    public void moveCaretPositionCenter(int position) {
        Components.moveCaretPositionCenter((JTextComponent)this, (int)position);
    }

    public void ensureCaretVisible() {
        int position = this.getCaretPosition();
        this.ensurePositionVisible(position);
    }

    public void ensurePositionVisible(int position) {
        Document document = this.getDocument();
        if (document != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            this.ensureVisibleAndCentered(position);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.undoHelper != null) {
            Container parent;
            EmacsAction.removeMark(this);
            this.reference.clear();
            if (this.undoHelper != null) {
                this.removeFocusListener(this.undoHelper);
                this.undoHelper = null;
            }
            if ((parent = this.getParent()) != null) {
                parent.remove(this);
            }
            if (this.pluginList != null) {
                this.deinstallAllPlugins();
                this.pluginList = null;
            }
            if (this.tooltipProvider != null) {
                this.removeToolTipProvider(this.tooltipProvider);
            }
            TextBuffer buffer = ((BasicDocument)this.getDocument()).getTextBuffer();
            if (this.limitStartOff != null) {
                buffer.removeOffsetMark(this.limitStartOff);
            }
            if (this.limitEndOff != null) {
                buffer.removeOffsetMark(this.limitEndOff);
            }
            this.codeExpansionL.listenTo(null);
            this.removeAllHighlights();
            this.layerList.clear();
            this.deinstallKeyboardSupport();
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean makeProtected) {
        this.isProtected = makeProtected;
        this.updateEditable();
    }

    protected boolean isCutCopyLineEnabled() {
        return this.getBooleanProperty("cut-copy-line");
    }

    public boolean canCut() {
        boolean canCut = this.canCopy() && this.isEditable() && this.isEnabled();
        return canCut;
    }

    public boolean canCopy() {
        boolean canCopy = this.isCutCopyLineEnabled() || this.hasSelection();
        return canCopy;
    }

    public boolean canPaste() {
        return this.isEditable() && this.isValidClipboardContent();
    }

    public boolean isValidClipboardContent() {
        EditorProperties properties = EditorProperties.getProperties();
        boolean expensiveCheck = properties.getBooleanProperty("check-clipboard-for-paste");
        if (!expensiveCheck) {
            return true;
        }
        Toolkit toolkit = this.getToolkit();
        Clipboard systemClipboard = toolkit.getSystemClipboard();
        Transferable clipContents = systemClipboard.getContents(this);
        if (clipContents != null) {
            if (clipContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return true;
            }
            try {
                Object data = clipContents.getTransferData(DataFlavor.stringFlavor);
                String stringData = (String)data;
                if (stringData != null && stringData.length() > 0) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasSelection() {
        int selectEnd;
        int selectStart = this.getSelectionStart();
        boolean hasSelection = selectStart != (selectEnd = this.getSelectionEnd());
        return hasSelection;
    }

    public FontHelper getFontHelper() {
        return (FontHelper)this.getProperty("font-helper");
    }

    public void setBaseFont(String fontFamily, int fontSize) {
        FontHelper fontHelper = new FontHelper(fontFamily, fontSize);
        this.setFontHelper(fontHelper);
        this.updateFont();
        Font baseFont = fontHelper.getBaseFont();
        this.putProperty("editor-font", baseFont);
    }

    public StyleRegistry getStyleRegistry() {
        return (StyleRegistry)this.getProperty("style-registry");
    }

    public void setStyleRegistry(StyleRegistry registry) {
        this.putProperty("style-registry", registry);
    }

    public HighlightRegistry getHighlightRegistry() {
        return (HighlightRegistry)this.getProperty("highlight-registry");
    }

    public void setHighlightRegistry(HighlightRegistry registry) {
        this.putProperty("highlight-registry", registry);
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
        this.updateEditable();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new BasicEditorKit();
    }

    @Override
    public void updateUI() {
        TextUI currentUI = this.getUI();
        if (currentUI == null || !(currentUI instanceof BasicEditorUI)) {
            this.setUI(BasicEditorUI.createUI(this));
            this.invalidate();
        }
    }

    @Override
    public void setDocument(Document doc) {
        this.setCaretPosition(0);
        EmacsAction.removeMark(this);
        this.removeAllHighlights();
        Document old = this.getDocument();
        super.setDocument(doc);
        if (old != null) {
            BasicDocument oldDocument = (BasicDocument)old;
            oldDocument.removePropertyChangeListener(this);
        }
        if (doc != null) {
            BasicDocument newDocument = (BasicDocument)doc;
            newDocument.addPropertyChangeListener(this);
            TextBuffer textBuffer = newDocument.getTextBuffer();
            this.isReadOnly = textBuffer.isReadOnly();
            this.updateEditable();
        }
        this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }

    @Override
    public String getSelectedText() {
        if (this.getCaret() instanceof BasicCaret) {
            return ((BasicCaret)this.getCaret()).getEditorSelection().getSelectedText();
        }
        return super.getSelectedText();
    }

    protected void setClipboardContents(String contentText) {
        Toolkit toolkit = this.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        StringSelection contents = new StringSelection(contentText);
        for (int i = 0; i < 5; ++i) {
            try {
                clipboard.setContents(contents, null);
                return;
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cut() {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        BasicDocument document = (BasicDocument)this.getDocument();
        document.readLock();
        try {
            if (this.getSelectionStart() == this.getSelectionEnd() && !this.isCutCopyLineEnabled()) {
                return;
            }
        }
        finally {
            document.readUnlock();
        }
        this.beginEdit(cutDescriptor);
        try {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (start == end && this.isCutCopyLineEnabled()) {
                int offset = this.getCaretPosition();
                LineMap lineMap = document.getLineMap();
                int currentLine = lineMap.getLineFromOffset(offset);
                start = lineMap.getLineStartOffset(currentLine);
                end = lineMap.getLineEndOffset(currentLine);
            }
            if (start != end) {
                String data = document.getText(start, end - start);
                this.setClipboardContents(data);
                document.remove(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.endEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy() {
        BasicDocument document = (BasicDocument)this.getDocument();
        document.readLock();
        try {
            boolean alreadyHasSelection;
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            boolean bl = alreadyHasSelection = start != end;
            if (start == end && this.isCutCopyLineEnabled()) {
                int offset = this.getCaretPosition();
                LineMap lineMap = document.getLineMap();
                int currentLine = lineMap.getLineFromOffset(offset);
                start = lineMap.getLineStartOffset(currentLine);
                end = lineMap.getLineEndOffset(currentLine);
            }
            if (start != end) {
                String data = document.getText(start, end - start);
                this.setClipboardContents(data);
                if (!alreadyHasSelection) {
                    this.setCaretPosition(end);
                    this.moveCaretPosition(start);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            document.readUnlock();
        }
    }

    @Override
    public void paste() {
        Toolkit toolkit = this.getToolkit();
        if (this.isEditable() && this.isEnabled()) {
            Clipboard clipboard = toolkit.getSystemClipboard();
            this.pasteFromClipboard(toolkit, clipboard);
        } else {
            toolkit.beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void duplicateSelection() {
        Toolkit toolkit = this.getToolkit();
        if (this.isEditable() && this.isEnabled()) {
            BasicDocument document = (BasicDocument)this.getDocument();
            document.readLock();
            try {
                int start = this.getSelectionStart();
                int end = this.getSelectionEnd();
                if (start == end && this.isCutCopyLineEnabled()) {
                    int offset = this.getCaretPosition();
                    LineMap lineMap = document.getLineMap();
                    int currentLine = lineMap.getLineFromOffset(offset);
                    start = lineMap.getLineStartOffset(currentLine);
                    end = lineMap.getLineEndOffset(currentLine);
                }
                if (start == end) return;
                String data = document.getText(start, end - start);
                this.beginEdit(duplicateDescriptor);
                document.insertString(end, data, null);
                int length = end - start;
                this.select(end, end + length);
                this.endEdit();
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                document.readUnlock();
            }
        } else {
            toolkit.beep();
        }
    }

    protected void pasteFromClipboard(Toolkit toolkit, Clipboard clipboard) {
        Transferable transferable;
        if (clipboard != null && this.isEditable() && this.isEnabled() && (transferable = clipboard.getContents(this)) != null) {
            try {
                Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                String stringData = (String)data;
                if (stringData != null && stringData.length() > 0) {
                    this.beginEdit(pasteDescriptor);
                    super.replaceSelection(stringData);
                    this.endEdit();
                }
            }
            catch (Exception e) {
                toolkit.beep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        if (this.isEditable() && this.isEnabled()) {
            this.beginEdit(replaceDescriptor);
            try {
                Document document = this.getDocument();
                int docLength = document.getLength();
                if (docLength > 0) {
                    document.remove(0, docLength);
                }
                if (text != null && text.length() > 0) {
                    document.insertString(0, text, null);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.endEdit();
            }
        }
    }

    public void mergeReplaceSelection(String content) {
        if (this.isEditable() && this.isEnabled()) {
            this.beginEdit(replaceDescriptor);
            super.replaceSelection(content);
            this.endEdit(true);
        } else {
            this.getToolkit().beep();
        }
    }

    @Override
    public void replaceSelection(String content) {
        if (this.isEditable() && this.isEnabled()) {
            this.beginEdit(replaceDescriptor);
            super.replaceSelection(content);
            this.endEdit();
        } else {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.beginNavigation();
            try {
                super.selectAll();
            }
            finally {
                this.endNavigation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select(int selectionStart, int selectionEnd) {
        this.beginNavigation();
        try {
            super.select(selectionStart, selectionEnd);
        }
        finally {
            this.endNavigation();
        }
    }

    @Override
    public Highlighter getHighlighter() {
        return null;
    }

    @Override
    public void setHighlighter(Highlighter h) {
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public JToolTip createToolTip() {
        BasicEditorToolTip tip = new BasicEditorToolTip();
        tip.setComponent(this);
        return tip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.tooltipProvider != null) {
            Point point = new Point(event.getX(), event.getY());
            int offset = this.getUI().viewToModel(this, point);
            String tooltip = this.tooltipProvider.getToolTipText(this, event, offset);
            return tooltip;
        }
        return null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unitSize;
        int scrollInterval;
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        switch (orientation) {
            case 1: {
                scrollInterval = visibleRect.height >> 4;
                unitSize = metrics.getHeight();
                break;
            }
            case 0: {
                scrollInterval = visibleRect.width >> 4;
                unitSize = metrics.charWidth('m');
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + orientation);
            }
        }
        int scrollUnits = Math.max(1, scrollInterval / unitSize);
        return unitSize * scrollUnits;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        switch (orientation) {
            case 1: {
                int fontHeight = metrics.getHeight();
                int visibleRows = visibleRect.height / fontHeight;
                return fontHeight * visibleRows;
            }
            case 0: {
                int fontWidth = metrics.charWidth('m');
                int visibleColumns = visibleRect.width / fontWidth;
                return fontWidth * visibleColumns;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public void setCaretPosition(int position) {
        this.setCaretPosition(position, false);
    }

    public void setCaretPosition(int position, boolean isNavigation) {
        Document document;
        if (isNavigation) {
            this.removeViewLimits();
        }
        if ((document = this.getDocument()) != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            super.setCaretPosition(position);
        }
        if (isNavigation) {
            this.fireNavigationEvent(this.getCaretPosition());
        }
    }

    private void removeViewLimits() {
        this.removeValidOffsetStart();
        this.removeValidOffsetEnd();
    }

    public void remove(int offs, int len) throws BadLocationException {
        int i;
        if (this.limitStartOff != null && (i = this.limitStartOff.getOffset()) > -1 && offs < i) {
            throw new BadLocationException("Attempt to edit before view start offset", offs);
        }
        if (this.limitEndOff != null && (i = this.limitEndOff.getOffset()) > -1 && offs + len > i) {
            throw new BadLocationException("Attempt to edit after view end offset", offs + len);
        }
        this.getDocument().remove(offs, len);
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int i;
        if (this.limitStartOff != null && (i = this.limitStartOff.getOffset()) > -1 && offs < i) {
            throw new BadLocationException("Attempt to edit before view start offset", offs);
        }
        if (this.limitEndOff != null && (i = this.limitEndOff.getOffset()) > -1 && offs > i) {
            throw new BadLocationException("Attempt to edit after view end offset", offs);
        }
        this.getDocument().insertString(offs, str, a);
    }

    @Override
    public void moveCaretPosition(int position) {
        Document document = this.getDocument();
        if (document != null) {
            position = Math.min(position, document.getLength());
            position = Math.max(position, 0);
            super.moveCaretPosition(position);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle visibleRect = new Rectangle();
        this.computeVisibleRect(visibleRect);
        int horizontal = this.getScrollableUnitIncrement(visibleRect, 0, 1);
        int vertical = this.getScrollableUnitIncrement(visibleRect, 1, 1);
        int topInset = visibleRect.y + vertical;
        int leftInset = visibleRect.x + horizontal;
        int rightInset = this.getWidth() - visibleRect.width - visibleRect.x + horizontal;
        int bottomInset = this.getHeight() - visibleRect.height - visibleRect.y + vertical;
        Insets scrollInsets = new Insets(topInset, leftInset, bottomInset, rightInset);
        return scrollInsets;
    }

    @Override
    public void autoscroll(Point location) {
        int bottomY;
        int rightX;
        Rectangle visibleRect = new Rectangle();
        this.computeVisibleRect(visibleRect);
        int horizontal = this.getScrollableUnitIncrement(visibleRect, 0, 1);
        Insets scrollInsets = this.getAutoscrollInsets();
        if (location.x < scrollInsets.left) {
            visibleRect.x -= horizontal;
        }
        if (location.x > (rightX = this.getWidth() - scrollInsets.right)) {
            visibleRect.x += horizontal;
        }
        if (location.y < scrollInsets.top) {
            visibleRect.y -= horizontal;
        }
        if (location.y > (bottomY = this.getHeight() - scrollInsets.bottom)) {
            visibleRect.y += horizontal;
        }
        this.validateVisibleRect(visibleRect);
        this.scrollRectToVisible(visibleRect);
    }

    protected void validateVisibleRect(Rectangle visibleRect) {
        int editorHeight;
        visibleRect.x = Math.max(0, visibleRect.x);
        visibleRect.y = Math.max(0, visibleRect.y);
        int editorWidth = this.getWidth();
        if (visibleRect.x + visibleRect.width > editorWidth) {
            visibleRect.x = editorWidth - visibleRect.width;
        }
        if (visibleRect.y + visibleRect.height > (editorHeight = this.getHeight())) {
            visibleRect.y = editorHeight - visibleRect.height;
        }
    }

    public final synchronized Object getProperty(String key) {
        Object value = null;
        if (this.properties != null) {
            value = this.properties.get(key);
        }
        if (value == null) {
            Document document = this.getDocument();
            value = document != null ? document.getProperty(key) : EditorProperties.getProperties().getProperty(key);
        }
        return value;
    }

    public final synchronized void putProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        if (key.equals("code-folding-margin")) {
            CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)value;
            this.codeExpansionL.listenTo(codeFoldingMargin);
        }
        Object oldValue = this.properties.put(key, value);
        this.firePropertyChange(key, oldValue, value);
    }

    public synchronized boolean getBooleanProperty(String key) {
        Boolean boolValue = (Boolean)this.getProperty(key);
        return boolValue;
    }

    public synchronized void putBooleanProperty(String key, boolean value) {
        Boolean boolValue = value ? Boolean.TRUE : Boolean.FALSE;
        this.putProperty(key, boolValue);
    }

    public synchronized int getIntegerProperty(String key) {
        Integer intValue = (Integer)this.getProperty(key);
        return intValue;
    }

    public synchronized void putIntegerProperty(String key, int value) {
        Integer intValue = new Integer(value);
        this.putProperty(key, intValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        BasicEditorPane basicEditorPane = this;
        synchronized (basicEditorPane) {
            if (this.properties != null) {
                this.properties.remove(propertyName);
            }
        }
        if (propertyName.equals("selected-handler")) {
            this.deinstallKeyboardSupport();
            this.installKeyboardSupport();
        } else if (propertyName.equals("read-only-mode")) {
            Boolean readOnlyMode = (Boolean)event.getNewValue();
            this.isReadOnly = readOnlyMode;
            this.updateEditable();
        } else if (propertyName.equals("editor-font")) {
            this.setFontHelper(null);
            this.updateFont();
        } else if (propertyName.equals("code-folding-margin")) {
            CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)event.getNewValue();
            this.codeExpansionL.listenTo(codeFoldingMargin);
        } else if (propertyName.equals("show-whitespace-chars")) {
            this.repaint();
        }
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public int getLineCount() {
        BasicDocument document = (BasicDocument)this.getDocument();
        return document.getLineCount();
    }

    public int getLineFromOffset(int offset) {
        BasicDocument document = (BasicDocument)this.getDocument();
        return document.getLineFromOffset(offset);
    }

    public int getLineStartOffset(int line) {
        BasicDocument document = (BasicDocument)this.getDocument();
        return document.getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) {
        BasicDocument document = (BasicDocument)this.getDocument();
        return document.getLineEndOffset(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineFromRow(int row) {
        if (this.getUI() instanceof BasicTextUI) {
            BasicTextUI textUI = (BasicTextUI)this.getUI();
            Document doc = this.getDocument();
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                View view = textUI.getRootView(this);
                for (int i = 0; i < view.getViewCount(); ++i) {
                    View innerView = view.getView(0);
                    if (!(innerView instanceof BasicView)) continue;
                    int line = ((BasicView)innerView).getLineForRow(row - 1);
                    int n = line + 1;
                    return n;
                }
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
        int adjustedRow = row - 1;
        Insets insets = this.getInsets();
        Font f = this.getFont();
        int lineHeight = this.getFontMetrics(f).getHeight();
        int y = adjustedRow * lineHeight + insets.top;
        int rowStart = this.viewToModel(new Point(0, y));
        int line = this.getLineFromOffset(rowStart);
        return line + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowForLine(int line) {
        if (this.getUI() instanceof BasicTextUI) {
            BasicTextUI textUI = (BasicTextUI)this.getUI();
            Document doc = this.getDocument();
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                View view = textUI.getRootView(this);
                for (int i = 0; i < view.getViewCount(); ++i) {
                    int row;
                    View innerView = view.getView(0);
                    if (!(innerView instanceof BasicView)) continue;
                    int n = row = ((BasicView)innerView).getRowForLine(line);
                    return n;
                }
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreActionInvoker(ActionPreInvoker invoker, double weight) {
        WeightedList<ActionPreInvoker> weightedList = this.preInvokers;
        synchronized (weightedList) {
            this.preInvokers.addFirst((Object)invoker, weight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreActionInvoker(ActionPreInvoker invoker, double weight) {
        WeightedList<ActionPreInvoker> weightedList = this.preInvokers;
        synchronized (weightedList) {
            this.preInvokers.remove((Object)invoker, weight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preInvokeAction(String actionKey) {
        if (!this.preInvokers.isEmpty()) {
            WeightedList<ActionPreInvoker> weightedList = this.preInvokers;
            synchronized (weightedList) {
                int count = this.preInvokers.size();
                for (int i = 0; i < count; ++i) {
                    ActionPreInvoker invoker = (ActionPreInvoker)this.preInvokers.get(i);
                    if (!invoker.invokeAction(actionKey)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private synchronized ArrayList<ActionHookInvoker> getActionHookInvokers() {
        if (this.hookInvokers == null) {
            this.hookInvokers = new ArrayList();
        }
        return this.hookInvokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionHookInvoker(ActionHookInvoker invoker) {
        ArrayList<ActionHookInvoker> hInvokers;
        ArrayList<ActionHookInvoker> arrayList = hInvokers = this.getActionHookInvokers();
        synchronized (arrayList) {
            hInvokers.add(0, invoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionHookInvoker(ActionHookInvoker invoker) {
        ArrayList<ActionHookInvoker> hInvokers;
        ArrayList<ActionHookInvoker> arrayList = hInvokers = this.getActionHookInvokers();
        synchronized (arrayList) {
            int hookIndex = hInvokers.indexOf(invoker);
            if (hookIndex != -1) {
                hInvokers.remove(hookIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionPostInvoker(ActionPostInvoker invoker) {
        ArrayList<ActionPostInvoker> arrayList = this.postInvokers;
        synchronized (arrayList) {
            this.postInvokers.add(invoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionPostInvoker(ActionPostInvoker invoker) {
        ArrayList<ActionPostInvoker> arrayList = this.postInvokers;
        synchronized (arrayList) {
            int postIndex = this.postInvokers.indexOf(invoker);
            if (postIndex != -1) {
                this.postInvokers.remove(postIndex);
            }
        }
    }

    public ActionInvoker getActionInvoker() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAction(String actionKey) {
        BasicEditorKit kit;
        Action action;
        ArrayList<ActionHookInvoker> hInvokers = this.getActionHookInvokers();
        if (hInvokers.size() > 0) {
            ArrayList<ActionHookInvoker> arrayList = hInvokers;
            synchronized (arrayList) {
                int listSize = hInvokers.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    ActionHookInvoker invoker = hInvokers.get(i);
                    if (!invoker.invokeAction(actionKey)) continue;
                    this.notifyPostInvokers(actionKey);
                    return;
                }
            }
        }
        if ((action = (kit = (BasicEditorKit)this.getEditorKit()).findAction(actionKey)) != null && action.isEnabled()) {
            ActionEvent event = new ActionEvent(this, 1001, actionKey, 0);
            action.actionPerformed(event);
            this.notifyPostInvokers(actionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPostInvokers(String actionKey) {
        if (this.postInvokers.size() > 0) {
            ArrayList<ActionPostInvoker> arrayList = this.postInvokers;
            synchronized (arrayList) {
                int listSize = this.postInvokers.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    ActionPostInvoker invoker = this.postInvokers.get(i);
                    invoker.invokedAction(actionKey);
                }
            }
        }
    }

    public void installPlugin(EditorPlugin plugin) {
        if (plugin != null) {
            plugin.install(this);
            this.pluginList.add(plugin);
            this.addPropertyChangeListener(plugin);
        }
    }

    public void deinstallPlugin(EditorPlugin plugin) {
        int index;
        if (plugin != null && (index = this.pluginList.indexOf(plugin)) != -1) {
            this.removePropertyChangeListener(plugin);
            this.pluginList.remove(index);
            plugin.deinstall(this);
        }
    }

    protected void installBuiltInPlugins() {
    }

    protected void deinstallAllPlugins() {
        EditorPlugin[] plugins = this.pluginList.toArray(new EditorPlugin[this.pluginList.size()]);
        this.pluginList.clear();
        for (EditorPlugin plugin : plugins) {
            this.removePropertyChangeListener(plugin);
            try {
                plugin.deinstall(this);
            }
            catch (ExpiredTextBufferException e) {
                LOG.trace("handled expiration in BasicEditorPane: {0}", (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightLayer createHighlightLayer() {
        HighlightLayer layer = new HighlightLayer(this);
        ArrayList arrayList = this.layerList;
        synchronized (arrayList) {
            this.layerList.add(layer);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyHighlightLayer(HighlightLayer layer) {
        ArrayList arrayList = this.layerList;
        synchronized (arrayList) {
            int layerIndex = this.layerList.indexOf(layer);
            if (layerIndex != -1) {
                this.layerList.remove(layerIndex);
                layer.removeAllHighlights();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllHighlights() {
        if (this.layerList != null) {
            ArrayList arrayList = this.layerList;
            synchronized (arrayList) {
                int listSize = this.layerList != null ? this.layerList.size() : 0;
                for (int i = 0; i < listSize; ++i) {
                    HighlightLayer layer = (HighlightLayer)this.layerList.get(i);
                    layer.removeAllHighlights();
                }
            }
        }
    }

    protected Iterator getHighlightLayers() {
        if (this.layerList != null) {
            return this.layerList.iterator();
        }
        return null;
    }

    public void addPopupManager(PopupManager manager) {
        this.popupManager = manager;
    }

    public void removePopupManager(PopupManager manager) {
        this.popupManager = null;
    }

    public PopupManager getPopupManager() {
        return this.popupManager;
    }

    public void addToolTipProvider(ToolTipProvider provider) {
        this.tooltipProvider = provider;
        if (this.tooltipProvider != null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }
    }

    public void removeToolTipProvider(ToolTipProvider provider) {
        if (this.tooltipProvider != null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.unregisterComponent(this);
        }
        this.tooltipProvider = null;
    }

    public ToolTipProvider getToolTipProvider() {
        return this.tooltipProvider;
    }

    public void addFeedbackManager(FeedbackManager manager) {
        this.feedbackManager = manager;
    }

    public void removeFeedbackManager(FeedbackManager manager) {
        this.feedbackManager = null;
    }

    public FeedbackManager getFeedbackManager() {
        return this.feedbackManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterTypedListener(CharacterTypedListener listener) {
        ArrayList<CharacterTypedListener> arrayList = this.typedListeners;
        synchronized (arrayList) {
            this.typedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterTypedListener(CharacterTypedListener listener) {
        ArrayList<CharacterTypedListener> arrayList = this.typedListeners;
        synchronized (arrayList) {
            int typedIndex = this.typedListeners.indexOf(listener);
            if (typedIndex != -1) {
                this.typedListeners.remove(typedIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCharacterTypedEvent(int offset, char charTyped) {
        if (this.typedListeners.size() > 0) {
            ArrayList<CharacterTypedListener> arrayList = this.typedListeners;
            synchronized (arrayList) {
                int listSize = this.typedListeners.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    CharacterTypedListener listener = this.typedListeners.get(i);
                    listener.characterTyped(this, offset, charTyped);
                }
            }
        }
    }

    public void addNavigationListener(NavigationListener navigationListener) {
        if (!this.navigationListeners.contains(navigationListener)) {
            this.navigationListeners.add(navigationListener);
        }
    }

    public void removeNavigationListener(NavigationListener navigationListener) {
        this.navigationListeners.remove(navigationListener);
    }

    protected void fireNavigationEvent(int offset) {
        if (this.navigationListeners != null) {
            for (NavigationListener l : this.navigationListeners) {
                l.navigated(this, offset);
            }
        }
    }

    public void setValidOffsetBounds(int startOffset, int endOffset) {
        this.setValidOffsetStart(startOffset);
        this.setValidOffsetEnd(endOffset);
    }

    public int getValidOffsetStart() {
        return this.limitStartOff != null ? this.limitStartOff.getOffset() : -1;
    }

    public int getValidOffsetEnd() {
        return this.limitEndOff != null ? this.limitEndOff.getOffset() : -1;
    }

    private void setValidOffsetStart(int startOffset) {
        TextBuffer buf = ((BasicDocument)this.getDocument()).getTextBuffer();
        if (startOffset == -1) {
            this.removeValidOffsetStart();
        } else {
            int oldOffset;
            int n = oldOffset = this.limitStartOff == null ? -1 : this.limitStartOff.getOffset();
            if (this.limitStartOff == null) {
                this.limitStartOff = buf.addOffsetMark(startOffset, false);
            } else {
                this.limitStartOff.setOffset(startOffset);
            }
            this.firePropertyChange("valid-offset-start", oldOffset, startOffset);
        }
    }

    private void removeValidOffsetStart() {
        int oldOffset = this.limitStartOff == null ? -1 : this.limitStartOff.getOffset();
        TextBuffer buf = ((BasicDocument)this.getDocument()).getTextBuffer();
        if (this.limitStartOff != null) {
            buf.removeOffsetMark(this.limitStartOff);
        }
        this.limitStartOff = null;
        this.firePropertyChange("valid-offset-start", oldOffset, -1);
    }

    private void setValidOffsetEnd(int endOffset) {
        TextBuffer buf = ((BasicDocument)this.getDocument()).getTextBuffer();
        if (endOffset == -1) {
            this.removeValidOffsetEnd();
        } else {
            int oldOffset;
            int n = oldOffset = this.limitEndOff == null ? -1 : this.limitEndOff.getOffset();
            if (this.limitEndOff == null) {
                this.limitEndOff = buf.addOffsetMark(endOffset);
            } else {
                this.limitEndOff.setOffset(endOffset);
            }
            this.firePropertyChange("valid-offset-end", oldOffset, endOffset);
        }
    }

    private void removeValidOffsetEnd() {
        int oldOffset = this.limitEndOff == null ? -1 : this.limitEndOff.getOffset();
        TextBuffer buf = ((BasicDocument)this.getDocument()).getTextBuffer();
        if (this.limitEndOff != null) {
            buf.removeOffsetMark(this.limitEndOff);
        }
        this.limitEndOff = null;
        this.firePropertyChange("valid-offset-end", oldOffset, -1);
    }

    private void updateEditable() {
        boolean editable = !this.isProtected && this.isEditable && !this.isReadOnly;
        super.setEditable(editable);
    }

    private void setFontHelper(FontHelper helper) {
        this.putProperty("font-helper", helper);
    }

    private void updateFont() {
        FontHelper fontHelper = this.getFontHelper();
        super.setFont(fontHelper.getBaseFont());
    }

    protected void updateColors() {
        StyleRegistry registry = this.getStyleRegistry();
        BuiltInStyles builtInStyles = new BuiltInStyles(registry);
        this.setBackground(builtInStyles.plainStyle.getBackgroundColor());
        this.setForeground(builtInStyles.plainStyle.getForegroundColor());
        super.setOpaque(true);
    }

    protected boolean useDefaultKeyHandling() {
        return true;
    }

    protected void installKeyboardSupport() {
        if (this.useDefaultKeyHandling()) {
            EditorProperties globalProperties = EditorProperties.getProperties();
            String handlerName = globalProperties.getHandlerName();
            this.handler = KeyHandlerFactory.createHandler(handlerName);
            this.handler.install(this, this.getActionInvoker());
        }
    }

    protected void deinstallKeyboardSupport() {
        if (this.useDefaultKeyHandling() && this.handler != null) {
            this.handler.deinstall();
            this.handler = null;
        }
    }

    protected void ensureVisibleAndCentered(final int location) {
        boolean shouldForce = false;
        try {
            if (!this.isVisible()) {
                shouldForce = true;
            } else {
                Rectangle positionRect = this.modelToView(location);
                if (positionRect == null) {
                    shouldForce = true;
                }
            }
        }
        catch (BadLocationException e) {
            return;
        }
        final boolean passForce = shouldForce;
        Runnable centerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle positionRect = BasicEditorPane.this.modelToView(location);
                    BasicEditorPane.this.ensureVisibleAndCentered(positionRect, passForce);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(centerTask);
    }

    protected void ensureVisibleAndCentered(Rectangle positionRect) {
        this.ensureVisibleAndCentered(positionRect, false);
    }

    protected void ensureVisibleAndCentered(Rectangle positionRect, boolean force) {
        if (positionRect == null) {
            return;
        }
        Rectangle visibleRect = new Rectangle();
        this.computeVisibleRect(visibleRect);
        boolean doScroll = false;
        int visibleYstart = visibleRect.y;
        int visibleYend = visibleYstart + visibleRect.height;
        int positionYstart = positionRect.y;
        int positionYend = positionYstart + positionRect.height;
        if (force || positionYstart < visibleYstart || positionYend > visibleYend) {
            doScroll = true;
            visibleRect.y = positionYstart - (visibleRect.height - positionRect.height >> 1);
            visibleRect.y = Math.max(0, visibleRect.y);
            int editorHeight = this.getHeight();
            if (visibleRect.y + visibleRect.height > editorHeight) {
                visibleRect.y = editorHeight - visibleRect.height;
            }
        }
        int visibleXstart = visibleRect.x;
        int visibleXend = visibleXstart + visibleRect.width;
        int positionXstart = positionRect.x;
        int positionXend = positionXstart + positionRect.width;
        if (positionXstart < visibleXstart || positionXend > visibleXend) {
            doScroll = true;
            visibleRect.x = positionXstart - (visibleRect.width - positionRect.width >> 1);
            visibleRect.x = Math.max(0, visibleRect.x);
            int editorWidth = this.getWidth();
            if (visibleRect.x + visibleRect.width > editorWidth) {
                visibleRect.x = editorWidth - visibleRect.width;
            }
        }
        if (doScroll) {
            this.scrollRectToVisible(visibleRect);
        }
    }

    public boolean makeEditable() {
        if (this.isEditable()) {
            return true;
        }
        if (this.isProtected() || !this.isEnabled()) {
            return false;
        }
        try {
            this.fireVetoableChange("consumerVetoForMakeEditable", null, null);
            return false;
        }
        catch (PropertyVetoException pve) {
            try {
                this.fireVetoableChange("isEditable", Boolean.FALSE, Boolean.TRUE);
                BasicDocument document = (BasicDocument)this.getDocument();
                if (document.getTextBuffer().isReadOnly()) {
                    document.getTextBuffer().setReadOnly(false);
                    document.firePropertyChange("read-only-mode", Boolean.TRUE, Boolean.FALSE);
                }
                this.setEditable(true);
                if (this.isEditable()) {
                    return true;
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        try {
            boolean im = false;
            if (e.getID() == 1100) {
                this.beginEdit(new EditDescriptor("", "merge-typed-insert"));
                im = true;
            }
            super.processInputMethodEvent(e);
            if (im) {
                this.endEdit(true);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    private void setUndoInProgress(boolean inUndo) {
        this.undoInProgress = inUndo;
    }

    private boolean isNavigationUndoable() {
        EditorProperties properties = EditorProperties.getProperties();
        Object value = properties.getProperty(UNDO_NAVIGATION);
        return value != null && !value.equals(Boolean.FALSE);
    }

    private Reference getReference() {
        return this.reference;
    }

    static {
        Keymap defaultMap = BasicEditorPane.getKeymap("default");
        defaultMap.setDefaultAction(new BasicEditorKit.DefaultKeyTypedAction());
        BundleHelper resources = EditorProperties.getEditorBundle();
        String cutName = resources.getString("UNDO_CUT");
        cutDescriptor = new EditDescriptor(cutName);
        String pasteName = resources.getString("UNDO_PASTE");
        pasteDescriptor = new EditDescriptor(pasteName);
        String replaceName = resources.getString("UNDO_REPLACE");
        replaceDescriptor = new EditDescriptor(replaceName);
        String duplicateName = resources.getString("UNDO_DUPLICATE");
        duplicateDescriptor = new EditDescriptor(duplicateName);
        String deletePrevName = resources.getString("UNDO_DELETE_PREVIOUS");
        deletePrevDescriptor = new EditDescriptor(deletePrevName);
        String navigateName = resources.getString("UNDO_NAVIGATION");
        navigateDescriptor = new EditDescriptor(navigateName, MERGE_NAVIGATION);
    }

    private class CodeExpansionL
    implements CodeExpansionListener {
        private CodeFoldingMargin margin;

        private CodeExpansionL() {
        }

        public void listenTo(CodeFoldingMargin margin) {
            if (this.margin != null) {
                this.margin.removeCodeExpansionListener(this);
            }
            if (margin != null) {
                margin.addCodeExpansionListener(this);
            }
            this.margin = margin;
        }

        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            this.updateLimitedView();
        }

        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            this.updateLimitedView();
        }

        private void updateLimitedView() {
            int start = BasicEditorPane.this.limitStartOff == null ? -1 : BasicEditorPane.this.limitStartOff.getOffset();
            int end = BasicEditorPane.this.limitEndOff == null ? -1 : BasicEditorPane.this.limitEndOff.getOffset();
            BasicEditorPane.this.removeViewLimits();
            BasicEditorPane.this.setValidOffsetStart(start);
            BasicEditorPane.this.setValidOffsetEnd(end);
        }
    }

    private static final class DocEdit
    extends AbstractUndoableEdit {
        private int mergeCount = 1;
        private int startDot = -1;
        private int startMark = -1;
        private int endDot = -1;
        private int endMark = -1;
        private boolean forceMerge = false;
        private UndoableEdit wrappedEdit = null;
        private Reference editorReference = null;
        private EditDescriptor editDescriptor = null;

        private DocEdit() {
        }

        private void recordCaretStart(BasicEditorPane editorPane, EditDescriptor editDescriptor) {
            Caret caret = editorPane.getCaret();
            this.startDot = caret.getDot();
            this.startMark = caret.getMark();
            this.editorReference = editorPane.getReference();
            this.editDescriptor = editDescriptor;
        }

        private void requestForceMerge() {
            this.forceMerge = true;
        }

        private void recordEdit(UndoableEdit edit) {
            this.wrappedEdit = edit;
            if (this.wrappedEdit == null) {
                this.die();
            }
        }

        private void recordCaretEnd(BasicEditorPane editorPane) {
            Caret caret = editorPane.getCaret();
            this.endDot = caret.getDot();
            this.endMark = caret.getMark();
        }

        @Override
        public boolean canUndo() {
            boolean canUndo = super.canUndo();
            if (canUndo) {
                canUndo = this.wrappedEdit.canUndo();
            }
            return canUndo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
            editorPane.setUndoInProgress(true);
            try {
                super.undo();
                this.mergeCount = -1;
                Rectangle visibleRect = null;
                if (editorPane != null && editorPane.hasSelection()) {
                    visibleRect = new Rectangle();
                    editorPane.computeVisibleRect(visibleRect);
                    editorPane.setCaretPosition(0);
                }
                this.wrappedEdit.undo();
                if (editorPane != null) {
                    if (visibleRect != null) {
                        editorPane.scrollRectToVisible(visibleRect);
                    }
                    editorPane.requestFocus();
                    editorPane.setCaretPositionCenter(this.startMark);
                    editorPane.moveCaretPositionCenter(this.startDot);
                }
            }
            finally {
                editorPane.setUndoInProgress(false);
            }
        }

        @Override
        public boolean canRedo() {
            boolean canRedo = super.canRedo();
            if (canRedo) {
                canRedo = this.wrappedEdit.canRedo();
            }
            return canRedo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
            editorPane.setUndoInProgress(true);
            try {
                super.redo();
                this.wrappedEdit.redo();
                if (editorPane != null) {
                    editorPane.requestFocus();
                    editorPane.setCaretPositionCenter(this.endMark);
                    editorPane.moveCaretPositionCenter(this.endDot);
                }
            }
            finally {
                editorPane.setUndoInProgress(false);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof DocEdit) {
                boolean merged;
                DocEdit secondEdit = (DocEdit)anEdit;
                boolean canMerge = false;
                if (secondEdit.forceMerge) {
                    canMerge = true;
                } else if (this.editDescriptor.canMergeWith(secondEdit.editDescriptor)) {
                    int maxCount;
                    EditorProperties properties = EditorProperties.getProperties();
                    Integer value = (Integer)properties.getProperty(BasicEditorPane.EDIT_MERGE_COUNT);
                    int n = maxCount = value != null ? value : 1;
                    if (this.mergeCount < maxCount) {
                        canMerge = true;
                    }
                }
                if (canMerge && this.mergeCount != -1 && this.wrappedEdit != null && (merged = this.wrappedEdit.addEdit(secondEdit.wrappedEdit))) {
                    this.endDot = secondEdit.endDot;
                    this.endMark = secondEdit.endMark;
                    secondEdit.wrappedEdit = null;
                    secondEdit.die();
                    if (!this.forceMerge) {
                        ++this.mergeCount;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public void die() {
            super.die();
            this.editorReference = null;
            if (this.wrappedEdit != null) {
                this.wrappedEdit.die();
                this.wrappedEdit = null;
            }
        }

        @Override
        public String getPresentationName() {
            return this.editDescriptor.getEditName();
        }

        @Override
        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("start dot, mark: ").append(this.startDot).append(", ").append(this.startMark).append("\n");
            s.append("wrapped edit: ").append(this.wrappedEdit.toString()).append("\n");
            s.append("end dot, mark: ").append(this.endDot).append(", ").append(this.endMark).append("\n");
            return s.toString();
        }
    }

    private static final class NavEdit
    extends AbstractUndoableEdit {
        private int mergeCount = 1;
        private int startDot = -1;
        private int startMark = -1;
        private int endDot = -1;
        private int endMark = -1;
        private Reference editorReference = null;
        private EditDescriptor editDescriptor = null;

        private NavEdit() {
        }

        private void recordCaretStart(BasicEditorPane editorPane, EditDescriptor editDescriptor) {
            Caret caret = editorPane.getCaret();
            this.startDot = caret.getDot();
            this.startMark = caret.getMark();
            this.editorReference = editorPane.getReference();
            this.editDescriptor = editDescriptor;
        }

        private void recordCaretEnd(BasicEditorPane editorPane) {
            Caret caret = editorPane.getCaret();
            this.endDot = caret.getDot();
            this.endMark = caret.getMark();
            if (this.startDot == this.endDot && this.startMark == this.endMark) {
                this.die();
            }
        }

        @Override
        public boolean canUndo() {
            Object editor;
            boolean canUndo = super.canUndo();
            if (canUndo && (editor = this.editorReference.get()) == null) {
                canUndo = false;
            }
            return canUndo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
            editorPane.setUndoInProgress(true);
            try {
                super.undo();
                this.mergeCount = -1;
                if (editorPane != null) {
                    editorPane.requestFocus();
                    editorPane.setCaretPositionCenter(this.startMark);
                    editorPane.moveCaretPositionCenter(this.startDot);
                }
            }
            finally {
                editorPane.setUndoInProgress(false);
            }
        }

        @Override
        public boolean canRedo() {
            Object editor;
            boolean canRedo = super.canRedo();
            if (canRedo && (editor = this.editorReference.get()) == null) {
                canRedo = false;
            }
            return canRedo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
            editorPane.setUndoInProgress(true);
            try {
                super.redo();
                if (editorPane != null) {
                    editorPane.requestFocus();
                    editorPane.setCaretPositionCenter(this.endMark);
                    editorPane.moveCaretPositionCenter(this.endDot);
                }
            }
            finally {
                editorPane.setUndoInProgress(false);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof NavEdit) {
                NavEdit secondEdit = (NavEdit)anEdit;
                if (this.editDescriptor.canMergeWith(secondEdit.editDescriptor)) {
                    int maxCount;
                    EditorProperties properties = EditorProperties.getProperties();
                    Integer value = (Integer)properties.getProperty(BasicEditorPane.NAVIGATION_MERGE_COUNT);
                    int n = maxCount = value != null ? value : 1;
                    if (this.mergeCount != -1 && this.mergeCount < maxCount) {
                        this.endDot = secondEdit.endDot;
                        this.endMark = secondEdit.endMark;
                        secondEdit.die();
                        ++this.mergeCount;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public void die() {
            super.die();
            this.editorReference = null;
        }

        @Override
        public String getPresentationName() {
            return this.editDescriptor.getEditName();
        }

        @Override
        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("start dot, mark: ").append(this.startDot).append(", ").append(this.startMark).append("\n");
            s.append("end dot, mark: ").append(this.endDot).append(", ").append(this.endMark).append("\n");
            return s.toString();
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    private static final class UndoHelper
    implements FocusListener {
        UndoableEdit lastEdit = null;

        private UndoHelper() {
        }

        private synchronized void clearNextMerge() {
            this.lastEdit = null;
        }

        private synchronized void fireUndoableEditEvent(BasicDocument document, UndoableEdit edit) {
            boolean merged;
            if (edit == null || !edit.canUndo()) {
                this.clearNextMerge();
            }
            if (this.lastEdit != null && !(merged = this.lastEdit.addEdit(edit))) {
                this.lastEdit = null;
            }
            if (this.lastEdit == null) {
                this.lastEdit = edit;
                document.fireUndoableEditEvent(edit);
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.clearNextMerge();
        }
    }
}

