/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.resource.ProgressBundle;

public class ProgressChecklist {
    private static final int MAXIMUM_TABLE_HEIGHT = 350;
    private static final int ICON_SIZE = 16;
    private static final int[] ADDITIONAL_CELL_SPACING = new int[]{0, 5, 5};
    private static final Icon CURRENT_ICON = new ImageIcon(ProgressBundle.class.getResource(ProgressChecklist.getBundle().getString("CURRENT_ICON")));
    private final JPanel _panel;
    private final ChecklistTable _table;
    private final JScrollPane _scrollPane;
    private final TableColumn _statusColumn;
    private final int _rowCount;
    private int _stepPosition;

    public ProgressChecklist(Object message, String[] stepNames) {
        JPanel northPanel = null;
        JPanel centerPanel = new JPanel(new BorderLayout());
        if (message != null) {
            northPanel = new JPanel(new BorderLayout());
            Component messageComponent = message instanceof Component ? (Component)message : new JLabel(message.toString());
            northPanel.add(messageComponent, "North");
            northPanel.add(Box.createVerticalStrut(10), "Center");
        }
        JLabel statusLabel = new JLabel(ProgressChecklist.getBundle().getString("STATUS_LABEL_TEXT"));
        statusLabel.setDisplayedMnemonic((int)ProgressChecklist.getBundle().getString("STATUS_LABEL_MNEMONIC").charAt(0));
        this._rowCount = stepNames.length;
        Object[][] dataVector = new Object[this._rowCount][];
        for (int i = 0; i < dataVector.length; ++i) {
            dataVector[i] = new Object[]{null, stepNames[i], null};
        }
        DefaultTableModel tableModel = new DefaultTableModel(dataVector, new Object[3]);
        this._table = new ChecklistTable(tableModel);
        this._table.setShowGrid(true);
        this._table.setTableHeader(null);
        this._table.setDefaultRenderer(Object.class, new ChecklistTableCellRenderer());
        this._table.setAutoResizeMode(0);
        this._statusColumn = this._table.getColumnModel().getColumn(2);
        statusLabel.setLabelFor(this._table);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.getViewport().setBackground(this._table.getBackground());
        centerPanel.add((Component)statusLabel, "North");
        centerPanel.add((Component)this._scrollPane, "Center");
        this._panel = new JPanel(new BorderLayout());
        if (northPanel != null) {
            this._panel.add((Component)northPanel, "North");
        }
        this._panel.add((Component)centerPanel, "Center");
        this.reset();
        this.initializePreferredSize();
    }

    public Component getComponent() {
        return this._panel;
    }

    public void reset() {
        this._stepPosition = 0;
        for (int i = 0; i < this._rowCount; ++i) {
            this.setModelIconImpl(i, i == 0 ? CURRENT_ICON : new EmptyIcon());
            this.setModelStatusImpl(i, ProgressChecklist.getBundle().getString(i == 0 ? "STATUS_COLUMN_TEXT_IN_PROGRESS" : "STATUS_COLUMN_TEXT_PENDING"));
        }
        this._table.autoSizeColumnsToFit(ADDITIONAL_CELL_SPACING);
    }

    public void nextStep(boolean stepSuccessful) {
        if (this._stepPosition >= this._rowCount) {
            return;
        }
        this.setModelIcon(this._stepPosition, stepSuccessful ? OracleIcons.getIcon((String)"check.png") : OracleIcons.getIcon((String)"delete.png"));
        this.setModelStatus(this._stepPosition, ProgressChecklist.getBundle().getString(stepSuccessful ? "STATUS_COLUMN_TEXT_SUCCEEDED" : "STATUS_COLUMN_TEXT_FAILED"));
        this.nextPosition();
    }

    public void abortSteps() {
        while (!this.isFinished()) {
            this.nextStep(false);
        }
    }

    public void setStatusColumnVisible(final boolean visible) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                ProgressChecklist.this._table.getColumnModel().removeColumn(ProgressChecklist.this._statusColumn);
                if (visible) {
                    ProgressChecklist.this._table.getColumnModel().addColumn(ProgressChecklist.this._statusColumn);
                }
            }
        });
    }

    private boolean isFinished() {
        return this._stepPosition >= this._rowCount;
    }

    private void nextPosition() {
        if (++this._stepPosition >= this._rowCount) {
            return;
        }
        this.setModelIcon(this._stepPosition, CURRENT_ICON);
        this.setModelStatus(this._stepPosition, ProgressChecklist.getBundle().getString("STATUS_COLUMN_TEXT_IN_PROGRESS"));
    }

    private void setModelIcon(final int row, final Icon icon) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                ProgressChecklist.this.setModelIconImpl(row, icon);
            }
        });
    }

    private void setModelStatus(final int row, final String status) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                ProgressChecklist.this.setModelStatusImpl(row, status);
            }
        });
    }

    private void setModelIconImpl(int row, Icon icon) {
        this._table.getModel().setValueAt(icon, row, 0);
    }

    private void setModelStatusImpl(int row, String status) {
        this._table.getModel().setValueAt(status, row, 2);
    }

    private void initializePreferredSize() {
        Insets i = this._scrollPane.getInsets();
        int width = this._table.getPreferredSize().width;
        width += this._scrollPane.getVerticalScrollBar().getPreferredSize().width;
        width += i.left;
        width += i.right;
        width = Math.max(width, 350);
        int height = this._table.getPreferredSize().height;
        height += i.top;
        this._scrollPane.setPreferredSize(new Dimension(width, Math.min(height += i.bottom, 350)));
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ProgressBundle.class.getName());
    }

    private static final class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private static final class ChecklistTableCellRenderer
    extends DefaultTableCellRenderer {
        private JLabel _iconRenderer = new JLabel("");

        ChecklistTableCellRenderer() {
            this._iconRenderer.setPreferredSize(new Dimension(16, 16));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Icon) {
                this._iconRenderer.setIcon((Icon)value);
                return this._iconRenderer;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static final class ChecklistTable
    extends NiceTable {
        private static final int MINIMUM_COLUMN_WIDTH = 5;

        ChecklistTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void autoSizeColumnsToFit(int[] additionalSpacing) {
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                int maxWidth = 5;
                TableColumn column = this.getColumnModel().getColumn(i);
                for (int j = 0; j < this.getModel().getRowCount(); ++j) {
                    Object value = this.getModel().getValueAt(j, i);
                    TableCellRenderer cellRenderer = this.getCellRenderer(j, i);
                    if (cellRenderer == null && value == null) continue;
                    int preferredWidth = cellRenderer.getTableCellRendererComponent((JTable)this, (Object)value, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                    if (additionalSpacing != null) {
                        preferredWidth += additionalSpacing[i];
                    }
                    maxWidth = Math.max(preferredWidth, maxWidth);
                }
                column.setPreferredWidth(maxWidth);
            }
        }
    }
}

