/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.resource.ProgressBundle;

abstract class AbstractProgressMonitor {
    private ProgressPanel _panel;
    private ProgressDialog _dialog;
    private Component _parentComponent;
    private String _title;
    private Component _detailContent;
    private int _millisToPopup;
    private boolean _cancellable;
    private boolean _closeOnFinish;
    private boolean _detailVisible;
    private boolean _barVisible;
    private boolean _dialogWasCanceled = false;
    private final Throwable _creationThrowable;

    AbstractProgressMonitor(Component parentComponent, String title, Object message, String note) {
        this._panel = new ProgressPanel(message, note);
        this._parentComponent = parentComponent;
        this._title = title;
        this._cancellable = true;
        this._barVisible = true;
        this._closeOnFinish = true;
        this._creationThrowable = new Throwable();
    }

    public void setCloseOnFinish(boolean closeOnFinish) {
        this._closeOnFinish = closeOnFinish;
    }

    public boolean getCloseOnFinish() {
        return this._closeOnFinish;
    }

    public abstract void start();

    public synchronized void finish() {
        this.finishImpl(this._panel != null ? this._panel.getProgressBar() : null);
        if (this._closeOnFinish) {
            this.close();
        } else {
            this.changeToCloseState();
        }
    }

    public synchronized void close() {
        this.closeImpl();
    }

    public boolean isCanceled() {
        return this._dialog == null ? this._dialogWasCanceled : this._dialog.isCancelled();
    }

    public void setMillisToPopup(int millisToPopup) {
        this._millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this._millisToPopup;
    }

    public void setDetailContent(Component detailContent) {
        this._detailContent = detailContent;
    }

    public Component getDetailContent() {
        return this._detailContent;
    }

    public void setDetailVisible(boolean detailVisible) {
        this._detailVisible = detailVisible;
    }

    public boolean isDetailVisible() {
        return this._detailVisible;
    }

    public void setBarVisible(boolean barVisible) {
        this._barVisible = barVisible;
    }

    public boolean isBarVisible() {
        return this._barVisible;
    }

    public void setCancellable(boolean cancellable) {
        this._cancellable = cancellable;
    }

    public boolean isCancellable() {
        return this._cancellable;
    }

    public synchronized void display() {
        this.displayImpl();
    }

    public Component getComponent() {
        return this._dialog;
    }

    public boolean isCancelled() {
        return this.isCanceled();
    }

    public void uncancel() {
        if (this._dialog != null) {
            this._dialog.setCancelled(false);
        }
    }

    public ProgressPanel getPanel() {
        return this._panel;
    }

    protected JProgressBar createProgressBar() {
        return new JProgressBar();
    }

    protected void displayImpl() {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot display progress monitor from the AWT event thread.").printStackTrace();
        }
        this._dialogWasCanceled = false;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressDialog dialog;
                AbstractProgressMonitor abstractProgressMonitor = AbstractProgressMonitor.this;
                synchronized (abstractProgressMonitor) {
                    if (AbstractProgressMonitor.this._dialog != null) {
                        return;
                    }
                    if (AbstractProgressMonitor.this._panel == null) {
                        return;
                    }
                    dialog = AbstractProgressMonitor.this.createDialog();
                    if (!dialog.getOwner().isVisible()) {
                        return;
                    }
                    WindowUtils.registerWindow((Window)((Object)dialog));
                    AbstractProgressMonitor.this._dialog = dialog;
                }
                try {
                    dialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
    }

    protected void finishImpl(JProgressBar progressBar) {
    }

    protected void closeImpl() {
        if (this._dialog != null) {
            this._dialogWasCanceled = this._dialog.isCancelled();
            this.hideDialog((Dialog)((Object)this._dialog));
            this._dialog = null;
        }
        if (this._panel != null) {
            this._panel = null;
        }
    }

    private ProgressDialog createDialog() {
        if (this._barVisible) {
            this._panel.setProgressBar(this.createProgressBar());
        }
        ProgressDialog dialog = this.createDialogImpl();
        dialog.setContent(this._panel.getGUI());
        dialog.setDetailContent(this._detailContent);
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setLocationRelativeTo(this._parentComponent);
        return dialog;
    }

    private ProgressDialog createDialogImpl() {
        Frame f;
        int buttons = 0;
        if (this._cancellable) {
            buttons |= 2;
        }
        if (this._detailContent != null) {
            buttons |= 0x10;
        }
        DetailDialog dialog = null;
        Dialog d = DialogUtil.getAncestorDialog(this._parentComponent);
        if (d != null) {
            dialog = new ProgressDialog(d, this._title, buttons, this._closeOnFinish);
        }
        if (dialog == null && (f = DialogUtil.getAncestorFrame(this._parentComponent)) != null) {
            dialog = new ProgressDialog(f, this._title, buttons, this._closeOnFinish);
        }
        if (dialog == null) {
            throw new IllegalStateException("Parent for progress dialog not found.");
        }
        dialog.setDetailVisible(this._detailVisible);
        ((ProgressDialog)dialog).setCloseListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                AbstractProgressMonitor.this.close();
            }
        });
        return dialog;
    }

    private void hideDialog(final Dialog d) {
        if (EventQueue.isDispatchThread()) {
            d.dispose();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                AbstractProgressMonitor.this.hideDialog(d);
            }
        });
    }

    private void changeToCloseState() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                AbstractProgressMonitor abstractProgressMonitor = AbstractProgressMonitor.this;
                synchronized (abstractProgressMonitor) {
                    if (AbstractProgressMonitor.this._dialog != null) {
                        AbstractProgressMonitor.this._dialog.changeToCloseState();
                    }
                }
            }
        });
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ProgressBundle.class.getName());
    }

    private static final class ProgressDialog
    extends DetailDialog {
        private boolean _cancellable;
        private boolean _cancelled;
        private JButton _customButton;
        private boolean _closeState;
        private ActionListener _closeListener;
        private boolean _disposed;

        private ProgressDialog(Dialog dialog, String title, int buttonMask, boolean closeOnFinish) {
            super(dialog, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask, closeOnFinish);
        }

        private ProgressDialog(Frame frame, String title, int buttonMask, boolean closeOnFinish) {
            super(frame, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask, closeOnFinish);
        }

        @Override
        public void setContent(Component content) {
            if (content != null) {
                super.setContent(content);
            }
        }

        public void dispose() {
            if (this._disposed) {
                return;
            }
            WindowUtils.unregisterWindow((Window)((Object)this));
            super.dispose();
            this._disposed = true;
        }

        void setCloseListener(ActionListener l) {
            this._closeListener = l;
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        void setCancelled(boolean cancelled) {
            if (!this._cancellable) {
                return;
            }
            this._cancelled = cancelled;
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                this._customButton.setEnabled(!this._cancelled);
            }
        }

        void changeToCloseState() {
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                this._customButton.setEnabled(false);
            }
            this._closeState = true;
            this.changeToCloseButton();
        }

        protected void dismissDialog(boolean cancelled) {
        }

        private static final int adjustButtonMask(int buttonMask) {
            return (buttonMask & 2) > 0 ? buttonMask ^ 2 : buttonMask;
        }

        private void initializeDialog(int buttonMask, boolean closeOnFinish) {
            this._cancellable = (buttonMask & 2) > 0;
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            if (!this._cancellable && closeOnFinish) {
                return;
            }
            this._customButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
            this.addCustomButton(this._customButton);
            this._customButton.setEnabled(this._cancellable);
            ActionListener al = new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    if (ProgressDialog.this._closeState) {
                        if (ProgressDialog.this._closeListener != null) {
                            ProgressDialog.this._closeListener.actionPerformed(e);
                        }
                        return;
                    }
                    ProgressDialog.this.setCancelled(true);
                }
            };
            this._customButton.addActionListener(al);
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            this._customButton.registerKeyboardAction(al, stroke, 0);
        }

        private void changeToCloseButton() {
            if (EventQueue.isDispatchThread()) {
                if (this._customButton != null) {
                    this._customButton.setText(AbstractProgressMonitor.getBundle().getString("CLOSE_BUTTON_TEXT"));
                    this._customButton.setMnemonic(AbstractProgressMonitor.getBundle().getString("CLOSE_BUTTON_MNEMONIC").charAt(0));
                    this._customButton.setEnabled(true);
                }
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    ProgressDialog.this.changeToCloseButton();
                }
            });
        }
    }
}

